/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheDuplicateEntityConfigurationSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        c.setDiscoverySpi((DiscoverySpi)disco);
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassDuplicatesQueryEntity() throws Exception {
        String cacheName = "duplicate";
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("name", String.class.getName());
        entity.setFields(fields);
        ccfg.setQueryEntities(Arrays.asList(entity));
        try {
            this.ignite(0).getOrCreateCache(ccfg);
        }
        finally {
            this.ignite(0).destroyCache(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassDuplicatesQueryReverse() throws Exception {
        String cacheName = "duplicate";
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("name", String.class.getName());
        entity.setFields(fields);
        ccfg.setQueryEntities(Arrays.asList(entity));
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        try {
            this.ignite(0).getOrCreateCache(ccfg);
        }
        finally {
            this.ignite(0).destroyCache(cacheName);
        }
    }

    private static class Person {
        @QuerySqlField
        private String name;

        private Person() {
        }
    }
}

