/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheDistributedJoinTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static Connection conn;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder(IP_FINDER);
        CacheConfiguration ccfga = new CacheConfiguration("default");
        ccfga.setName("a");
        ccfga.setSqlSchema("A");
        ccfga.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfga.setBackups(1);
        ccfga.setCacheMode(CacheMode.PARTITIONED);
        ccfga.setIndexedTypes(new Class[]{Integer.class, A.class});
        CacheConfiguration ccfgb = new CacheConfiguration("default");
        ccfgb.setName("b");
        ccfgb.setSqlSchema("B");
        ccfgb.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfgb.setBackups(1);
        ccfgb.setCacheMode(CacheMode.PARTITIONED);
        ccfgb.setIndexedTypes(new Class[]{Integer.class, B.class});
        CacheConfiguration ccfgc = new CacheConfiguration("default");
        ccfgc.setName("c");
        ccfgc.setSqlSchema("C");
        ccfgc.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfgc.setBackups(1);
        ccfgc.setCacheMode(CacheMode.PARTITIONED);
        ccfgc.setIndexedTypes(new Class[]{Integer.class, C.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfga, ccfgb, ccfgc});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(4);
        this.awaitPartitionMapExchange();
        conn = DriverManager.getConnection("jdbc:h2:mem:");
        Statement s = conn.createStatement();
        s.execute("create schema a");
        s.execute("create schema b");
        s.execute("create schema c");
        s.execute("create table a.a(a bigint, b bigint, c bigint)");
        s.execute("create table b.b(a bigint, b bigint, c bigint)");
        s.execute("create table c.c(a bigint, b bigint, c bigint)");
        s.execute("create index on a.a(a)");
        s.execute("create index on a.a(b)");
        s.execute("create index on a.a(c)");
        s.execute("create index on b.b(a)");
        s.execute("create index on b.b(b)");
        s.execute("create index on b.b(c)");
        s.execute("create index on c.c(a)");
        s.execute("create index on c.c(b)");
        s.execute("create index on c.c(c)");
        GridRandom rnd = new GridRandom();
        Ignite ignite = this.ignite(0);
        IgniteCache a = ignite.cache("a");
        IgniteCache b = ignite.cache("b");
        IgniteCache c = ignite.cache("c");
        for (int i = 0; i < 100; ++i) {
            a.put((Object)i, (Object)IgniteCacheDistributedJoinTest.insert(s, new A(rnd.nextInt(50), rnd.nextInt(100), rnd.nextInt(150))));
            b.put((Object)i, (Object)IgniteCacheDistributedJoinTest.insert(s, new B(rnd.nextInt(100), rnd.nextInt(50), rnd.nextInt(150))));
            c.put((Object)i, (Object)IgniteCacheDistributedJoinTest.insert(s, new C(rnd.nextInt(150), rnd.nextInt(100), rnd.nextInt(50))));
        }
        this.checkSameResult(s, a, "select a, count(*) from a group by a order by a");
        this.checkSameResult(s, a, "select b, count(*) from a group by b order by b");
        this.checkSameResult(s, a, "select c, count(*) from a group by c order by c");
        this.checkSameResult(s, b, "select a, count(*) from b group by a order by a");
        this.checkSameResult(s, b, "select b, count(*) from b group by b order by b");
        this.checkSameResult(s, b, "select c, count(*) from b group by c order by c");
        this.checkSameResult(s, c, "select a, count(*) from c group by a order by a");
        this.checkSameResult(s, c, "select b, count(*) from c group by b order by b");
        this.checkSameResult(s, c, "select c, count(*) from c group by c order by c");
        s.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Z extends X> void checkSameResult(Statement s, IgniteCache<Integer, Z> c, String qry) throws SQLException {
        s.executeUpdate("SET SCHEMA " + c.getName());
        rs1 = s.executeQuery(qry);
        var5_5 = null;
        try {
            rs2 = c.query((Query)new SqlFieldsQuery(qry).setDistributedJoins(true));
            var7_8 = null;
            iter = rs2.iterator();
            while (true) {
                if (rs1.next()) ** GOTO lbl39
                IgniteCacheDistributedJoinTest.assertFalse((boolean)iter.hasNext());
                if (rs2 == null) return;
                if (var7_8 != null) {
                }
                ** GOTO lbl37
                break;
            }
            {
                catch (Throwable var8_10) {
                    var7_8 = var8_10;
                    throw var8_10;
                }
                catch (Throwable var11_15) {
                    if (rs2 == null) throw var11_15;
                    if (var7_8 == null) {
                        rs2.close();
                        throw var11_15;
                    }
                    try {
                        rs2.close();
                        throw var11_15;
                    }
                    catch (Throwable x2) {
                        var7_8.addSuppressed(x2);
                        throw var11_15;
                    }
                }
                try {
                    rs2.close();
                    return;
                }
                catch (Throwable x2) {
                    var7_8.addSuppressed(x2);
                    return;
                }
lbl37:
                // 1 sources

                rs2.close();
                return;
lbl39:
                // 1 sources

                ** try [egrp 5[TRYBLOCK] [8 : 174->299)] { 
lbl-1000:
                // 1 sources

                {
                    IgniteCacheDistributedJoinTest.assertTrue((boolean)iter.hasNext());
                    row = (List)iter.next();
                    i = 0;
                    while (true) {
                        if (i >= row.size()) ** continue;
                        IgniteCacheDistributedJoinTest.assertEquals((Object)rs1.getLong(i + 1), row.get(i));
                        ++i;
                    }
                }
            }
        }
lbl48:
        // 2 sources

        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            if (rs1 != null) {
                if (var5_5 != null) {
                    try {
                        rs1.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    rs1.close();
                }
            }
        }
    }

    private static <Z extends X> Z insert(Statement s, Z z) throws SQLException {
        String tbl = z.getClass().getSimpleName();
        tbl = tbl + "." + tbl;
        String insert = "insert into " + tbl + " values(" + z.a + ", " + z.b + ", " + z.c + ")";
        s.executeUpdate(insert);
        return z;
    }

    public void testJoins() throws Exception {
        Ignite ignite = this.ignite(0);
        IgniteCache a = ignite.cache("a");
        IgniteCache b = ignite.cache("b");
        IgniteCache c = ignite.cache("c");
        Statement s = conn.createStatement();
        this.checkSameResult(s, a, "select a.c, b.b, c.a from a.a, b.b, c.c where a.a = b.a and b.c = c.c order by a.c, b.b, c.a");
        this.checkSameResult(s, b, "select a.a, b.c, c.b from a.a, b.b, c.c where a.b = b.b and b.a = c.a order by a.a, b.c, c.b");
        this.checkSameResult(s, c, "select a.b, b.a, c.c from a.a, b.b, c.c where a.c = b.c and b.b = c.b order by a.b, b.a, c.c");
        for (int i = 0; i < 150; ++i) {
            this.checkSameResult(s, a, "select a.c, b.b, c.a from a.a, b.b, c.c where " + i + " = a.c and a.a = b.a and b.c = c.c order by a.c, b.b, c.a");
            this.checkSameResult(s, b, "select a.a, b.c, c.b from a.a, b.b, c.c where " + i + " = c.b and a.b = b.b and b.a = c.a order by a.a, b.c, c.b");
            this.checkSameResult(s, c, "select a.b, b.a, c.c from a.a, b.b, c.c where " + i + " = b.c and a.c = b.c and b.b = c.b order by a.b, b.a, c.c");
        }
    }

    protected void afterTestsStopped() throws Exception {
        U.closeQuiet((AutoCloseable)conn);
        this.stopAllGrids();
    }

    public static class C
    extends X {
        public C(int a, int b, int c) {
            super(a, b, c);
        }
    }

    public static class B
    extends X {
        public B(int a, int b, int c) {
            super(a, b, c);
        }
    }

    public static class A
    extends X {
        public A(int a, int b, int c) {
            super(a, b, c);
        }
    }

    public static class X {
        @QuerySqlField(index=true)
        public long a;
        @QuerySqlField(index=true)
        public long b;
        @QuerySqlField(index=true)
        public long c;

        public X(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public long getA() {
            return this.a;
        }

        public long getB() {
            return this.b;
        }

        public long getC() {
            return this.c;
        }
    }
}

