/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheDistributedJoinQueryConditionsTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String PERSON_CACHE = "person";
    private static final String ORG_CACHE = "org";
    private boolean client;
    private int total;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder(IP_FINDER);
        cfg.setClientMode(this.client);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGrid(2);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testJoinQuery1() throws Exception {
        this.joinQuery1(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinQuery1(boolean idx) throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(idx, idx)));
            CacheConfiguration ccfg2 = this.cacheConfiguration(ORG_CACHE).setQueryEntities((Collection)F.asList((Object)this.organizationEntity(idx)));
            IgniteCache pCache = client.createCache(ccfg1);
            client.createCache(ccfg2);
            List<Integer> orgIds = this.putData1();
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select * from (select o._key, o.name, p._key pKey, p.name pName from \"org\".Organization o, Person p where p.orgId = o._key)", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o inner join Person p on p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select * from (select o._key o_key, o.name o_name, p._key p_key, p.name p_name from \"org\".Organization o inner join Person p on p.orgId = o._key)", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and o._key=" + orgIds.get(3), (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and o._key IN (" + orgIds.get(2) + "," + orgIds.get(3) + ")", (IgniteCache<Object, Object>)pCache, 5, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and o._key IN (" + orgIds.get(2) + "," + orgIds.get(3) + ")", (IgniteCache<Object, Object>)pCache, 5, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and o._key > " + orgIds.get(2), (IgniteCache<Object, Object>)pCache, this.total - 3, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and o._key > " + orgIds.get(1) + " and o._key < " + orgIds.get(4), (IgniteCache<Object, Object>)pCache, 5, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.name = o.name", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.name = o.name and o._key=" + orgIds.get(0), (IgniteCache<Object, Object>)pCache, 0, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.name = o.name and o._key=" + orgIds.get(3), (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.name = o.name and o._key IN (" + orgIds.get(2) + "," + orgIds.get(3) + ")", (IgniteCache<Object, Object>)pCache, 5, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.name = o.name and o.name='obj-" + orgIds.get(3) + "'", (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinQuery2() throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(false, true)));
            CacheConfiguration ccfg2 = this.cacheConfiguration(ORG_CACHE).setQueryEntities((Collection)F.asList((Object)this.organizationEntity(false)));
            IgniteCache pCache = client.createCache(ccfg1);
            IgniteCache orgCache = client.createCache(ccfg2);
            ClusterNode node0 = this.ignite(0).cluster().localNode();
            ClusterNode node1 = this.ignite(1).cluster().localNode();
            Affinity aff = client.affinity(PERSON_CACHE);
            AtomicInteger orgKey = new AtomicInteger();
            AtomicInteger pKey = new AtomicInteger();
            ArrayList<Integer> pIds = new ArrayList<Integer>();
            for (int i = 0; i < 3; ++i) {
                Integer orgId = this.keyForNode(aff, orgKey, node0);
                orgCache.put((Object)orgId, (Object)new Organization("org-" + orgId));
                Integer pId = this.keyForNode(aff, pKey, node1);
                pCache.put((Object)pId, (Object)new Person(orgId, "p-" + orgId));
                pIds.add(pId);
            }
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and p._key >= 0", (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and p._key=" + pIds.get(0), (IgniteCache<Object, Object>)pCache, 1, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId = o._key and p._key in (" + pIds.get(0) + ", " + pIds.get(1) + ")", (IgniteCache<Object, Object>)pCache, 2, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testJoinQuery3() throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(false, true)));
            CacheConfiguration ccfg2 = this.cacheConfiguration(ORG_CACHE).setQueryEntities((Collection)F.asList((Object)this.organizationEntity(false)));
            IgniteCache pCache = client.createCache(ccfg1);
            IgniteCache orgCache = client.createCache(ccfg2);
            ClusterNode node0 = this.ignite(0).cluster().localNode();
            ClusterNode node1 = this.ignite(1).cluster().localNode();
            Affinity aff = client.affinity(PERSON_CACHE);
            AtomicInteger orgKey = new AtomicInteger();
            AtomicInteger pKey = new AtomicInteger();
            ArrayList<Integer> pIds = new ArrayList<Integer>();
            for (int i = 0; i < 3; ++i) {
                Integer orgId = this.keyForNode(aff, orgKey, node0);
                orgCache.put((Object)orgId, (Object)new Organization("org-" + orgId));
                Integer pId = this.keyForNode(aff, pKey, node1);
                pCache.put((Object)pId, (Object)new Person(orgId + 100000, "p-" + orgId));
                pIds.add(pId);
            }
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId != o._key", (IgniteCache<Object, Object>)pCache, 9, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId != o._key and p._key=" + pIds.get(0), (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId != o._key and p._key in (" + pIds.get(0) + ", " + pIds.get(1) + ")", (IgniteCache<Object, Object>)pCache, 6, new Object[0]);
            this.checkQuery("select o._key, o.name, p._key, p.name from \"org\".Organization o, Person p where p.orgId != o._key and p._key >=" + pIds.get(0) + "and p._key <= " + pIds.get(2), (IgniteCache<Object, Object>)pCache, 9, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinQuery4() throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(true, false)));
            IgniteCache pCache = client.createCache(ccfg1);
            ClusterNode node0 = this.ignite(0).cluster().localNode();
            ClusterNode node1 = this.ignite(1).cluster().localNode();
            Affinity aff = client.affinity(PERSON_CACHE);
            AtomicInteger pKey = new AtomicInteger();
            Integer pId0 = this.keyForNode(aff, pKey, node0);
            pCache.put((Object)pId0, (Object)new Person(0, "p0"));
            for (int i = 0; i < 3; ++i) {
                Integer pId = this.keyForNode(aff, pKey, node1);
                pCache.put((Object)pId, (Object)new Person(0, "p"));
            }
            this.checkQuery("select p1._key, p1.name, p2._key, p2.name from Person p1, Person p2 where p2._key > p1._key", (IgniteCache<Object, Object>)pCache, 6, new Object[0]);
            this.checkQuery("select p1._key, p1.name, p2._key, p2.name from Person p1, Person p2 where p2._key > p1._key and p1._key=" + pId0, (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select p1._key, p1.name, p2._key, p2.name from Person p1, Person p2 where p2._key > p1._key and p1.name='p0'", (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
            this.checkQuery("select p1._key, p1.name, p2._key, p2.name from Person p1, Person p2 where p1.name > p2.name", (IgniteCache<Object, Object>)pCache, 3, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinQuery5() throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(false, true)));
            CacheConfiguration ccfg2 = this.cacheConfiguration(ORG_CACHE).setQueryEntities((Collection)F.asList((Object)this.organizationEntity(false)));
            IgniteCache pCache = client.createCache(ccfg1);
            IgniteCache orgCache = client.createCache(ccfg2);
            ClusterNode node0 = this.ignite(0).cluster().localNode();
            ClusterNode node1 = this.ignite(1).cluster().localNode();
            Affinity aff = client.affinity(PERSON_CACHE);
            AtomicInteger orgKey = new AtomicInteger();
            AtomicInteger pKey = new AtomicInteger();
            Integer orgId = this.keyForNode(aff, orgKey, node0);
            orgCache.put((Object)orgId, (Object)new Organization("org-" + orgId));
            Integer pId = this.keyForNode(aff, pKey, node1);
            pCache.put((Object)pId, (Object)new Person(orgId, "p-" + orgId));
            this.checkQuery("select o._key from \"org\".Organization o, Person p where p.orgId = o._key", (IgniteCache<Object, Object>)pCache, 1, new Object[0]);
            this.checkQuery("select o.name from \"org\".Organization o where o._key in (select o._key from \"org\".Organization o, Person p where p.orgId = o._key)", (IgniteCache<Object, Object>)pCache, 0, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinQuery6() throws Exception {
        IgniteEx client = this.grid(2);
        try {
            CacheConfiguration ccfg1 = this.cacheConfiguration(PERSON_CACHE).setQueryEntities((Collection)F.asList((Object)this.personEntity(true, true)));
            CacheConfiguration ccfg2 = this.cacheConfiguration(ORG_CACHE).setQueryEntities((Collection)F.asList((Object)this.organizationEntity(true)));
            IgniteCache pCache = client.createCache(ccfg1);
            client.createCache(ccfg2);
            this.putData1();
            this.checkQuery("select _key, name from \"org\".Organization o inner join (select orgId from Person) p on p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select o._key, o.name from (select _key, name from \"org\".Organization) o inner join Person p on p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select o._key, o.name from (select _key, name from \"org\".Organization) o inner join (select orgId from Person) p on p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
            this.checkQuery("select * from (select _key, name from \"org\".Organization) o inner join (select orgId from Person) p on p.orgId = o._key", (IgniteCache<Object, Object>)pCache, this.total, new Object[0]);
        }
        finally {
            client.destroyCache(PERSON_CACHE);
            client.destroyCache(ORG_CACHE);
        }
    }

    private void checkQuery(String sql, IgniteCache<Object, Object> cache, int expSize, Object ... args) {
        this.log.info("Execute query: " + sql);
        this.checkQuery(sql, cache, false, expSize, args);
        this.checkQuery(sql, cache, true, expSize, args);
    }

    private void checkQuery(String sql, IgniteCache<Object, Object> cache, boolean enforceJoinOrder, int expSize, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setEnforceJoinOrder(enforceJoinOrder);
        qry.setArgs(args);
        this.log.info("Plan: " + this.queryPlan(cache, qry));
        QueryCursor cur = cache.query((Query)qry);
        List res = cur.getAll();
        if (expSize != res.size()) {
            this.log.info("Results: " + res);
        }
        IgniteCacheDistributedJoinQueryConditionsTest.assertEquals((int)expSize, (int)res.size());
    }

    private QueryEntity personEntity(boolean idxName, boolean idxOrgId) {
        QueryIndex idx;
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        if (idxName) {
            idx = new QueryIndex("name");
            idxs.add(idx);
        }
        if (idxOrgId) {
            idx = new QueryIndex("orgId");
            idxs.add(idx);
        }
        entity.setIndexes(idxs);
        return entity;
    }

    private QueryEntity organizationEntity(boolean idxName) {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        if (idxName) {
            QueryIndex idx = new QueryIndex("name");
            entity.setIndexes((Collection)F.asList((Object)idx));
        }
        return entity;
    }

    private List<Integer> putData1() {
        this.total = 0;
        IgniteEx client = this.grid(2);
        Affinity aff = client.affinity(PERSON_CACHE);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        AtomicInteger pKey = new AtomicInteger();
        AtomicInteger orgKey = new AtomicInteger();
        ClusterNode node0 = this.ignite(0).cluster().localNode();
        ClusterNode node1 = this.ignite(1).cluster().localNode();
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = 0; i < 5; ++i) {
            int orgId = this.keyForNode(aff, orgKey, node0);
            orgCache.put((Object)orgId, (Object)new Organization("obj-" + orgId));
            for (int j = 0; j < i; ++j) {
                personCache.put((Object)this.keyForNode(aff, pKey, node1), (Object)new Person(orgId, "obj-" + orgId));
                ++this.total;
            }
            data.add(orgId);
        }
        return data;
    }

    private CacheConfiguration cacheConfiguration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(0);
        return ccfg;
    }

    private static class Organization
    implements Serializable {
        String name;

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        int orgId;
        String name;

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

