/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheDistributedJoinNoIndexTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String PERSON_CACHE = "person";
    private static final String ORG_CACHE = "org";
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder(IP_FINDER);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("orgId", Integer.class.getName(), null);
        entity.addQueryField("orgName", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        ccfg = this.configuration(ORG_CACHE);
        entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Organization.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        ccfgs.add(ccfg);
        cfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration configuration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(0);
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGrid(2);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testJoin() throws Exception {
        IgniteEx client = this.grid(2);
        Affinity aff = client.affinity(PERSON_CACHE);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        IgniteCache orgCache = client.cache(ORG_CACHE);
        AtomicInteger pKey = new AtomicInteger(100000);
        AtomicInteger orgKey = new AtomicInteger();
        ClusterNode node0 = this.ignite(0).cluster().localNode();
        ClusterNode node1 = this.ignite(1).cluster().localNode();
        for (int i = 0; i < 3; ++i) {
            int orgId = this.keyForNode(aff, orgKey, node0);
            orgCache.put((Object)orgId, (Object)new Organization("org-" + i));
            for (int j = 0; j < i; ++j) {
                personCache.put((Object)this.keyForNode(aff, pKey, node1), (Object)new Person(orgId, "org-" + i));
            }
        }
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o, \"person\".Person p where p.orgName = o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o inner join \"person\".Person p on p.orgName = o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o, \"person\".Person p where p.orgName > o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from (select * from \"org\".Organization) o, \"person\".Person p where p.orgName = o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o, (select * from \"person\".Person) p where p.orgName = o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from (select * from \"org\".Organization) o, (select * from \"person\".Person) p where p.orgName = o.name");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o, \"person\".Person p");
        this.checkNoIndexError((IgniteCache<Object, Object>)personCache, "select o.name, p._key, p.orgName from \"org\".Organization o, \"person\".Person p where o._key != p._key");
        this.checkQuery("select o.name, p._key, p.orgName from \"org\".Organization o, \"person\".Person p where p._key = o._key and o.name=?", (IgniteCache<Object, Object>)personCache, 0, "aaa");
    }

    private void checkNoIndexError(final IgniteCache<Object, Object> cache, final String sql) {
        Throwable err = GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SqlFieldsQuery qry = new SqlFieldsQuery(sql);
                qry.setDistributedJoins(true);
                cache.query((Query)qry).getAll();
                return null;
            }
        }, CacheException.class, null);
        this.log.info("Error: " + err.getMessage());
        IgniteCacheDistributedJoinNoIndexTest.assertTrue((String)("Unexpected error message: " + err.getMessage()), (boolean)err.getMessage().contains("join condition does not use index"));
    }

    private List<List<?>> checkQuery(String sql, IgniteCache<Object, Object> cache, int expSize, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setArgs(args);
        this.log.info("Plan: " + this.queryPlan(cache, qry));
        QueryCursor cur = cache.query((Query)qry);
        List res = cur.getAll();
        if (expSize != res.size()) {
            this.log.info("Results: " + res);
        }
        IgniteCacheDistributedJoinNoIndexTest.assertEquals((int)expSize, (int)res.size());
        return res;
    }

    private static class Organization
    implements Serializable {
        String name;

        public Organization(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Organization.class, (Object)this);
        }
    }

    private static class Person
    implements Serializable {
        int orgId;
        String orgName;

        public Person(int orgId, String orgName) {
            this.orgId = orgId;
            this.orgName = orgName;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

