/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheConfigurationPrimitiveTypesSelfTest
extends GridCommonAbstractTest {
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    public void testPrimitiveTypes() throws Exception {
        IgniteEx ignite = this.startGrid(1);
        IgniteCache cacheByte = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Byte.TYPE, Byte.TYPE);
        byte b = 1;
        cacheByte.put((Object)b, (Object)b);
        IgniteCache cacheShort = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Short.TYPE, Short.TYPE);
        short s = 2;
        cacheShort.put((Object)s, (Object)s);
        IgniteCache cacheInt = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Integer.TYPE, Integer.TYPE);
        int i = 3;
        cacheInt.put((Object)i, (Object)i);
        IgniteCache cacheLong = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Long.TYPE, Long.TYPE);
        long l = 4L;
        cacheLong.put((Object)l, (Object)l);
        IgniteCache cacheFloat = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Float.TYPE, Float.TYPE);
        float f = 5.0f;
        cacheFloat.put((Object)Float.valueOf(f), (Object)Float.valueOf(f));
        IgniteCache cacheDouble = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Double.TYPE, Double.TYPE);
        double d = 6.0;
        cacheDouble.put((Object)d, (Object)d);
        IgniteCache cacheBoolean = this.jcache((Ignite)ignite, new CacheConfiguration("default"), Boolean.TYPE, Boolean.TYPE);
        boolean bool = true;
        cacheBoolean.put((Object)bool, (Object)bool);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheByte.query((Query)new SqlQuery(Byte.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheShort.query((Query)new SqlQuery(Short.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheInt.query((Query)new SqlQuery(Integer.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheLong.query((Query)new SqlQuery(Long.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheFloat.query((Query)new SqlQuery(Float.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheDouble.query((Query)new SqlQuery(Double.class, "1 = 1")).getAll().size(), (int)1);
        IgniteCacheConfigurationPrimitiveTypesSelfTest.assertEquals((int)cacheBoolean.query((Query)new SqlQuery(Boolean.class, "1 = 1")).getAll().size(), (int)1);
    }
}

