/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityUuid;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheCollocatedQuerySelfTest
extends GridCommonAbstractTest {
    private static final String QRY = "select productId, sum(price) s, count(1) c from Purchase group by productId having c > ? order by s desc, productId limit ? ";
    private static final int PURCHASES = 1000;
    private static final int PRODUCTS = 10;
    private static final int MAX_PRICE = 5;
    private static final long SEED = ThreadLocalRandom.current().nextLong();
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        CacheConfiguration cacheCfg = IgniteCacheCollocatedQuerySelfTest.defaultCacheConfiguration();
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setBackups(1);
        cacheCfg.setIndexedTypes(new Class[]{AffinityUuid.class, Purchase.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        X.println((String)("--> seed: " + SEED), (Object[])new Object[0]);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.ignite(0).cache("default").removeAll();
    }

    private static List<List<?>> query(IgniteCache<AffinityUuid, Purchase> c, boolean collocated) {
        return c.query((Query)new SqlFieldsQuery(QRY).setArgs(new Object[]{30, 5}).setCollocated(collocated)).getAll();
    }

    public void testColocatedQueryRight() {
        IgniteCache c = this.ignite(0).cache("default");
        GridRandom rnd = new GridRandom(SEED);
        for (int i = 0; i < 1000; ++i) {
            Purchase p = new Purchase();
            p.productId = rnd.nextInt(10);
            p.price = rnd.nextInt(5);
            c.put((Object)new AffinityUuid((Object)p.productId), (Object)p);
        }
        List<List<?>> res1 = IgniteCacheCollocatedQuerySelfTest.query((IgniteCache<AffinityUuid, Purchase>)c, false);
        List<List<?>> res2 = IgniteCacheCollocatedQuerySelfTest.query((IgniteCache<AffinityUuid, Purchase>)c, true);
        X.println((String)("res1: " + res1), (Object[])new Object[0]);
        X.println((String)("res2: " + res2), (Object[])new Object[0]);
        IgniteCacheCollocatedQuerySelfTest.assertFalse((boolean)res1.isEmpty());
        IgniteCacheCollocatedQuerySelfTest.assertEquals((String)res1.toString(), (String)res2.toString());
    }

    public void testColocatedQueryWrong() {
        IgniteCache c = this.ignite(0).cache("default");
        GridRandom rnd = new GridRandom(SEED);
        for (int i = 0; i < 1000; ++i) {
            Purchase p = new Purchase();
            p.productId = rnd.nextInt(10);
            p.price = rnd.nextInt(5);
            c.put((Object)new AffinityUuid((Object)rnd.nextInt(10)), (Object)p);
        }
        List<List<?>> res1 = IgniteCacheCollocatedQuerySelfTest.query((IgniteCache<AffinityUuid, Purchase>)c, false);
        List<List<?>> res2 = IgniteCacheCollocatedQuerySelfTest.query((IgniteCache<AffinityUuid, Purchase>)c, true);
        X.println((String)("res1: " + res1), (Object[])new Object[0]);
        X.println((String)("res2: " + res2), (Object[])new Object[0]);
        IgniteCacheCollocatedQuerySelfTest.assertFalse((boolean)res1.isEmpty());
        IgniteCacheCollocatedQuerySelfTest.assertFalse((boolean)res1.equals(res2));
    }

    private static class Purchase
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        int productId;
        @QuerySqlField
        int price;

        private Purchase() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Purchase purchase = (Purchase)o;
            return this.productId == purchase.productId && this.price == purchase.price;
        }

        public int hashCode() {
            int result = this.productId;
            result = 31 * result + this.price;
            return result;
        }
    }
}

