/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.IgniteTestResources;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class IgniteCacheAbstractSqlDmlQuerySelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    protected final Marshaller marsh;

    IgniteCacheAbstractSqlDmlQuerySelfTest() {
        try {
            this.marsh = IgniteTestResources.getMarshaller();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    protected boolean isBinaryMarshaller() {
        return this.marsh instanceof BinaryMarshaller;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3, true);
        this.ignite(0).createCache(IgniteCacheAbstractSqlDmlQuerySelfTest.cacheConfig("S2P", true, false).setIndexedTypes(new Class[]{String.class, Person.class}));
        if (this.isBinaryMarshaller()) {
            this.ignite(0).createCache(IgniteCacheAbstractSqlDmlQuerySelfTest.createBinCacheConfig());
        }
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.ignite(0).cache("S2P").put((Object)"FirstKey", (Object)new Person(1, "John", "White"));
        this.ignite(0).cache("S2P").put((Object)"SecondKey", (Object)new Person(2, "Joe", "Black"));
        this.ignite(0).cache("S2P").put((Object)"k3", (Object)new Person(3, "Sylvia", "Green"));
        this.ignite(0).cache("S2P").put((Object)"f0u4thk3y", (Object)new Person(4, "Jane", "Silver"));
        if (this.isBinaryMarshaller()) {
            this.ignite(0).cache("S2P-bin").put((Object)"FirstKey", this.createBinPerson(1, "John", "White"));
            this.ignite(0).cache("S2P-bin").put((Object)"SecondKey", this.createBinPerson(2, "Joe", "Black"));
            this.ignite(0).cache("S2P-bin").put((Object)"k3", this.createBinPerson(3, "Sylvia", "Green"));
            this.ignite(0).cache("S2P-bin").put((Object)"f0u4thk3y", this.createBinPerson(4, "Jane", "Silver"));
        }
    }

    Object createPerson(int id, String name, String secondName) {
        if (!this.isBinaryMarshaller()) {
            return new Person(id, name, secondName);
        }
        return this.createBinPerson(id, name, secondName);
    }

    private Object createBinPerson(int id, String name, String secondName) {
        BinaryObjectBuilder bldr = this.ignite(0).binary().builder("Person");
        bldr.setField("id", (Object)id);
        bldr.setField("firstName", (Object)name);
        bldr.setField("secondName", (Object)secondName);
        return bldr.build();
    }

    protected IgniteCache cache() {
        if (!this.isBinaryMarshaller()) {
            return this.ignite(0).cache("S2P");
        }
        return this.ignite(0).cache("S2P-bin").withKeepBinary();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    protected static CacheConfiguration cacheConfig(String name, boolean partitioned, boolean escapeSql) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setSqlEscapeAll(escapeSql);
    }

    private static CacheConfiguration createBinCacheConfig() {
        CacheConfiguration ccfg = IgniteCacheAbstractSqlDmlQuerySelfTest.cacheConfig("S2P-bin", true, false);
        QueryEntity e = new QueryEntity(String.class.getName(), "Person");
        LinkedHashMap<String, String> flds = new LinkedHashMap<String, String>();
        flds.put("id", Integer.class.getName());
        flds.put("firstName", String.class.getName());
        flds.put("secondName", String.class.getName());
        e.setFields(flds);
        e.setIndexes(Collections.emptyList());
        ccfg.setQueryEntities(Collections.singletonList(e));
        return ccfg;
    }

    static class Person
    implements Serializable {
        @QuerySqlField
        protected int id;
        @QuerySqlField(name="firstName")
        protected final String name;
        @QuerySqlField
        final String secondName;

        public Person(int id, String name, String secondName) {
            this.id = id;
            this.name = name;
            this.secondName = secondName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.id == person.id && this.name.equals(person.name) && this.secondName.equals(person.secondName);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + this.name.hashCode();
            res = 31 * res + this.secondName.hashCode();
            return res;
        }
    }
}

