/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.IgniteCacheUpdateSqlQuerySelfTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.IgniteTestResources;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class IgniteCacheAbstractInsertSqlQuerySelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    protected final Marshaller marsh;

    IgniteCacheAbstractInsertSqlQuerySelfTest() {
        try {
            this.marsh = IgniteTestResources.getMarshaller();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    boolean isBinaryMarshaller() {
        return this.marsh instanceof BinaryMarshaller;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        BinaryConfiguration binCfg = new BinaryConfiguration();
        binCfg.setTypeConfigurations(Arrays.asList(new BinaryTypeConfiguration(){
            {
                this.setTypeName(Key.class.getName());
            }
        }, new BinaryTypeConfiguration(){
            {
                this.setTypeName(Key2.class.getName());
            }
        }));
        cfg.setBinaryConfiguration(binCfg);
        cfg.setPeerClassLoadingEnabled(false);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3, false);
        if (!this.isBinaryMarshaller()) {
            this.createCaches();
        } else {
            this.createBinaryCaches();
        }
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("I2AT", true, false, Integer.class, IgniteCacheUpdateSqlQuerySelfTest.AllTypes.class));
    }

    void createCaches() {
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("S2P", true, false, String.class, Person.class, String.class, String.class));
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("I2P", true, false, Integer.class, Person.class));
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("K2P", true, false, Key.class, Person.class));
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("K22P", true, true, Key2.class, Person2.class));
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("I2I", true, false, Integer.class, Integer.class));
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("U2I", true, false, UUID.class, Integer.class));
    }

    final void createBinaryCaches() {
        this.ignite(0).createCache(IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("U2I", true, false, UUID.class, Integer.class));
        CacheConfiguration s2pCcfg = IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("S2P", true, false, new Class[0]);
        QueryEntity s2p = new QueryEntity(String.class.getName(), "Person");
        LinkedHashMap<String, String> flds = new LinkedHashMap<String, String>();
        flds.put("id", Integer.class.getName());
        flds.put("firstName", String.class.getName());
        s2p.setFields(flds);
        s2p.setIndexes(Collections.emptyList());
        QueryEntity s2s = new QueryEntity(String.class.getName(), String.class.getName());
        s2pCcfg.setQueryEntities(Arrays.asList(s2p, s2s));
        this.ignite(0).createCache(s2pCcfg);
        CacheConfiguration i2pCcfg = IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("I2P", true, false, new Class[0]);
        QueryEntity i2p = new QueryEntity(Integer.class.getName(), "Person");
        flds = new LinkedHashMap();
        flds.put("id", Integer.class.getName());
        flds.put("firstName", String.class.getName());
        i2p.setFields(flds);
        i2p.setIndexes(Collections.emptyList());
        i2pCcfg.setQueryEntities(Collections.singletonList(i2p));
        this.ignite(0).createCache(i2pCcfg);
        CacheConfiguration k2pCcfg = IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("K2P", true, false, new Class[0]);
        QueryEntity k2p = new QueryEntity(Key.class.getName(), "Person");
        k2p.setKeyFields(Collections.singleton("key"));
        flds = new LinkedHashMap();
        flds.put("key", Integer.class.getName());
        flds.put("id", Integer.class.getName());
        flds.put("firstName", String.class.getName());
        k2p.setFields(flds);
        k2p.setIndexes(Collections.emptyList());
        k2pCcfg.setQueryEntities(Collections.singletonList(k2p));
        this.ignite(0).createCache(k2pCcfg);
        CacheConfiguration k22pCcfg = IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("K22P", true, true, new Class[0]);
        QueryEntity k22p = new QueryEntity(Key2.class.getName(), "Person2");
        k22p.setKeyFields(Collections.singleton("Id"));
        flds = new LinkedHashMap();
        flds.put("Id", Integer.class.getName());
        flds.put("id", Integer.class.getName());
        flds.put("firstName", String.class.getName());
        flds.put("IntVal", Integer.class.getName());
        k22p.setFields(flds);
        k22p.setIndexes(Collections.emptyList());
        k22pCcfg.setQueryEntities(Collections.singletonList(k22p));
        this.ignite(0).createCache(k22pCcfg);
        CacheConfiguration i2iCcfg = IgniteCacheAbstractInsertSqlQuerySelfTest.cacheConfig("I2I", true, false, new Class[0]);
        QueryEntity i2i = new QueryEntity(Integer.class.getName(), Integer.class.getName());
        i2i.setFields(new LinkedHashMap());
        i2i.setIndexes(Collections.emptyList());
        i2iCcfg.setQueryEntities(Collections.singletonList(i2i));
        this.ignite(0).createCache(i2iCcfg);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.ignite(0).cache("S2P").clear();
        this.ignite(0).cache("I2P").clear();
        this.ignite(0).cache("K2P").clear();
        this.ignite(0).cache("K22P").clear();
        this.ignite(0).cache("I2I").clear();
        super.afterTest();
    }

    Object createPerson(int id, String name) {
        if (!this.isBinaryMarshaller()) {
            Person p = new Person(id);
            p.name = name;
            return p;
        }
        BinaryObjectBuilder o = this.grid(0).binary().builder("Person");
        o.setField("id", (Object)id);
        o.setField("name", (Object)name);
        return o.build();
    }

    Object createPerson2(int id, String name, int valFld) {
        if (!this.isBinaryMarshaller()) {
            Person2 p = new Person2(id);
            p.name = name;
            p.IntVal = valFld;
            return p;
        }
        BinaryObjectBuilder o = this.grid(0).binary().builder("Person2");
        o.setField("id", (Object)id);
        o.setField("name", (Object)name);
        o.setField("IntVal", (Object)valFld);
        return o.build();
    }

    private static CacheConfiguration cacheConfig(String name, boolean partitioned, boolean escapeSql, Class<?> ... idxTypes) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setSqlEscapeAll(escapeSql).setIndexedTypes((Class[])idxTypes);
    }

    protected static class Person2
    extends Person {
        @QuerySqlField
        public int IntVal;

        private Person2() {
        }

        public Person2(int id) {
            super(id);
        }
    }

    protected static class Person
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        protected int id;
        @QuerySqlField(name="firstName")
        protected String name;

        private Person() {
        }

        public Person(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            return this.name != null ? this.name.equals(person.name) : person.name == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    protected static final class Key2
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        public final int Id;

        public Key2(int Id2) {
            this.Id = Id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key2 key1 = (Key2)o;
            return this.Id == key1.Id;
        }

        public int hashCode() {
            return this.Id;
        }
    }

    protected static final class Key
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        public final int key;

        public Key(int key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return this.key == key1.key;
        }

        public int hashCode() {
            return this.key;
        }
    }
}

