/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteBinaryObjectQueryArgumentsTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int NODES = 3;
    private static final String PRIM_CACHE = "prim-cache";
    private static final String STR_CACHE = "str-cache";
    private static final String ENUM_CACHE = "enum-cache";
    private static final String UUID_CACHE = "uuid-cache";
    private static final String DATE_CACHE = "date-cache";
    private static final String TIMESTAMP_CACHE = "timestamp-cache";
    private static final String BIG_DECIMAL_CACHE = "decimal-cache";
    private static final String OBJECT_CACHE = "obj-cache";
    private static final String FIELD_CACHE = "field-cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(IP_FINDER);
        cfg.setCacheConfiguration(this.getCacheConfigurations());
        cfg.setMarshaller(null);
        return cfg;
    }

    protected boolean isLocal() {
        return false;
    }

    protected CacheConfiguration getCacheConfiguration(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity person = new QueryEntity();
        person.setKeyType(TestKey.class.getName());
        person.setValueType(Person.class.getName());
        person.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities(Collections.singletonList(person));
        ccfg.setName(cacheName);
        return ccfg;
    }

    private CacheConfiguration[] getCacheConfigurations() {
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        ccfgs.add(this.getCacheConfiguration(OBJECT_CACHE));
        ccfgs.addAll(this.getCacheConfigurations(STR_CACHE, String.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(PRIM_CACHE, Integer.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(ENUM_CACHE, EnumKey.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(UUID_CACHE, UUID.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(DATE_CACHE, Date.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(TIMESTAMP_CACHE, Timestamp.class, Person.class));
        ccfgs.addAll(this.getCacheConfigurations(BIG_DECIMAL_CACHE, BigDecimal.class, Person.class));
        ccfgs.add(this.getCacheConfiguration(FIELD_CACHE, Integer.class, SearchValue.class));
        return ccfgs.toArray(new CacheConfiguration[ccfgs.size()]);
    }

    private List<CacheConfiguration> getCacheConfigurations(String cacheName, Class<?> key, Class<?> val) {
        ArrayList<CacheConfiguration> res = new ArrayList<CacheConfiguration>();
        res.add(this.getCacheConfiguration(cacheName, key, val));
        res.add(this.getCacheConfiguration(cacheName + "-val", val, key));
        return res;
    }

    private CacheConfiguration getCacheConfiguration(String cacheName, Class<?> key, Class<?> val) {
        CacheConfiguration cfg = new CacheConfiguration("default");
        cfg.setName(cacheName);
        cfg.setIndexedTypes(new Class[]{key, val});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        int nodes = this.isLocal() ? 1 : 3;
        this.startGridsMultiThreaded(nodes);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testObjectArgument() throws Exception {
        this.testKeyQuery(OBJECT_CACHE, new TestKey(1), new TestKey(2));
    }

    public void testPrimitiveObjectArgument() throws Exception {
        this.testKeyValQuery(PRIM_CACHE, 1, 2);
    }

    public void testStringObjectArgument() throws Exception {
        this.testKeyValQuery(STR_CACHE, "str1", "str2");
    }

    public void testEnumObjectArgument() throws Exception {
        this.testKeyValQuery(ENUM_CACHE, EnumKey.KEY1, EnumKey.KEY2);
    }

    public void testUuidObjectArgument() throws Exception {
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        while (uuid1.equals(uuid2)) {
            uuid2 = UUID.randomUUID();
        }
        this.testKeyValQuery(UUID_CACHE, uuid1, uuid2);
    }

    public void testDateObjectArgument() throws Exception {
        this.testKeyValQuery(DATE_CACHE, new Date(0L), new Date(1L));
    }

    public void testTimestampArgument() throws Exception {
        this.testKeyValQuery(TIMESTAMP_CACHE, new Timestamp(0L), new Timestamp(1L));
    }

    public void testBigDecimalArgument() throws Exception {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        BigDecimal bd1 = new BigDecimal(rnd.nextDouble());
        BigDecimal bd2 = new BigDecimal(rnd.nextDouble());
        while (bd1.equals(bd2)) {
            bd2 = new BigDecimal(rnd.nextDouble());
        }
        this.testKeyValQuery(BIG_DECIMAL_CACHE, bd1, bd2);
    }

    private <T> void testKeyValQuery(String cacheName, T key1, T key2) {
        this.testKeyQuery(cacheName, key1, key2);
        this.testValQuery(cacheName + "-val", key1, key2);
    }

    private <T> void testKeyQuery(String cacheName, T key1, T key2) {
        IgniteCache cache = this.ignite(0).cache(cacheName);
        Person p1 = new Person("p1");
        Person p2 = new Person("p2");
        cache.put(key1, (Object)p1);
        cache.put(key2, (Object)p2);
        SqlQuery qry = new SqlQuery(Person.class, "where _key=?");
        SqlFieldsQuery fieldsQry = new SqlFieldsQuery("select _key, _val, * from Person where _key=?");
        qry.setLocal(this.isLocal());
        fieldsQry.setLocal(this.isLocal());
        qry.setArgs(new Object[]{key1});
        fieldsQry.setArgs(new Object[]{key1});
        List res = cache.query((Query)qry).getAll();
        List fieldsRes = cache.query((Query)fieldsQry).getAll();
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((int)1, (int)res.size());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((int)1, (int)fieldsRes.size());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)p1, (Object)((Cache.Entry)res.get(0)).getValue());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals(key1, (Object)((Cache.Entry)res.get(0)).getKey());
        IgniteBinaryObjectQueryArgumentsTest.assertTrue((((List)fieldsRes.get(0)).size() >= 2 ? 1 : 0) != 0);
        IgniteBinaryObjectQueryArgumentsTest.assertEquals(key1, ((List)fieldsRes.get(0)).get(0));
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)p1, ((List)fieldsRes.get(0)).get(1));
    }

    private <T> void testValQuery(String cacheName, T val1, T val2) {
        IgniteCache cache = this.ignite(0).cache(cacheName);
        Class<?> valType = val1.getClass();
        Person p1 = new Person("p1");
        Person p2 = new Person("p2");
        cache.put((Object)p1, val1);
        cache.put((Object)p2, val2);
        SqlQuery qry = new SqlQuery(valType, "where _val=?");
        SqlFieldsQuery fieldsQry = new SqlFieldsQuery("select _key, _val, * from " + valType.getSimpleName() + " where _val=?");
        qry.setLocal(this.isLocal());
        fieldsQry.setLocal(this.isLocal());
        qry.setArgs(new Object[]{val1});
        fieldsQry.setArgs(new Object[]{val1});
        List res = cache.query((Query)qry).getAll();
        List fieldsRes = cache.query((Query)fieldsQry).getAll();
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((int)1, (int)res.size());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((int)1, (int)fieldsRes.size());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)p1, (Object)((Cache.Entry)res.get(0)).getKey());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals(val1, (Object)((Cache.Entry)res.get(0)).getValue());
        IgniteBinaryObjectQueryArgumentsTest.assertTrue((((List)fieldsRes.get(0)).size() >= 2 ? 1 : 0) != 0);
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)p1, ((List)fieldsRes.get(0)).get(0));
        IgniteBinaryObjectQueryArgumentsTest.assertEquals(val1, ((List)fieldsRes.get(0)).get(1));
    }

    public void testFieldSearch() throws Exception {
        IgniteCache cache = this.ignite(0).cache(FIELD_CACHE);
        HashMap<Integer, SearchValue> map = new HashMap<Integer, SearchValue>();
        for (int i = 0; i < 10; ++i) {
            map.put(i, new SearchValue(UUID.randomUUID(), String.valueOf(i), new BigDecimal((double)i * 0.1), i, new Date(i), new Timestamp(i), new Person(String.valueOf("name-" + i)), i % 2 == 0 ? EnumKey.KEY1 : EnumKey.KEY2));
        }
        cache.putAll(map);
        SqlQuery qry = new SqlQuery(SearchValue.class, "where uuid=? and str=? and decimal=? and integer=? and date=? and ts=? and person=? and enumKey=?");
        int k = ThreadLocalRandom.current().nextInt(10);
        SearchValue val = (SearchValue)map.get(k);
        qry.setLocal(this.isLocal());
        qry.setArgs(new Object[]{val.uuid, val.str, val.decimal, val.integer, val.date, val.ts, val.person, val.enumKey});
        List res = cache.query((Query)qry).getAll();
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((int)1, (int)res.size());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)val.integer, (Object)((Cache.Entry)res.get(0)).getKey());
        IgniteBinaryObjectQueryArgumentsTest.assertEquals((Object)val, (Object)((Cache.Entry)res.get(0)).getValue());
    }

    private static class SearchValue {
        @QuerySqlField
        private UUID uuid;
        @QuerySqlField
        private String str;
        @QuerySqlField
        private BigDecimal decimal;
        @QuerySqlField
        private Integer integer;
        @QuerySqlField
        private Date date;
        @QuerySqlField
        private Timestamp ts;
        @QuerySqlField
        private Person person;
        @QuerySqlField
        private EnumKey enumKey;

        SearchValue(UUID uuid, String str, BigDecimal decimal, Integer integer, Date date, Timestamp ts, Person person, EnumKey enumKey) {
            this.uuid = uuid;
            this.str = str;
            this.decimal = decimal;
            this.integer = integer;
            this.date = date;
            this.ts = ts;
            this.person = person;
            this.enumKey = enumKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchValue that = (SearchValue)o;
            if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
                return false;
            }
            if (this.str != null ? !this.str.equals(that.str) : that.str != null) {
                return false;
            }
            if (this.decimal != null ? !this.decimal.equals(that.decimal) : that.decimal != null) {
                return false;
            }
            if (this.integer != null ? !this.integer.equals(that.integer) : that.integer != null) {
                return false;
            }
            if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
                return false;
            }
            if (this.ts != null ? !this.ts.equals(that.ts) : that.ts != null) {
                return false;
            }
            if (this.person != null ? !this.person.equals(that.person) : that.person != null) {
                return false;
            }
            return this.enumKey == that.enumKey;
        }

        public int hashCode() {
            int res = this.uuid != null ? this.uuid.hashCode() : 0;
            res = 31 * res + (this.str != null ? this.str.hashCode() : 0);
            res = 31 * res + (this.decimal != null ? this.decimal.hashCode() : 0);
            res = 31 * res + (this.integer != null ? this.integer.hashCode() : 0);
            res = 31 * res + (this.date != null ? this.date.hashCode() : 0);
            res = 31 * res + (this.ts != null ? this.ts.hashCode() : 0);
            res = 31 * res + (this.person != null ? this.person.hashCode() : 0);
            res = 31 * res + (this.enumKey != null ? this.enumKey.hashCode() : 0);
            return res;
        }
    }

    private static enum EnumKey {
        KEY1,
        KEY2;

    }

    public static class TestKey {
        private int id;

        TestKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey other = (TestKey)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class Person {
        String name;

        public Person(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name != null ? this.name.equals(person.name) : person.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

