/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class CacheSqlQueryValueCopySelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final int KEYS = 100;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if ("client".equals(cfg.getIgniteInstanceName())) {
            cfg.setClientMode(true);
        }
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(ipFinder);
        CacheConfiguration cc = new CacheConfiguration("default");
        cc.setCopyOnRead(true);
        cc.setIndexedTypes(new Class[]{Integer.class, Value.class});
        cc.setSqlFunctionClasses(new Class[]{TestSQLFunctions.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cc});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected void beforeTest() throws Exception {
        IgniteCache cache = this.grid(0).cache("default");
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)new Value(i, "before-" + i));
        }
    }

    protected void afterTest() throws Exception {
        IgniteCache cache = this.grid(0).cache("default");
        cache.removeAll();
        super.afterTest();
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    public void testTwoStepSqlClientQuery() throws Exception {
        try (Ignite client = this.startGrid("client");){
            IgniteCache cache = client.cache("default");
            List all = cache.query((Query)new SqlQuery(Value.class, "select * from Value")).getAll();
            CacheSqlQueryValueCopySelfTest.assertEquals((int)100, (int)all.size());
            for (Cache.Entry entry : all) {
                ((Value)entry.getValue()).str = "after";
            }
            this.check((IgniteCache<Integer, Value>)cache);
            QueryCursor qry = cache.query((Query)new SqlFieldsQuery("select _val from Value"));
            List all0 = qry.getAll();
            CacheSqlQueryValueCopySelfTest.assertEquals((int)100, (int)all0.size());
            for (List entry : all0) {
                ((Value)entry.get(0)).str = "after";
            }
            this.check((IgniteCache<Integer, Value>)cache);
        }
    }

    public void testTwoStepSkipReduceSqlQuery() {
        IgniteCache cache = this.grid(0).cache("default");
        List all = cache.query((Query)new SqlQuery(Value.class, "select * from Value").setPageSize(3)).getAll();
        CacheSqlQueryValueCopySelfTest.assertEquals((int)100, (int)all.size());
        for (Cache.Entry entry : all) {
            ((Value)entry.getValue()).str = "after";
        }
        this.check((IgniteCache<Integer, Value>)cache);
    }

    public void testTwoStepReduceSqlQuery() {
        IgniteCache cache = this.grid(0).cache("default");
        QueryCursor qry = cache.query((Query)new SqlFieldsQuery("select _val from Value order by _key"));
        List all = qry.getAll();
        CacheSqlQueryValueCopySelfTest.assertEquals((int)100, (int)all.size());
        for (List entry : all) {
            ((Value)entry.get(0)).str = "after";
        }
        this.check((IgniteCache<Integer, Value>)cache);
    }

    public void testLocalSqlQuery() {
        IgniteCache cache = this.grid(0).cache("default");
        SqlQuery qry = new SqlQuery(Value.class.getSimpleName(), "select * from Value");
        qry.setLocal(true);
        List all = cache.query((Query)qry).getAll();
        CacheSqlQueryValueCopySelfTest.assertFalse((boolean)all.isEmpty());
        for (Cache.Entry entry : all) {
            ((Value)entry.getValue()).str = "after";
        }
        this.check((IgniteCache<Integer, Value>)cache);
    }

    public void testLocalSqlFieldsQuery() {
        IgniteCache cache = this.grid(0).cache("default");
        QueryCursor cur = cache.query((Query)new SqlFieldsQuery("select _val from Value").setLocal(true));
        List all = cur.getAll();
        CacheSqlQueryValueCopySelfTest.assertFalse((boolean)all.isEmpty());
        for (List entry : all) {
            ((Value)entry.get(0)).str = "after";
        }
        this.check((IgniteCache<Integer, Value>)cache);
    }

    private IgniteInternalFuture<?> runQueryAsync(final Query<?> qry) throws Exception {
        return this.multithreadedAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    CacheSqlQueryValueCopySelfTest.this.log.info(">>> Query started");
                    CacheSqlQueryValueCopySelfTest.this.grid(0).cache("default").query(qry).getAll();
                    CacheSqlQueryValueCopySelfTest.this.log.info(">>> Query finished");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 1, "run-query");
    }

    public void testRunningSqlFieldsQuery() throws Exception {
        IgniteInternalFuture<?> fut = this.runQueryAsync((Query<?>)new SqlFieldsQuery("select _val, sleep(1000) from Value limit 3"));
        Thread.sleep(500L);
        GridQueryProcessor qryProc = this.grid(0).context().query();
        Collection queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)1, (int)queries.size());
        fut.get();
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)0, (int)queries.size());
        SqlFieldsQuery qry = new SqlFieldsQuery("select _val, sleep(1000) from Value limit 3");
        qry.setLocal(true);
        fut = this.runQueryAsync((Query<?>)qry);
        Thread.sleep(500L);
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)1, (int)queries.size());
        fut.get();
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)0, (int)queries.size());
    }

    public void testRunningSqlQuery() throws Exception {
        IgniteInternalFuture<?> fut = this.runQueryAsync((Query<?>)new SqlQuery(Value.class, "id > sleep(100)"));
        Thread.sleep(500L);
        GridQueryProcessor qryProc = this.grid(0).context().query();
        Collection queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)1, (int)queries.size());
        fut.get();
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)0, (int)queries.size());
        SqlQuery qry = new SqlQuery(Value.class, "id > sleep(100)");
        qry.setLocal(true);
        fut = this.runQueryAsync((Query<?>)qry);
        Thread.sleep(500L);
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)1, (int)queries.size());
        fut.get();
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)0, (int)queries.size());
    }

    public void testCancelingSqlFieldsQuery() throws Exception {
        this.runQueryAsync((Query<?>)new SqlFieldsQuery("select * from (select _val, sleep(100) from Value limit 50)"));
        Thread.sleep(500L);
        GridQueryProcessor qryProc = this.grid(0).context().query();
        Collection queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)1, (int)queries.size());
        Collection finalQueries = queries;
        for (GridRunningQueryInfo query : finalQueries) {
            qryProc.cancelQueries(Collections.singleton(query.id()));
        }
        for (int n = 100; n > 0; --n) {
            Thread.sleep(100L);
            queries = qryProc.runningQueries(0L);
            if (queries.isEmpty()) break;
            this.log.info(">>>> Wait for cancel: " + n);
        }
        queries = qryProc.runningQueries(0L);
        CacheSqlQueryValueCopySelfTest.assertEquals((int)0, (int)queries.size());
    }

    private void check(IgniteCache<Integer, Value> cache) {
        int cnt = 0;
        for (Cache.Entry entry : cache) {
            ++cnt;
            CacheSqlQueryValueCopySelfTest.assertEquals((String)("before-" + entry.getKey()), (String)((Value)entry.getValue()).str);
        }
        CacheSqlQueryValueCopySelfTest.assertEquals((int)100, (int)cnt);
    }

    public static class TestSQLFunctions {
        @QuerySqlFunction
        public static long sleep(long x) {
            if (x >= 0L) {
                try {
                    Thread.sleep(x);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return x;
        }
    }

    private static class Value {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String str;

        public Value(int id, String str) {
            this.id = id;
            this.str = str;
        }
    }
}

