/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class CacheQueryNewClientSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(IP_FINDER));
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    public void testQueryFromNewClient() throws Exception {
        Ignite srv = this.startGrid("server");
        for (int iter = 0; iter < 2; ++iter) {
            this.log.info("Iteration: " + iter);
            IgniteCache cache1 = srv.createCache(new CacheConfiguration().setName("cache1").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
            IgniteCache cache2 = srv.createCache(new CacheConfiguration().setName("cache2").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
            for (int i = 0; i < 10; ++i) {
                cache1.put((Object)i, (Object)i);
                cache2.put((Object)i, (Object)i);
            }
            Ignition.setClientMode((boolean)true);
            Ignite client = iter == 0 ? this.startGrid("client") : this.grid("client");
            IgniteCache cache = client.cache("cache1");
            List res = cache.query((Query)new SqlFieldsQuery("select i1._val, i2._val from Integer i1 cross join \"cache2\".Integer i2")).getAll();
            CacheQueryNewClientSelfTest.assertEquals((int)100, (int)res.size());
            srv.destroyCache(cache1.getName());
            srv.destroyCache(cache2.getName());
        }
    }

    public void testQueryFromNewClientCustomSchemaName() throws Exception {
        Ignite srv = this.startGrid("server");
        IgniteCache cache1 = srv.createCache(new CacheConfiguration().setName("cache1").setSqlSchema("cache1_sql").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        IgniteCache cache2 = srv.createCache(new CacheConfiguration().setName("cache2").setSqlSchema("cache2_sql").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        for (int i = 0; i < 10; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)i);
        }
        Ignition.setClientMode((boolean)true);
        Ignite client = this.startGrid("client");
        IgniteCache cache = client.cache("cache1");
        List res = cache.query((Query)new SqlFieldsQuery("select i1._val, i2._val from Integer i1 cross join cache2_sql.Integer i2")).getAll();
        CacheQueryNewClientSelfTest.assertEquals((int)100, (int)res.size());
    }
}

