/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class CacheQueryEvictDataLostTest
extends GridCommonAbstractTest {
    private static final int KEYS = 100000;

    public CacheQueryEvictDataLostTest() {
        super(true);
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration();
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName("cache-1");
        ccfg.setEvictionPolicy((EvictionPolicy)new LruEvictionPolicy(10));
        ccfg.setOnheapCacheEnabled(true);
        ccfg.setIndexedTypes(new Class[]{Integer.class, TestData.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    public void testQueryDataLost() throws Exception {
        final long stopTime = U.currentTimeMillis() + 30000L;
        GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

            void putGet(IgniteCache<Object, Object> cache) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                for (int i = 0; i < 100000; ++i) {
                    cache.put((Object)rnd.nextInt(100000), (Object)new TestData(i));
                    cache.get((Object)rnd.nextInt(100000));
                }
            }

            void query(IgniteCache<Object, Object> cache) {
                SqlQuery qry1 = new SqlQuery(TestData.class, "_key > ?");
                qry1.setArgs(new Object[]{50000});
                cache.query((Query)qry1).getAll();
                SqlQuery qry2 = new SqlQuery(TestData.class, "idxVal > ?");
                qry2.setArgs(new Object[]{50000});
                cache.query((Query)qry2).getAll();
            }

            public void apply(Integer idx) {
                IgniteCache cache1 = CacheQueryEvictDataLostTest.this.grid().cache("cache-1");
                while (U.currentTimeMillis() < stopTime) {
                    if (idx == 0) {
                        this.putGet((IgniteCache<Object, Object>)cache1);
                        continue;
                    }
                    this.query((IgniteCache<Object, Object>)cache1);
                }
            }
        }, (int)10, (String)"test-thread");
    }

    static class TestData
    implements Serializable {
        @QuerySqlField(index=true)
        private int idxVal;

        public TestData(int idxVal) {
            this.idxVal = idxVal;
        }
    }
}

