/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class CacheQueryBuildValueTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller(null);
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(IP_FINDER);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(TestBuilderValue.class.getName());
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        QueryIndex idx = new QueryIndex("iVal");
        idxs.add(idx);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("iVal", Integer.class.getName());
        entity.setFields(fields);
        entity.setIndexes(idxs);
        ccfg.setQueryEntities(Collections.singleton(entity));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        BinaryConfiguration binaryCfg = new BinaryConfiguration();
        BinaryTypeConfiguration typeCfg = new BinaryTypeConfiguration();
        typeCfg.setTypeName(TestBuilderValue.class.getName());
        binaryCfg.setTypeConfigurations(Collections.singletonList(typeCfg));
        cfg.setBinaryConfiguration(binaryCfg);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testBuilderAndQuery() throws Exception {
        Ignite node = this.ignite(0);
        IgniteCache cache = node.cache("default");
        IgniteBinary binary = node.binary();
        BinaryObjectBuilder builder = binary.builder(TestBuilderValue.class.getName());
        cache.put((Object)0, (Object)builder.build());
        builder.setField("iVal", (Object)1);
        cache.put((Object)1, (Object)builder.build());
        List entries = cache.query((Query)new SqlQuery(TestBuilderValue.class, "true")).getAll();
        CacheQueryBuildValueTest.assertEquals((int)2, (int)entries.size());
    }

    static class TestBuilderValue
    implements Serializable {
        private int iVal;

        public TestBuilderValue(int iVal) {
            this.iVal = iVal;
        }
    }
}

