/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import junit.framework.TestCase;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class CacheOperationsWithExpirationTest
extends GridCommonAbstractTest {
    private static final int KEYS = 10000;

    private CacheConfiguration<String, TestIndexedType> cacheConfiguration(CacheAtomicityMode atomicityMode, long offheapMem, boolean idx) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setAtomicityMode(atomicityMode);
        ccfg.setBackups(1);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        ccfg.setStatisticsEnabled(true);
        if (idx) {
            ccfg.setIndexedTypes(new Class[]{String.class, TestIndexedType.class});
        }
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testAtomicIndexEnabled() throws Exception {
        this.concurrentPutGetRemoveExpireAndQuery(this.cacheConfiguration(CacheAtomicityMode.ATOMIC, 0L, true));
    }

    public void testAtomic() throws Exception {
        this.concurrentPutGetRemoveExpireAndQuery(this.cacheConfiguration(CacheAtomicityMode.ATOMIC, 0L, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentPutGetRemoveExpireAndQuery(CacheConfiguration<String, TestIndexedType> ccfg) throws Exception {
        Ignite ignite = this.ignite(0);
        final IgniteCache cache = ignite.createCache(ccfg);
        final boolean qryEnabled = !F.isEmpty((Collection)ccfg.getQueryEntities());
        try {
            final long stopTime = U.currentTimeMillis() + 30000L;
            GridTestUtils.runMultiThreaded((IgniteInClosure)new IgniteInClosure<Integer>(){

                public void apply(Integer idx) {
                    while (U.currentTimeMillis() < stopTime) {
                        if (!qryEnabled || idx % 2 == 0) {
                            this.putGet((IgniteCache<String, TestIndexedType>)cache);
                            continue;
                        }
                        this.query((IgniteCache<String, TestIndexedType>)cache);
                    }
                }

                void putGet(IgniteCache<String, TestIndexedType> cache2) {
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    cache2 = cache2.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, rnd.nextLong(100L) + 1L)));
                    for (int i = 0; i < 10000; ++i) {
                        String key = String.valueOf(rnd.nextInt(10000));
                        cache2.put((Object)key, (Object)CacheOperationsWithExpirationTest.this.testValue(rnd));
                    }
                    TreeSet<String> s = new TreeSet<String>();
                    for (int i = 0; i < 1000; ++i) {
                        String key = String.valueOf(rnd.nextInt(10000));
                        s.add(key);
                    }
                    cache2.getAll(s);
                    cache2.removeAll(s);
                }

                void query(IgniteCache<String, TestIndexedType> cache2) {
                    SqlFieldsQuery qry1;
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    String k = String.valueOf(rnd.nextInt(10000));
                    if (rnd.nextBoolean()) {
                        qry1 = new SqlFieldsQuery("select _key, _val from TestIndexedType where key1=? and intVal=?");
                        qry1.setArgs(new Object[]{k, k});
                    } else {
                        qry1 = new SqlFieldsQuery("select _key, _val from TestIndexedType");
                    }
                    List res = cache2.query((Query)qry1).getAll();
                    TestCase.assertNotNull((Object)res);
                }
            }, (int)10, (String)"test-thread");
        }
        finally {
            ignite.destroyCache(cache.getName());
        }
    }

    private TestIndexedType testValue(ThreadLocalRandom rnd) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < rnd.nextInt(100); ++i) {
            builder.append("string");
        }
        return new TestIndexedType(rnd.nextInt(10000), builder.toString());
    }

    public static class TestIndexedType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @QuerySqlField
        private final String key;
        @QuerySqlField(index=true)
        private final String key1;
        @QuerySqlField(index=true)
        private final String key2;
        @QuerySqlField(index=true)
        private final String key3;
        @QuerySqlField(index=true)
        private final int intVal;
        private final EnumType1 type1;
        @QuerySqlField(index=true)
        private final EnumType2 type2;
        @QuerySqlField(index=true)
        private final Date date1;
        @QuerySqlField(index=true)
        private final Date date2;
        private final Byte byteVal1;
        private final Byte byteVal2;

        public TestIndexedType(int rnd, String strVal) {
            this.intVal = rnd;
            this.key1 = this.key = String.valueOf(rnd);
            this.key2 = strVal;
            this.key3 = strVal;
            this.date1 = new Date(rnd);
            this.date2 = new Date(U.currentTimeMillis());
            this.type1 = EnumType1.vals[rnd % EnumType1.vals.length];
            this.type2 = EnumType2.vals[rnd % EnumType2.vals.length];
            this.byteVal1 = (byte)rnd;
            this.byteVal2 = (byte)rnd;
        }
    }

    public static enum EnumType2 {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4;

        static final EnumType2[] vals;

        static {
            vals = EnumType2.values();
        }
    }

    public static enum EnumType1 {
        TYPE1,
        TYPE2,
        TYPE3;

        static final EnumType1[] vals;

        static {
            vals = EnumType1.values();
        }
    }
}

