/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.TreeMap;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheOffheapBatchIndexingBaseTest;

public class CacheOffheapBatchIndexingMultiTypeTest
extends CacheOffheapBatchIndexingBaseTest {
    public void testPutAllMultupleEntitiesAndStreamer() {
        this.doStreamerBatchTest(50, 1000, new Class[]{Integer.class, CacheOffheapBatchIndexingBaseTest.Person.class, Integer.class, CacheOffheapBatchIndexingBaseTest.Organization.class}, true);
    }

    public void testPuAllSingleEntity() {
        this.doStreamerBatchTest(50, 1000, new Class[]{Integer.class, CacheOffheapBatchIndexingBaseTest.Organization.class}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStreamerBatchTest(int iterations, int entitiesCnt, Class<?>[] entityClasses, boolean preloadInStreamer) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.createCache(this.cacheConfiguration(entityClasses));
        try {
            if (preloadInStreamer) {
                this.preload(cache.getName());
            }
            while (iterations-- >= 0) {
                TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Person> putMap1 = new TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Person>();
                for (int i = 0; i < entitiesCnt; ++i) {
                    putMap1.put(i, new CacheOffheapBatchIndexingBaseTest.Person(i, i + 1, String.valueOf(i), String.valueOf(i + 1), this.salary(i)));
                }
                cache.putAll(putMap1);
                TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization> putMap2 = new TreeMap<Integer, CacheOffheapBatchIndexingBaseTest.Organization>();
                for (int i = entitiesCnt / 2; i < entitiesCnt * 3 / 2; ++i) {
                    cache.remove((Object)i);
                    putMap2.put(i, new CacheOffheapBatchIndexingBaseTest.Organization(i, String.valueOf(i)));
                }
                cache.putAll(putMap2);
            }
        }
        finally {
            cache.destroy();
        }
    }
}

