/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class CacheOffheapBatchIndexingBaseTest
extends GridCommonAbstractTest {
    private final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected void preload(String name) {
        try (IgniteDataStreamer streamer = this.ignite(0).dataStreamer(name);){
            for (int i = 0; i < 30000; ++i) {
                if (i % 2 == 0) {
                    streamer.addData((Object)i, (Object)new Person(i, i + 1, String.valueOf(i), String.valueOf(i + 1), this.salary(i)));
                    continue;
                }
                streamer.addData((Object)i, (Object)new Organization(i, String.valueOf(i)));
            }
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(this.ipFinder);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    protected double salary(int base) {
        return (double)base * 100.0;
    }

    protected CacheConfiguration<Object, Object> cacheConfiguration(Class<?>[] indexedTypes) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setIndexedTypes((Class[])indexedTypes);
        return ccfg;
    }

    protected static class Organization
    implements Binarylizable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private String name;

        public Organization() {
        }

        public Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.writeInt("id", this.id);
            writer.writeString("name", this.name);
        }

        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.id = reader.readInt("id");
            this.name = reader.readString("name");
        }
    }

    protected static class Person
    implements Binarylizable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orgId;
        @QuerySqlField
        private String firstName;
        @QuerySqlField
        private String lastName;
        @QuerySqlField(index=true)
        private double salary;

        public Person() {
        }

        public Person(int id, int orgId, String firstName, String lastName, double salary) {
            this.id = id;
            this.orgId = orgId;
            this.firstName = firstName;
            this.lastName = lastName;
            this.salary = salary;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getOrganizationId() {
            return this.orgId;
        }

        public void setOrganizationId(int orgId) {
            this.orgId = orgId;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public double getSalary() {
            return this.salary;
        }

        public void setSalary(double salary) {
            this.salary = salary;
        }

        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.writeInt("id", this.id);
            writer.writeInt("orgId", this.orgId);
            writer.writeString("firstName", this.firstName);
            writer.writeString("lastName", this.lastName);
            writer.writeDouble("salary", this.salary);
        }

        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.id = reader.readInt("id");
            this.orgId = reader.readInt("orgId");
            this.firstName = reader.readString("firstName");
            this.lastName = reader.readString("lastName");
            this.salary = reader.readDouble("salary");
        }
    }
}

