/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tests.p2p;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.resources.TaskSessionResource;

public class P2PTestTaskExternalPath2
extends ComputeTaskAdapter<Object, Integer> {
    @LoggerResource
    private IgniteLogger log;

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, Object arg) {
        boolean sleep;
        Set<UUID> nodeIds;
        if (this.log.isInfoEnabled()) {
            this.log.info("Mapping [task=" + (Object)((Object)this) + ", subgrid=" + F.viewReadOnly(subgrid, (IgniteClosure)F.node2id(), (IgnitePredicate[])new IgnitePredicate[0]) + ", arg=" + arg + ']');
        }
        if (arg instanceof Object[]) {
            nodeIds = Collections.singleton((UUID)((Object[])arg)[0]);
            sleep = (Boolean)((Object[])arg)[1];
        } else if (arg instanceof List) {
            nodeIds = new HashSet<UUID>((Collection)arg);
            sleep = false;
        } else {
            nodeIds = Collections.singleton((UUID)arg);
            sleep = false;
        }
        HashMap jobs = U.newHashMap((int)subgrid.size());
        for (ClusterNode node : subgrid) {
            if (!nodeIds.contains(node.id())) continue;
            jobs.put(new TestJob(node.id(), sleep), node);
        }
        if (!jobs.isEmpty()) {
            return jobs;
        }
        throw new IgniteException("Failed to find target node: " + arg);
    }

    public Integer reduce(List<ComputeJobResult> results) {
        return (Integer)results.get(0).getData();
    }

    public static class TestJob
    extends ComputeJobAdapter {
        @IgniteInstanceResource
        private Ignite ignite;
        @TaskSessionResource
        private ComputeTaskSession ses;
        @LoggerResource
        private IgniteLogger log;
        private boolean sleep;

        public TestJob(UUID nodeId, boolean sleep) {
            super((Object)nodeId);
            this.sleep = sleep;
        }

        public Integer execute() {
            assert (this.ignite.configuration().getNodeId().equals(this.argument(0)));
            if (this.sleep) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    this.log.info("Job has been cancelled. Caught exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
            return System.identityHashCode(this.ses.getClassLoader());
        }
    }
}

