/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tests.p2p;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class JobStealingTask
extends ComputeTaskAdapter<Object, Map<UUID, Integer>> {
    private static final int N_JOBS = 4;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (!subgrid.isEmpty());
        HashMap map = U.newHashMap((int)subgrid.size());
        for (int i = 0; i < 4; ++i) {
            map.put(new GridJobStealingJob(5000L), subgrid.get(0));
        }
        return map;
    }

    public Map<UUID, Integer> reduce(List<ComputeJobResult> results) {
        HashMap ret = U.newHashMap((int)results.size());
        for (ComputeJobResult res : results) {
            this.log.info("Job result: " + res.getData());
            UUID resUuid = (UUID)res.getData();
            ret.put(resUuid, ret.containsKey(resUuid) ? (Integer)ret.get(resUuid) + 1 : 1);
        }
        return ret;
    }

    private static final class GridJobStealingJob
    extends ComputeJobAdapter {
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;

        GridJobStealingJob(Long arg) {
            super((Object)arg);
        }

        public Serializable execute() {
            this.log.info("Started job on node: " + this.ignite.cluster().localNode().id());
            try {
                Long sleep = (Long)this.argument(0);
                assert (sleep != null);
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                this.log.info("Job got interrupted on node: " + this.ignite.cluster().localNode().id());
                throw new IgniteException("Job got interrupted.", (Throwable)e);
            }
            finally {
                this.log.info("Job finished on node: " + this.ignite.cluster().localNode().id());
            }
            return this.ignite.cluster().localNode().id();
        }
    }
}

