/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tests.p2p;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.util.typedef.P2;
import org.apache.ignite.resources.IgniteInstanceResource;

public class GridTestMessageListener
implements P2<UUID, Object> {
    @IgniteInstanceResource
    private Ignite ignite;

    public boolean apply(UUID nodeId, Object msg) {
        AtomicInteger old;
        this.ignite.log().info("Received message [nodeId=" + nodeId + ", locNodeId=" + this.ignite.cluster().localNode().id() + ", msg=" + msg + ']');
        ConcurrentMap map = this.ignite.cluster().nodeLocalMap();
        AtomicInteger cnt = (AtomicInteger)map.get("msgCnt");
        if (cnt == null && (old = map.putIfAbsent("msgCnt", cnt = new AtomicInteger(0))) != null) {
            cnt = old;
        }
        cnt.incrementAndGet();
        return true;
    }
}

