/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tests.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridExternalAffinityFunction
implements AffinityFunction {
    public static final String IDX_ATTR = "nodeIndex";
    private int backups;
    private int parts;

    public GridExternalAffinityFunction() {
        this(2, 0);
    }

    public GridExternalAffinityFunction(int parts, int backups) {
        assert (parts > 0);
        assert (backups >= 0);
        this.parts = parts;
        this.backups = backups;
    }

    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext ctx) {
        ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(this.partitions());
        List topSnapshot = ctx.currentTopologySnapshot();
        for (int part = 0; part < this.parts; ++part) {
            res.add(F.isEmpty((Collection)topSnapshot) ? Collections.emptyList() : U.sealList(this.nodes(part, topSnapshot)));
        }
        return res;
    }

    public Collection<ClusterNode> nodes(int part, Collection<ClusterNode> nodes) {
        ArrayList<ClusterNode> sorted = new ArrayList<ClusterNode>(nodes);
        Collections.sort(sorted, new Comparator<ClusterNode>(){

            @Override
            public int compare(ClusterNode n1, ClusterNode n2) {
                int idx2;
                int idx1 = (Integer)n1.attribute(GridExternalAffinityFunction.IDX_ATTR);
                return idx1 < (idx2 = ((Integer)n2.attribute(GridExternalAffinityFunction.IDX_ATTR)).intValue()) ? -1 : (idx1 == idx2 ? 0 : 1);
            }
        });
        int max = 1 + this.backups;
        if (max > nodes.size()) {
            max = nodes.size();
        }
        ArrayList<ClusterNode> ret = new ArrayList<ClusterNode>(max);
        Iterator it = sorted.iterator();
        for (int i = 0; i < max; ++i) {
            ClusterNode n = null;
            if (i == 0) {
                int nodeIdx;
                while (it.hasNext() && part > (nodeIdx = ((Integer)(n = (ClusterNode)it.next()).attribute(IDX_ATTR)).intValue())) {
                    n = null;
                }
            } else if (it.hasNext()) {
                n = (ClusterNode)it.next();
            } else {
                it = sorted.iterator();
                assert (it.hasNext());
                n = (ClusterNode)it.next();
            }
            assert (n != null || nodes.size() < this.parts);
            if (n == null) {
                it = sorted.iterator();
                n = (ClusterNode)it.next();
            }
            ret.add(n);
        }
        return ret;
    }

    public void reset() {
    }

    public int partitions() {
        return this.parts;
    }

    public int partition(Object key) {
        return key instanceof Integer ? (0 == (Integer)key ? 0 : 1) : 1;
    }

    public void removeNode(UUID nodeId) {
    }

    public String toString() {
        return S.toString(GridExternalAffinityFunction.class, (Object)this);
    }
}

