/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.ProgressPrinter;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;
import org.apache.ignite.internal.commandline.indexreader.CacheAwareLink;
import org.apache.ignite.internal.commandline.indexreader.CountOnlyStorage;
import org.apache.ignite.internal.commandline.indexreader.ItemStorage;
import org.apache.ignite.internal.commandline.indexreader.ItemsListStorage;
import org.apache.ignite.internal.commandline.indexreader.LinkStorage;
import org.apache.ignite.internal.commandline.indexreader.PageListsInfo;
import org.apache.ignite.internal.commandline.indexreader.ScanContext;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.pagemem.PageIdAllocator;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingRowIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.GridPlainClosure2;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.lang.RunnableX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexReader
implements AutoCloseable {
    public static final String META_TREE_NAME = "MetaTree";
    public static final String RECURSIVE_TRAVERSE_NAME = "<RECURSIVE> ";
    public static final String HORIZONTAL_SCAN_NAME = "<HORIZONTAL> ";
    private static final String PAGE_LISTS_PREFIX = "<PAGE_LIST> ";
    public static final String ERROR_PREFIX = "<ERROR> ";
    private static final String DIR_ARG = "--dir";
    private static final String PART_CNT_ARG = "--part-cnt";
    private static final String PAGE_SIZE_ARG = "--page-size";
    private static final String PAGE_STORE_VER_ARG = "--page-store-ver";
    private static final String INDEXES_ARG = "--indexes";
    private static final String CHECK_PARTS_ARG = "--check-parts";
    private static final Pattern CACHE_TYPE_ID_INDEX_SEARCH_PATTERN = Pattern.compile("(?<id>[-0-9]{1,15})_(?<typeId>[-0-9]{1,15})_(?<indexName>.*)##.*");
    private static final Pattern CACHE_TYPE_ID_SEARCH_PATTERN = Pattern.compile("(?<id>[-0-9]{1,15})_(?<typeId>[-0-9]{1,15})_.*");
    private static final Pattern CACHE_ID_SEARCH_PATTERN = Pattern.compile("(?<id>[-0-9]{1,15})_.*");
    private static final int MAX_ERRORS_CNT = 10;
    static final int UNKNOWN_CACHE = -1;
    private final File root;
    private final int pageSize;
    private final int partCnt;
    private final boolean checkParts;
    @Nullable
    private final Predicate<String> idxFilter;
    private final Logger log;
    private final FilePageStore idxStore;
    private final FilePageStore[] partStores;
    private final Map<Integer, StoredCacheData> storedCacheData = new HashMap<Integer, StoredCacheData>();
    private final Set<Integer> missingPartitions = new HashSet<Integer>();
    private final Set<Long> pageIds = new HashSet<Long>();
    private final InnerPageVisitor innerPageVisitor = new InnerPageVisitor();
    private final LeafPageVisitor leafPageVisitor = new LeafPageVisitor();
    private final MetaPageVisitor metaPageVisitor = new MetaPageVisitor();
    private final LevelsPageVisitor levelsPageVisitor = new LevelsPageVisitor();
    private final Map<String, GridTuple3<Integer, Integer, String>> cacheTypeIds = new HashMap<String, GridTuple3<Integer, Integer, String>>();

    public IgniteIndexReader(int pageSize, int partCnt, final int filePageStoreVer, File root, @Nullable Predicate<String> idxFilter, boolean checkParts, Logger log) throws IgniteCheckedException {
        this.pageSize = pageSize;
        this.partCnt = partCnt;
        this.root = root;
        this.checkParts = checkParts;
        this.idxFilter = idxFilter;
        this.log = log;
        FileVersionCheckingFactory storeFactory = new FileVersionCheckingFactory((FileIOFactory)new AsyncFileIOFactory(), (FileIOFactory)new AsyncFileIOFactory(), () -> pageSize){

            public int latestVersion() {
                return filePageStoreVer;
            }
        };
        this.idxStore = this.filePageStore(65535, (byte)2, storeFactory);
        if (Objects.isNull(this.idxStore)) {
            throw new IgniteCheckedException("index.bin file not found");
        }
        log.info("Analyzing file: index.bin");
        this.partStores = new FilePageStore[partCnt];
        for (int i = 0; i < partCnt; ++i) {
            this.partStores[i] = this.filePageStore(i, (byte)1, storeFactory);
        }
        Arrays.stream(root.listFiles(f -> f.getName().endsWith("cache_data.dat"))).forEach(f -> {
            try (ObjectInputStream stream = new ObjectInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
                StoredCacheData data = (StoredCacheData)stream.readObject();
                this.storedCacheData.put(CU.cacheId((String)data.config().getName()), data);
            }
            catch (IOException | ClassNotFoundException e) {
                log.log(Level.WARNING, "Can't read stored cache data. Inline for this cache will not be analyzed [f=" + f.getName() + ']', e);
            }
        });
    }

    public static void main(String[] args) {
        System.out.println("THIS UTILITY MUST BE LAUNCHED ON PERSISTENT STORE WHICH IS NOT UNDER RUNNING GRID!");
        CLIArgumentParser p = new CLIArgumentParser(Arrays.asList(CLIArgument.mandatoryArg(DIR_ARG, "partition directory, where index.bin and (optionally) partition files are located.", String.class), CLIArgument.optionalArg(PART_CNT_ARG, "full partitions count in cache group.", Integer.class, () -> 0), CLIArgument.optionalArg(PAGE_SIZE_ARG, "page size.", Integer.class, () -> 4096), CLIArgument.optionalArg(PAGE_STORE_VER_ARG, "page store version.", Integer.class, () -> 2), CLIArgument.optionalArg(INDEXES_ARG, "you can specify index tree names that will be processed, separated by comma without spaces, other index trees will be skipped.", String[].class, () -> U.EMPTY_STRS), CLIArgument.optionalArg(CHECK_PARTS_ARG, "check cache data tree in partition files and it's consistency with indexes.", Boolean.class, () -> false)));
        if (args.length == 0) {
            System.out.println(p.usage());
            return;
        }
        p.parse(Arrays.asList(args).iterator());
        HashSet<Object> idxs = new HashSet<Object>(Arrays.asList((Object[])p.get(INDEXES_ARG)));
        try (IgniteIndexReader reader = new IgniteIndexReader((Integer)p.get(PAGE_SIZE_ARG), (Integer)p.get(PART_CNT_ARG), (Integer)p.get(PAGE_STORE_VER_ARG), new File((String)p.get(DIR_ARG)), idxs.isEmpty() ? null : idxs::contains, (Boolean)p.get(CHECK_PARTS_ARG), CommandHandler.setupJavaLogger("index-reader", IgniteIndexReader.class));){
            reader.readIndex();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("index.bin scan problem", (Throwable)e);
        }
    }

    public void readIndex() throws IgniteCheckedException {
        long pagesCnt = (this.idxStore.size() - (long)this.idxStore.headerSize()) / (long)this.pageSize;
        this.log.info("Partitions files num: " + Arrays.stream(this.partStores).filter(Objects::nonNull).count());
        this.log.info("Going to check " + pagesCnt + " pages.");
        long[] indexPartitionRoots = this.partitionRoots(PageIdAllocator.META_PAGE_ID);
        Map<String, ScanContext> recursiveScans = this.scanAllTrees("Scan index trees recursively", indexPartitionRoots[0], CountOnlyStorage::new, this::recursiveTreeScan, pagesCnt);
        Map<String, ScanContext> horizontalScans = this.scanAllTrees("Scan index trees horizontally", indexPartitionRoots[0], this.checkParts ? LinkStorage::new : CountOnlyStorage::new, this::horizontalTreeScan, pagesCnt);
        this.printScanResults(RECURSIVE_TRAVERSE_NAME, recursiveScans);
        this.printScanResults(HORIZONTAL_SCAN_NAME, horizontalScans);
        this.compareScans(recursiveScans, horizontalScans);
        this.printPagesListsInfo(indexPartitionRoots[1]);
        this.printSequentialScanInfo(this.scanIndexSequentially());
        if (this.checkParts) {
            this.checkParts(horizontalScans);
        }
    }

    private Map<String, ScanContext> scanAllTrees(String caption, long metaTreeRoot, Supplier<ItemStorage> itemStorageFactory, Scanner scanner, long pagesCnt) {
        LinkedHashMap<String, ScanContext> ctxs = new LinkedHashMap<String, ScanContext>();
        ProgressPrinter progressPrinter = this.createProgressPrinter(caption, pagesCnt);
        ScanContext metaTreeCtx = scanner.scan(metaTreeRoot, META_TREE_NAME, new ItemsListStorage(), progressPrinter);
        this.log.info("Going to scan " + metaTreeCtx.items.size() + " trees.");
        ctxs.put(META_TREE_NAME, metaTreeCtx);
        AtomicInteger treeCnt = new AtomicInteger();
        ((ItemsListStorage)metaTreeCtx.items).forEach(item -> {
            this.log.info("Scanning [num=" + treeCnt.incrementAndGet() + ", of=" + metaTreeCtx.items.size() + ", idx=" + item.nameString() + "]");
            if (Objects.nonNull(this.idxFilter) && !this.idxFilter.test(item.nameString())) {
                return;
            }
            ScanContext ctx = scanner.scan(IgniteIndexReader.normalizePageId(item.pageId()), item.nameString(), (ItemStorage)itemStorageFactory.get(), progressPrinter);
            ctxs.put(item.toString(), ctx);
        });
        return ctxs;
    }

    ScanContext recursiveTreeScan(long rootPageId, String idx, ItemStorage items, ProgressPrinter printer) {
        ScanContext ctx = this.createContext(idx, this.filePageStore(rootPageId), items, RECURSIVE_TRAVERSE_NAME, printer);
        this.metaPageVisitor.readAndVisit(rootPageId, ctx);
        return ctx;
    }

    private ScanContext horizontalTreeScan(long rootPageId, String idx, ItemStorage items, ProgressPrinter printer) {
        ScanContext ctx = this.createContext(idx, this.filePageStore(rootPageId), items, HORIZONTAL_SCAN_NAME, printer);
        this.levelsPageVisitor.readAndVisit(rootPageId, ctx);
        return ctx;
    }

    private PageListsInfo pageListsInfo(long metaPageListId) throws IgniteCheckedException {
        return (PageListsInfo)this.doWithBuffer((buf, addr) -> {
            HashMap<IgniteBiTuple<Long, Integer>, List<Long>> bucketsData = new HashMap<IgniteBiTuple<Long, Integer>, List<Long>>();
            HashMap<Class<? extends PageIO>, ScanContext.PagesStatistic> stats = new HashMap<Class<? extends PageIO>, ScanContext.PagesStatistic>();
            long pagesCnt = 0L;
            long errCnt = 0L;
            long currMetaPageId = metaPageListId;
            while (currMetaPageId != 0L) {
                try {
                    PagesListMetaIO io = (PagesListMetaIO)this.readPage(this.idxStore, currMetaPageId, (ByteBuffer)buf);
                    ScanContext.addToStats((PageIO)io, stats, 1L, addr, this.idxStore.getPageSize());
                    HashMap data = new HashMap();
                    io.getBucketsData(addr.longValue(), data);
                    for (Map.Entry e : data.entrySet()) {
                        List listIds = LongStream.of(((GridLongList)e.getValue()).array()).map(IgniteIndexReader::normalizePageId).boxed().collect(Collectors.toList());
                        for (Long listId : listIds) {
                            try {
                                pagesCnt += this.visitPageList(listId, stats);
                            }
                            catch (Exception err) {
                                ++errCnt;
                                ScanContext.onError(this.log, PAGE_LISTS_PREFIX, listId, err.getMessage());
                            }
                        }
                        bucketsData.put((IgniteBiTuple<Long, Integer>)F.t((Object)currMetaPageId, e.getKey()), listIds);
                    }
                    currMetaPageId = io.getNextMetaPageId(addr.longValue());
                }
                catch (Exception err) {
                    ++errCnt;
                    ScanContext.onError(this.log, PAGE_LISTS_PREFIX, currMetaPageId, err.getMessage());
                    break;
                }
            }
            return new PageListsInfo(bucketsData, pagesCnt, stats, errCnt);
        });
    }

    private long visitPageList(long listStartPageId, Map<Class<? extends PageIO>, ScanContext.PagesStatistic> stats) throws IgniteCheckedException {
        return (Long)this.doWithBuffer((nodeBuf, nodeAddr) -> (Long)this.doWithBuffer((pageBuf, pageAddr) -> {
            long res = 0L;
            long currPageId = listStartPageId;
            while (currPageId != 0L) {
                PagesListNodeIO io = (PagesListNodeIO)this.readPage(this.idxStore, currPageId, (ByteBuffer)nodeBuf);
                ScanContext.addToStats((PageIO)io, stats, 1L, nodeAddr, this.idxStore.getPageSize());
                ScanContext.addToStats(this.readPage(this.idxStore, currPageId, (ByteBuffer)pageBuf), stats, 1L, pageAddr, this.idxStore.getPageSize());
                res += (long)io.getCount(nodeAddr.longValue());
                for (int i = 0; i < io.getCount(nodeAddr.longValue()); ++i) {
                    long pageId = IgniteIndexReader.normalizePageId(io.getAt(nodeAddr.longValue(), i));
                    ScanContext.addToStats(this.readPage(this.idxStore, pageId, (ByteBuffer)pageBuf), stats, 1L, pageAddr, this.idxStore.getPageSize());
                }
                currPageId = io.getNextId(nodeAddr.longValue());
            }
            return res;
        }));
    }

    private ScanContext scanIndexSequentially() throws IgniteCheckedException {
        long pagesNum = (this.idxStore.size() - (long)this.idxStore.headerSize()) / (long)this.pageSize;
        ProgressPrinter progressPrinter = this.createProgressPrinter("Reading pages sequentially", pagesNum);
        ScanContext ctx = this.createContext(null, this.idxStore, new CountOnlyStorage(), "", progressPrinter);
        this.doWithBuffer((buf, addr) -> {
            int i = 0;
            while ((long)i < pagesNum) {
                long pageId = -1L;
                try {
                    pageId = PageIdUtils.pageId((int)65535, (byte)2, (int)i);
                    Object io = this.readPage(ctx, pageId, (ByteBuffer)buf, false);
                    if (this.idxFilter == null && !(io instanceof TrackingPageIO) && !this.pageIds.contains(IgniteIndexReader.normalizePageId(pageId))) {
                        ctx.onError(pageId, "Error [step=" + i + ", msg=Possibly orphan " + io.getClass().getSimpleName() + " page, pageId=" + IgniteIndexReader.normalizePageId(pageId) + ']');
                    }
                }
                catch (AssertionError | Exception e) {
                    ctx.onError(pageId, "Error [step=" + i + ", msg=" + ((Throwable)e).getMessage() + ']');
                }
                ++i;
            }
            return null;
        });
        return ctx;
    }

    private void checkParts(Map<String, ScanContext> treesInfo) {
        this.log.info("");
        AtomicInteger partWithErrs = new AtomicInteger();
        AtomicInteger errSum = new AtomicInteger();
        ProgressPrinter progressPrinter = this.createProgressPrinter("Checking partitions", this.partCnt);
        IntStream.range(0, this.partCnt).forEach(partId -> {
            progressPrinter.printProgress();
            FilePageStore partStore = this.partStores[partId];
            if (partStore == null) {
                return;
            }
            AtomicInteger errCnt = new AtomicInteger();
            try {
                long partMetaId = PageIdUtils.pageId((int)partId, (byte)1, (int)0);
                this.doWithBuffer((buf, addr) -> {
                    PagePartitionMetaIO partMetaIO = (PagePartitionMetaIO)this.readPage(partStore, partMetaId, (ByteBuffer)buf);
                    long cacheDataTreeRoot = partMetaIO.getTreeRoot(addr.longValue());
                    ScanContext ctx = this.horizontalTreeScan(cacheDataTreeRoot, "dataTree-" + partId, new ItemsListStorage(), null);
                    for (Object dataTreeItem : ctx.items) {
                        CacheAwareLink cacheAwareLink = (CacheAwareLink)dataTreeItem;
                        for (Map.Entry e : treesInfo.entrySet()) {
                            if (((String)e.getKey()).equals(META_TREE_NAME) || (Integer)this.cacheAndTypeId((String)e.getKey()).get1() != cacheAwareLink.cacheId || ((ScanContext)e.getValue()).items.contains(cacheAwareLink)) continue;
                            long pageId = PageIdUtils.pageId((long)cacheAwareLink.link);
                            errCnt.getAndIncrement();
                            this.log.severe("<ERROR> Entry is missing in index[name=" + (String)e.getKey() + "cacheId=" + cacheAwareLink.cacheId + ", partId=" + PageIdUtils.partId((long)pageId) + ", pageIndex=" + PageIdUtils.pageIndex((long)pageId) + ", itemId=" + PageIdUtils.itemId((long)cacheAwareLink.link) + ", link=" + cacheAwareLink.link + ']');
                        }
                        if (errCnt.get() < 10) continue;
                        this.log.severe("<ERROR> Too many errors (10) found for partId=" + partId + ", stopping analysis for this partition.");
                        break;
                    }
                    return null;
                });
            }
            catch (IgniteCheckedException e) {
                this.log.severe("<ERROR> Partition check failed [partId=" + partId + ']');
            }
            if (errCnt.get() != 0) {
                partWithErrs.getAndIncrement();
                errSum.addAndGet(errCnt.get());
            }
        });
        if (errSum.get() == 0) {
            this.log.info("Partitions check detected no errors.");
        }
        this.log.info("Partition check finished, total errors: " + errSum.get() + ", total problem partitions: " + partWithErrs.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithBuffer(GridPlainClosure2<ByteBuffer, Long, T> c) throws IgniteCheckedException {
        ByteBuffer buf = GridUnsafe.allocateBuffer((int)this.pageSize);
        try {
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            Object object = c.apply((Object)buf, (Object)addr);
            return (T)object;
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
    }

    private void doWithoutErrors(RunnableX x, ScanContext ctx, long pageId) {
        try {
            x.run();
        }
        catch (AssertionError | Exception e) {
            ctx.onError(pageId, ((Throwable)e).getMessage());
        }
    }

    public GridTuple3<Integer, Integer, String> cacheAndTypeId(String name) {
        return this.cacheTypeIds.computeIfAbsent(name, k -> {
            Matcher xId = CACHE_TYPE_ID_INDEX_SEARCH_PATTERN.matcher((CharSequence)k);
            if (xId.find()) {
                return new GridTuple3((Object)Integer.parseInt(xId.group("id")), (Object)Integer.parseInt(xId.group("typeId")), (Object)xId.group("indexName"));
            }
            Matcher mId = CACHE_TYPE_ID_SEARCH_PATTERN.matcher((CharSequence)k);
            if (mId.find()) {
                return new GridTuple3((Object)Integer.parseInt(mId.group("id")), (Object)Integer.parseInt(mId.group("typeId")), null);
            }
            Matcher cId = CACHE_ID_SEARCH_PATTERN.matcher((CharSequence)k);
            if (cId.find()) {
                return new GridTuple3((Object)Integer.parseInt(cId.group("id")), (Object)0, null);
            }
            return new GridTuple3((Object)0, (Object)0, null);
        });
    }

    ScanContext createContext(String idxName, FilePageStore store, ItemStorage items, String prefix, ProgressPrinter printer) {
        GridTuple3 parsed = idxName != null ? this.cacheAndTypeId(idxName) : new GridTuple3((Object)-1, (Object)0, null);
        return new ScanContext((Integer)parsed.get1(), idxName, this.inlineFieldsCount((GridTuple3<Integer, Integer, String>)parsed), store, items, this.log, prefix, printer);
    }

    protected int inlineFieldsCount(GridTuple3<Integer, Integer, String> parsed) {
        if ((Integer)parsed.get1() == -1 || !this.storedCacheData.containsKey(parsed.get1())) {
            return 0;
        }
        StoredCacheData data = this.storedCacheData.get(parsed.get1());
        if (Objects.equals("_key_PK", parsed.get3())) {
            if (data.queryEntities().size() > 1) {
                this.log.warning("Can't parse inline for PK index when multiple query entities defined for a cache [idx=" + (String)parsed.get3() + ']');
                return 0;
            }
            QueryEntity qe = (QueryEntity)data.queryEntities().iterator().next();
            return qe.getKeyFields() == null ? 1 : qe.getKeyFields().size();
        }
        QueryIndex idx = null;
        for (QueryEntity qe : data.queryEntities()) {
            for (QueryIndex idx0 : qe.getIndexes()) {
                if (!Objects.equals(idx0.getName(), parsed.get3())) continue;
                idx = idx0;
                break;
            }
            if (idx == null) continue;
            break;
        }
        if (idx == null) {
            this.log.warning("Can't find index definition. Inline information not available [idx=" + (String)parsed.get3() + ']');
            return 0;
        }
        return idx.getFields().size();
    }

    ProgressPrinter createProgressPrinter(String caption, long total) {
        return new ProgressPrinter(System.out, caption, total);
    }

    FilePageStore filePageStore(long rootPageId) {
        int partId = PageIdUtils.partId((long)rootPageId);
        return partId == 65535 ? this.idxStore : this.partStores[partId];
    }

    static long normalizePageId(long pageId) {
        return PageIdUtils.pageId((int)PageIdUtils.partId((long)pageId), (byte)PageIdUtils.flag((long)pageId), (int)PageIdUtils.pageIndex((long)pageId));
    }

    private <I extends PageIO> I readPage(FilePageStore store, long pageId, ByteBuffer buf) throws IgniteCheckedException {
        return this.readPage(store, pageId, buf, true);
    }

    private <I extends PageIO> I readPage(FilePageStore store, long pageId, ByteBuffer buf, boolean addToPageIds) throws IgniteCheckedException {
        try {
            store.read(pageId, (ByteBuffer)buf.rewind(), false);
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            if (store == this.idxStore && addToPageIds) {
                this.pageIds.add(IgniteIndexReader.normalizePageId(pageId));
            }
            PageIO io = PageIO.getPageIO((long)addr);
            return (I)io;
        }
        catch (IllegalArgumentException | IgniteDataIntegrityViolationException e) {
            String msg = e.getMessage();
            throw new IgniteException("Failed to read page, id=" + pageId + ", idx=" + PageIdUtils.pageIndex((long)pageId) + ", err=" + (msg.length() > 100 ? msg.substring(0, 97) + "..." : msg) + ", file=" + store.getFileAbsolutePath());
        }
    }

    protected <I extends PageIO> I readPage(ScanContext ctx, long pageId, ByteBuffer buf) throws IgniteCheckedException {
        return this.readPage(ctx, pageId, buf, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <I extends PageIO> I readPage(ScanContext ctx, long pageId, ByteBuffer buf, boolean addToPageIds) throws IgniteCheckedException {
        try {
            I io = this.readPage(ctx.store, pageId, buf, addToPageIds);
            ctx.addToStats((PageIO)io, GridUnsafe.bufferAddress((ByteBuffer)buf));
            I i = io;
            return i;
        }
        finally {
            ctx.progress();
        }
    }

    long[] partitionRoots(long metaPageId) throws IgniteCheckedException {
        return (long[])this.doWithBuffer((buf, addr) -> {
            PageMetaIO pageMetaIO = (PageMetaIO)this.readPage(this.filePageStore(metaPageId), metaPageId, (ByteBuffer)buf);
            return new long[]{IgniteIndexReader.normalizePageId(pageMetaIO.getTreeRoot(addr.longValue())), IgniteIndexReader.normalizePageId(pageMetaIO.getReuseListRoot(addr.longValue()))};
        });
    }

    private void compareScans(Map<String, ScanContext> recursiveScans, Map<String, ScanContext> horizontalScans) {
        AtomicInteger errCnt = new AtomicInteger();
        recursiveScans.forEach((name, rctx) -> {
            ScanContext hctx = (ScanContext)horizontalScans.get(name);
            if (hctx == null) {
                errCnt.incrementAndGet();
                this.log.severe("Tree was detected in <RECURSIVE>  but absent in  <HORIZONTAL> : " + name);
                return;
            }
            if (rctx.items.size() != hctx.items.size()) {
                errCnt.incrementAndGet();
                this.log.severe(this.compareError("items", (String)name, rctx.items.size(), hctx.items.size(), null));
            }
            rctx.stats.forEach((cls, stat) -> {
                long scanCnt = hctx.stats.getOrDefault((Object)cls, (ScanContext.PagesStatistic)new ScanContext.PagesStatistic()).cnt;
                if (scanCnt != stat.cnt) {
                    errCnt.incrementAndGet();
                    this.log.severe(this.compareError("pages", (String)name, stat.cnt, scanCnt, (Class<? extends PageIO>)cls));
                }
            });
            hctx.stats.forEach((cls, stat) -> {
                if (!rctx.stats.containsKey(cls)) {
                    errCnt.incrementAndGet();
                    this.log.severe(this.compareError("pages", (String)name, 0L, stat.cnt, (Class<? extends PageIO>)cls));
                }
            });
        });
        horizontalScans.forEach((name, hctx) -> {
            if (!recursiveScans.containsKey(name)) {
                errCnt.incrementAndGet();
                this.log.severe("Tree was detected in <HORIZONTAL>  but absent in  <RECURSIVE> : " + name);
            }
        });
        this.log.info("Comparing traversals detected " + errCnt + " errors.");
        this.log.info("------------------");
    }

    private void printSequentialScanInfo(ScanContext ctx) {
        this.printIoStat("", "---- These pages types were encountered during sequential scan:", ctx.stats);
        this.log.info("----");
        SystemViewCommand.printTable(null, Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER), Arrays.asList(Arrays.asList("Total pages encountered during sequential scan:", ctx.stats.values().stream().mapToLong(a -> a.cnt).sum()), Arrays.asList("Total errors occurred during sequential scan: ", ctx.errCnt)), this.log);
        if (this.idxFilter != null) {
            this.log.info("Orphan pages were not reported due to --indexes filter.");
        }
        this.log.info("Note that some pages can be occupied by meta info, tracking info, etc., so total page count can differ from count of pages found in index trees and page lists.");
    }

    private void printScanResults(String prefix, Map<String, ScanContext> ctxs) {
        this.log.info(prefix + "Tree traversal results");
        HashMap<Class<? extends PageIO>, ScanContext.PagesStatistic> stats = new HashMap<Class<? extends PageIO>, ScanContext.PagesStatistic>();
        int totalErr = 0;
        HashMap<IgnitePair, Map> cacheIdxSizes = new HashMap<IgnitePair, Map>();
        for (Map.Entry<String, ScanContext> e : ctxs.entrySet()) {
            boolean hasInlineStat;
            String idxName = e.getKey();
            ScanContext ctx = e.getValue();
            this.log.info(prefix + "-----");
            this.log.info(prefix + "Index tree: " + idxName);
            this.printIoStat(prefix, "---- Page stat:", ctx.stats);
            ctx.stats.forEach((cls, stat) -> ScanContext.addToStats(cls, stats, stat));
            this.log.info(prefix + "---- Count of items found in leaf pages: " + ctx.items.size());
            boolean bl = hasInlineStat = ctx.inline != null && IntStream.of(ctx.inline).anyMatch(i -> i > 0);
            if (hasInlineStat) {
                this.log.info(prefix + "---- Inline usage statistics [inlineSize=" + ctx.inline.length + " bytes]");
                ArrayList data = new ArrayList(ctx.inline.length);
                for (int i2 = 0; i2 < ctx.inline.length; ++i2) {
                    if (ctx.inline[i2] == 0) continue;
                    data.add(Arrays.asList(prefix, i2 + 1, ctx.inline[i2]));
                }
                SystemViewCommand.printTable(Arrays.asList(prefix, "Used bytes", "Entries count"), Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER, VisorSystemViewTask.SimpleType.NUMBER), data, this.log);
            }
            if (ctx.errCnt == 0L) {
                this.log.info(prefix + "No errors occurred while traversing.");
            }
            totalErr = (int)((long)totalErr + ctx.errCnt);
            GridTuple3<Integer, Integer, String> parsed = this.cacheAndTypeId(idxName);
            cacheIdxSizes.computeIfAbsent(new IgnitePair(parsed.get1(), parsed.get2()), k -> new HashMap()).put(idxName, ctx.items.size());
        }
        this.log.info(prefix + "----");
        this.printIoStat(prefix, "Total page stat collected during trees traversal:", stats);
        this.log.info("");
        boolean sizeConsistencyErrorsFound = false;
        for (Map.Entry entry : cacheIdxSizes.entrySet()) {
            IgnitePair cacheTypeId = (IgnitePair)entry.getKey();
            Map idxSizes = (Map)entry.getValue();
            if (idxSizes.values().stream().distinct().count() <= 1L) continue;
            sizeConsistencyErrorsFound = true;
            ++totalErr;
            this.log.severe("Index size inconsistency: cacheId=" + cacheTypeId.get1() + ", typeId=" + cacheTypeId.get2());
            idxSizes.forEach((name, size) -> this.log.severe("     Index name: " + name + ", size=" + size));
        }
        if (!sizeConsistencyErrorsFound) {
            this.log.info(prefix + "No index size consistency errors found.");
        }
        this.log.info("");
        SystemViewCommand.printTable(null, Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER), Arrays.asList(Arrays.asList(prefix + "Total trees: ", ctxs.keySet().size()), Arrays.asList(prefix + "Total pages found in trees: ", stats.values().stream().mapToLong(a -> a.cnt).sum()), Arrays.asList(prefix + "Total errors during trees traversal: ", totalErr)), this.log);
        this.log.info("");
        this.log.info("------------------");
    }

    private void printPagesListsInfo(long reuseListRoot) throws IgniteCheckedException {
        if (reuseListRoot == 0L) {
            this.log.severe("No page lists meta info found.");
            return;
        }
        PageListsInfo pageListsInfo = this.pageListsInfo(reuseListRoot);
        this.log.info("<PAGE_LIST> Page lists info.");
        if (!pageListsInfo.bucketsData.isEmpty()) {
            this.log.info("<PAGE_LIST> ---- Printing buckets data:");
        }
        pageListsInfo.bucketsData.forEach((bucket, bucketData) -> {
            GridStringBuilder sb = new GridStringBuilder(PAGE_LISTS_PREFIX).a("List meta id=").a(bucket.get1()).a(", bucket number=").a(bucket.get2()).a(", lists=[").a(bucketData.stream().map(IgniteIndexReader::normalizePageId).map(String::valueOf).collect(Collectors.joining(", "))).a("]");
            this.log.info(sb.toString());
        });
        this.printIoStat(PAGE_LISTS_PREFIX, "---- Page stat:", pageListsInfo.stats);
        this.log.info("");
        SystemViewCommand.printTable(null, Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER), Arrays.asList(Arrays.asList("<PAGE_LIST> Total index pages found in lists:", pageListsInfo.pagesCnt), Arrays.asList("<PAGE_LIST> Total errors during lists scan:", pageListsInfo.errCnt)), this.log);
        this.log.info("------------------");
    }

    private String compareError(String itemName, String idxName, long fromRoot, long scan, Class<? extends PageIO> io) {
        return String.format("Different count of %s; index: %s, %s:%s, %s:%s" + (io == null ? "" : ", pageType: " + io.getSimpleName()), itemName, idxName, RECURSIVE_TRAVERSE_NAME, fromRoot, HORIZONTAL_SCAN_NAME, scan);
    }

    private void printIoStat(String prefix, String caption, Map<Class<? extends PageIO>, ScanContext.PagesStatistic> stats) {
        if (caption != null) {
            this.log.info(prefix + caption + (stats.isEmpty() ? " empty" : ""));
        }
        if (stats.isEmpty()) {
            return;
        }
        ArrayList data = new ArrayList(stats.size());
        stats.forEach((cls, stat) -> data.add(Arrays.asList(prefix + cls.getSimpleName(), stat.cnt, String.format("%.2f", (double)stat.freeSpace / 1024.0), String.format("%.2f", (double)stat.freeSpace * 100.0 / (double)((long)this.pageSize * stat.cnt)))));
        Collections.sort(data, Comparator.comparingLong(l -> (Long)l.get(1)));
        SystemViewCommand.printTable(Arrays.asList(prefix + "Type", "Pages", "Free space (Kb)", "Free space (%)"), Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER, VisorSystemViewTask.SimpleType.NUMBER, VisorSystemViewTask.SimpleType.NUMBER), data, this.log);
    }

    @Nullable
    private FilePageStore filePageStore(int partId, byte type, FileVersionCheckingFactory storeFactory) throws IgniteCheckedException {
        File file = new File(this.root, partId == 65535 ? "index.bin" : String.format("part-%d.bin", partId));
        if (!file.exists()) {
            return null;
        }
        FilePageStore filePageStore = (FilePageStore)storeFactory.createPageStore(type, file, l -> {});
        filePageStore.ensure();
        return filePageStore;
    }

    @Override
    public void close() throws StorageException {
        this.idxStore.stop(false);
        for (FilePageStore store : this.partStores) {
            if (!Objects.nonNull(store)) continue;
            store.stop(false);
        }
    }

    static {
        IndexProcessor.registerIO();
    }

    private class LeafPageVisitor
    extends TreePageVisitor {
        private LeafPageVisitor() {
        }

        public void visit(long addr, ScanContext ctx) throws IgniteCheckedException {
            LinkedList<Object> items = new LinkedList<Object>();
            BPlusLeafIO io = (BPlusLeafIO)PageIO.getPageIO((long)addr);
            if (io instanceof AbstractInlineLeafIO) {
                this.visitInline(addr, (AbstractInlineLeafIO)io, ctx);
            }
            IgniteIndexReader.this.doWithoutErrors((RunnableX & Serializable)() -> {
                for (int i = 0; i < io.getCount(addr); ++i) {
                    if (io instanceof IndexStorageImpl.MetaStoreLeafIO) {
                        items.add(io.getLookupRow(null, addr, i));
                        continue;
                    }
                    items.add(this.leafItem(io, addr, i, ctx));
                }
            }, ctx, PageIO.getPageId((long)addr));
            ctx.onLeafPage(PageIO.getPageId((long)addr), items);
        }

        private void visitInline(long addr, AbstractInlineLeafIO io, ScanContext ctx) {
            int inlineSz = io.inlineSize();
            if (ctx.inlineFldCnt == 0) {
                return;
            }
            if (ctx.inline == null) {
                ctx.inline = new int[inlineSz];
            }
            IndexKeyTypeSettings settings = new IndexKeyTypeSettings();
            for (int i = 0; i < io.getCount(addr); ++i) {
                int itemOff = io.offset(i);
                int realInlineSz = 0;
                int fldCnt = 0;
                while (realInlineSz < inlineSz && fldCnt < ctx.inlineFldCnt) {
                    block11: {
                        IndexKeyType idxKeyType;
                        byte type0 = PageUtils.getByte((long)addr, (int)(itemOff + realInlineSz));
                        try {
                            idxKeyType = IndexKeyType.forCode((int)type0);
                        }
                        catch (AssertionError | Exception t) {
                            IgniteIndexReader.this.log.log(Level.FINEST, "Unknown index key type [type=" + type0 + ']');
                            break;
                        }
                        if (idxKeyType == IndexKeyType.UNKNOWN || idxKeyType == IndexKeyType.NULL) {
                            ++realInlineSz;
                            continue;
                        }
                        InlineIndexKeyType type = InlineIndexKeyTypeRegistry.get((IndexKeyType)idxKeyType, (IndexKeyTypeSettings)settings);
                        if (type == null) {
                            IgniteIndexReader.this.log.log(Level.FINEST, "Unknown inline type [type=" + type0 + ']');
                            break;
                        }
                        if (type.keySize() == -1) {
                            try {
                                byte[] bytes = NullableInlineIndexKeyType.readBytes((long)addr, (int)(itemOff + realInlineSz));
                                realInlineSz += 2;
                                realInlineSz += bytes.length;
                                break block11;
                            }
                            catch (AssertionError | Exception e) {
                                IgniteIndexReader.this.log.warning("Error while reading inline [msg=" + ((Throwable)e).getMessage() + ']');
                                break;
                            }
                        }
                        realInlineSz += type.keySize();
                    }
                    ++realInlineSz;
                    ++fldCnt;
                }
                int n = realInlineSz - 1;
                ctx.inline[n] = ctx.inline[n] + 1;
            }
        }

        private Object leafItem(BPlusLeafIO<?> io, long addr, int idx, ScanContext ctx) {
            int cacheId;
            if (!(io instanceof InlineIO || io instanceof PendingRowIO || io instanceof RowLinkIO)) {
                throw new IgniteException("Unexpected page io: " + io.getClass().getSimpleName());
            }
            long link = this.link(io, addr, idx);
            int n = cacheId = io instanceof AbstractDataLeafIO && ((AbstractDataLeafIO)io).storeCacheId() ? ((RowLinkIO)io).getCacheId(addr, idx) : ctx.cacheId;
            if (IgniteIndexReader.this.partCnt == 0) {
                return new CacheAwareLink(cacheId, link);
            }
            long linkedPageId = PageIdUtils.pageId((long)link);
            int linkedPagePartId = PageIdUtils.partId((long)linkedPageId);
            if (IgniteIndexReader.this.missingPartitions.contains(linkedPagePartId)) {
                return new CacheAwareLink(cacheId, link);
            }
            IgniteIndexReader.this.doWithoutErrors((RunnableX & Serializable)() -> {
                if (linkedPagePartId > IgniteIndexReader.this.partStores.length - 1) {
                    IgniteIndexReader.this.missingPartitions.add(linkedPagePartId);
                    throw new IgniteException("Calculated data page partition id exceeds given partitions count: " + linkedPagePartId + ", partCnt=" + IgniteIndexReader.this.partCnt);
                }
                if (IgniteIndexReader.this.partStores[linkedPagePartId] == null) {
                    IgniteIndexReader.this.missingPartitions.add(linkedPagePartId);
                    throw new IgniteException("Corresponding store wasn't found for partId=" + linkedPagePartId + ". Does partition file exist?");
                }
                IgniteIndexReader.this.doWithBuffer((dataBuf, dataBufAddr) -> {
                    DataPagePayload payload;
                    PageIO dataIo = IgniteIndexReader.this.readPage(IgniteIndexReader.this.partStores[linkedPagePartId], linkedPageId, dataBuf);
                    if (dataIo instanceof AbstractDataPageIO && ((payload = ((AbstractDataPageIO)dataIo).readPayload(dataBufAddr.longValue(), PageIdUtils.itemId((long)link), IgniteIndexReader.this.pageSize)).offset() <= 0 || payload.payloadSize() <= 0)) {
                        throw new IgniteException(new GridStringBuilder("Invalid data page payload: ").a("off=").a(payload.offset()).a(", size=").a(payload.payloadSize()).a(", nextLink=").a(payload.nextLink()).toString());
                    }
                    return null;
                });
            }, ctx, PageIO.getPageId((long)addr));
            return new CacheAwareLink(cacheId, link);
        }

        private long link(BPlusLeafIO<?> io, long addr, int idx) {
            if (io instanceof RowLinkIO) {
                return ((RowLinkIO)io).getLink(addr, idx);
            }
            if (io instanceof InlineIO) {
                return ((InlineIO)io).link(addr, idx);
            }
            if (io instanceof PendingRowIO) {
                return ((PendingRowIO)io).getLink(addr, idx);
            }
            throw new IgniteException("No link to data page on idx=" + idx);
        }
    }

    private class InnerPageVisitor
    extends TreePageVisitor {
        private InnerPageVisitor() {
        }

        public void visit(long addr, ScanContext ctx) throws IgniteCheckedException {
            BPlusInnerIO io = (BPlusInnerIO)PageIO.getPageIO((long)addr);
            for (long id : this.children(io, addr)) {
                this.readAndVisit(id, ctx);
            }
        }

        private long[] children(BPlusInnerIO<?> io, long addr) {
            int cnt = io.getCount(addr);
            if (cnt == 0) {
                long[] lArray;
                long left = io.getLeft(addr, 0);
                if (left == 0L) {
                    lArray = U.EMPTY_LONGS;
                } else {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = left;
                }
                return lArray;
            }
            long[] children = new long[cnt + 1];
            for (int i = 0; i < cnt; ++i) {
                children[i] = io.getLeft(addr, i);
            }
            children[cnt] = io.getRight(addr, cnt - 1);
            return children;
        }
    }

    private class LevelsPageVisitor
    extends TreePageVisitor {
        private LevelsPageVisitor() {
        }

        @Override
        protected void readAndVisit(long rootPageId, ScanContext ctx) {
            IgniteIndexReader.this.doWithoutErrors((RunnableX & Serializable)() -> IgniteIndexReader.this.doWithBuffer((buf, addr) -> {
                Object pageIO = IgniteIndexReader.this.readPage(ctx, rootPageId, (ByteBuffer)buf);
                if (!(pageIO instanceof BPlusMetaIO)) {
                    throw new IgniteException("Root page is not meta, pageId=" + rootPageId);
                }
                BPlusMetaIO metaIO = (BPlusMetaIO)pageIO;
                int lvlsCnt = metaIO.getLevelsCount(addr.longValue());
                long[] firstPageIds = IntStream.range(0, lvlsCnt).mapToLong(i -> metaIO.getFirstPageId(addr.longValue(), i)).toArray();
                for (int i2 = 0; i2 < lvlsCnt; ++i2) {
                    long pageId = firstPageIds[i2];
                    try {
                        while (pageId > 0L) {
                            pageIO = IgniteIndexReader.this.readPage(ctx, pageId, (ByteBuffer)buf);
                            if (i2 == 0 && !(pageIO instanceof BPlusLeafIO)) {
                                throw new IgniteException("Not-leaf page found on leaf level [pageId=" + pageId + ", level=0]");
                            }
                            if (!(pageIO instanceof BPlusIO)) {
                                throw new IgniteException("Not-BPlus page found [pageId=" + pageId + ", level=" + i2 + ']');
                            }
                            if (pageIO instanceof BPlusLeafIO) {
                                IgniteIndexReader.this.leafPageVisitor.visit((long)addr, ctx);
                            }
                            pageId = ((BPlusIO)pageIO).getForward(addr.longValue());
                        }
                        continue;
                    }
                    catch (AssertionError | Exception e) {
                        ctx.onError(pageId, ((Throwable)e).getMessage());
                    }
                }
                return null;
            }), ctx, rootPageId);
        }
    }

    private class MetaPageVisitor
    extends TreePageVisitor {
        private MetaPageVisitor() {
        }

        @Override
        protected void readAndVisit(long pageId, ScanContext ctx) {
            IgniteIndexReader.this.doWithoutErrors((RunnableX & Serializable)() -> {
                long firstPageId = (Long)IgniteIndexReader.this.doWithBuffer((buf, addr) -> {
                    BPlusMetaIO io = (BPlusMetaIO)IgniteIndexReader.this.readPage(ctx, pageId, (ByteBuffer)buf);
                    return io.getFirstPageId(addr.longValue(), io.getRootLevel(addr.longValue()));
                });
                super.readAndVisit(firstPageId, ctx);
            }, ctx, pageId);
        }
    }

    private abstract class TreePageVisitor {
        private TreePageVisitor() {
        }

        protected void readAndVisit(long pageId, ScanContext ctx) {
            IgniteIndexReader.this.doWithoutErrors((RunnableX & Serializable)() -> IgniteIndexReader.this.doWithBuffer((buf, addr) -> {
                Object io = IgniteIndexReader.this.readPage(ctx, pageId, (ByteBuffer)buf);
                if (io instanceof BPlusLeafIO) {
                    IgniteIndexReader.this.leafPageVisitor.visit((long)addr, ctx);
                } else if (io instanceof BPlusInnerIO) {
                    IgniteIndexReader.this.innerPageVisitor.visit((long)addr, ctx);
                } else {
                    throw new IllegalArgumentException("Unknown io [io=" + io.getClass().getSimpleName() + ']');
                }
                return null;
            }), ctx, pageId);
        }
    }

    private static interface Scanner {
        public ScanContext scan(long var1, String var3, ItemStorage var4, ProgressPrinter var5);
    }
}

