/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionRateTask;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionRateTaskArg;

public class ReencryptionRateCommand
extends AbstractCommand<VisorReencryptionRateTaskArg> {
    private VisorReencryptionRateTaskArg taskArg;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Iterator iterator;
            VisorCacheGroupEncryptionTaskResult res = (VisorCacheGroupEncryptionTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorReencryptionRateTask.class.getName(), this.taskArg, TaskExecutor.BROADCAST_UUID, clientCfg);
            Map exceptions = res.exceptions();
            for (Map.Entry entry : exceptions.entrySet()) {
                log.info("  Node " + entry.getKey() + ":");
                log.info("    failed to get/set re-encryption rate limit: " + ((IgniteException)entry.getValue()).getMessage());
            }
            Map results = res.results();
            boolean read = this.taskArg.rate() == null;
            for (Map.Entry entry : results.entrySet()) {
                double rateLimit;
                log.info("  Node " + entry.getKey() + ":");
                double d = rateLimit = read ? ((Double)entry.getValue()).doubleValue() : this.taskArg.rate().doubleValue();
                if (rateLimit == 0.0) {
                    log.info("    re-encryption rate is not limited.");
                    continue;
                }
                log.info(String.format("%sre-encryption rate %s limited to %.2f MB/s.", "    ", read ? "is" : "has been", rateLimit));
            }
            if (read) {
                iterator = null;
                return iterator;
            }
            log.info("");
            log.info("Note: the changed value of the re-encryption rate limit is not persisted. When the node is restarted, the value will be set from the configuration.");
            log.info("");
            iterator = null;
            return iterator;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public VisorReencryptionRateTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Double rateLimit = null;
        while (argIter.hasNextSubArg()) {
            String rateLimitArg = argIter.nextArg("Expected decimal value for re-encryption rate.");
            try {
                rateLimit = Double.parseDouble(rateLimitArg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse command argument. Decimal value expected.", e);
            }
        }
        this.taskArg = new VisorReencryptionRateTaskArg(rateLimit);
    }

    @Override
    public void printUsage(Logger log) {
        this.usage(log, "View/change re-encryption rate limit:", CommandList.ENCRYPTION, Collections.singletonMap("new_limit", "Decimal value to change re-encryption rate limit (MB/s)."), EncryptionSubcommands.REENCRYPTION_RATE.toString(), CommandLogger.optional("new_limit"));
    }

    @Override
    public String name() {
        return EncryptionSubcommands.REENCRYPTION_RATE.text().toUpperCase();
    }
}

