/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.tracing.configuration;

import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationSubcommand;
import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationItem;
import org.apache.ignite.spi.tracing.Scope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TracingConfigurationArguments
extends VisorTracingConfigurationItem {
    private static final long serialVersionUID = 0L;
    private TracingConfigurationSubcommand cmd;

    public TracingConfigurationArguments() {
    }

    private TracingConfigurationArguments(TracingConfigurationSubcommand cmd, Scope scope, String lb, double samplingRate, Set<Scope> includedScopes) {
        super(scope, lb, Double.valueOf(samplingRate), includedScopes);
        this.cmd = cmd;
    }

    public TracingConfigurationSubcommand command() {
        return this.cmd;
    }

    public static class Builder {
        private TracingConfigurationSubcommand cmd;
        private Scope scope;
        private String lb;
        private double samplingRate;
        private Set<Scope> includedScopes;

        public Builder(TracingConfigurationSubcommand cmd) {
            this.cmd = cmd;
        }

        @NotNull
        public Builder withScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        @NotNull
        public Builder withSamplingRate(double samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        @NotNull
        public Builder withLabel(@Nullable String lb) {
            this.lb = lb;
            return this;
        }

        @NotNull
        public Builder withIncludedScopes(Set<Scope> includedScopes) {
            this.includedScopes = includedScopes == null ? Collections.emptySet() : includedScopes;
            return this;
        }

        public TracingConfigurationArguments build() {
            return new TracingConfigurationArguments(this.cmd, this.scope, this.lb, this.samplingRate, this.includedScopes);
        }
    }
}

