/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.ValidateIndexesCommandArg;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;

public class CacheValidateIndexes
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String CACHES = "cacheName1,...,cacheNameN";
        String description = "Validates indexes for the specified caches/cache groups on an idle cluster on all or specified cluster nodes. " + (Object)((Object)CacheSubcommands.VALIDATE_INDEXES) + " checks consistence between primary/secondary indexes against each other and data entries.";
        LinkedHashMap map = U.newLinkedHashMap((int)16);
        map.put(ValidateIndexesCommandArg.CHECK_FIRST + " N", "validate only the first N keys");
        map.put(ValidateIndexesCommandArg.CHECK_THROUGH + " K", "validate every Kth key");
        map.put(ValidateIndexesCommandArg.CHECK_CRC.toString(), "check the CRC-sum of pages stored on disk");
        map.put(ValidateIndexesCommandArg.CHECK_SIZES.toString(), "check that index size and cache size are the same");
        CacheCommands.usageCache(logger, CacheSubcommands.VALIDATE_INDEXES, description, map, CommandLogger.optional(CACHES), CacheCommands.OP_NODE_ID, CommandLogger.optional(CommandLogger.or(ValidateIndexesCommandArg.CHECK_FIRST + " N", ValidateIndexesCommandArg.CHECK_THROUGH + " K", ValidateIndexesCommandArg.CHECK_CRC, ValidateIndexesCommandArg.CHECK_SIZES)));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        VisorValidateIndexesTaskArg taskArg = new VisorValidateIndexesTaskArg(this.args.caches(), this.args.nodeId() != null ? Collections.singleton(this.args.nodeId()) : null, this.args.checkFirst(), this.args.checkThrough(), this.args.checkCrc(), this.args.checkSizes());
        try (GridClient client = Command.startClient(clientCfg);){
            VisorValidateIndexesTaskResult taskRes = (VisorValidateIndexesTaskResult)TaskExecutor.executeTaskByNameOnNode(client, "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask", taskArg, null, clientCfg);
            boolean errors = CommandLogger.printErrors(taskRes.exceptions(), "Index validation failed on nodes:", logger);
            for (Map.Entry nodeEntry : taskRes.results().entrySet()) {
                ValidateIndexesPartitionResult res;
                VisorValidateIndexesJobResult jobRes = (VisorValidateIndexesJobResult)nodeEntry.getValue();
                if (!jobRes.hasIssues()) continue;
                errors = true;
                logger.info("Index issues found on node " + nodeEntry.getKey() + ":");
                for (IndexIntegrityCheckIssue indexIntegrityCheckIssue : jobRes.integrityCheckFailures()) {
                    logger.info("  " + indexIntegrityCheckIssue);
                }
                for (Map.Entry entry : jobRes.partitionResult().entrySet()) {
                    res = (ValidateIndexesPartitionResult)entry.getValue();
                    if (res.issues().isEmpty()) continue;
                    logger.info("  " + CommandLogger.join(" ", entry.getKey(), entry.getValue()));
                    for (IndexValidationIssue is : res.issues()) {
                        logger.info("    " + is);
                    }
                }
                for (Map.Entry entry : jobRes.indexResult().entrySet()) {
                    res = (ValidateIndexesPartitionResult)entry.getValue();
                    if (res.issues().isEmpty()) continue;
                    logger.info("  " + CommandLogger.join(" ", "SQL Index", entry.getKey(), entry.getValue()));
                    for (IndexValidationIssue is : res.issues()) {
                        logger.info("    " + is);
                    }
                }
                for (Map.Entry entry : jobRes.checkSizeResult().entrySet()) {
                    res = (ValidateIndexesCheckSizeResult)entry.getValue();
                    Collection issues = res.issues();
                    if (issues.isEmpty()) continue;
                    logger.info("  " + CommandLogger.join(" ", "Size check", entry.getKey(), res));
                    for (ValidateIndexesCheckSizeIssue issue : issues) {
                        logger.info("    " + issue);
                    }
                }
            }
            if (!errors) {
                logger.info("no issues found.");
            } else {
                logger.severe("issues found (listed above).");
            }
            logger.info("");
            VisorValidateIndexesTaskResult visorValidateIndexesTaskResult = taskRes;
            return visorValidateIndexesTaskResult;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        int checkFirst = -1;
        int checkThrough = -1;
        UUID nodeId = null;
        Set<String> caches = null;
        boolean checkCrc = false;
        boolean checkSizes = false;
        while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("");
            ValidateIndexesCommandArg arg = CommandArgUtils.of(nextArg, ValidateIndexesCommandArg.class);
            if (arg == ValidateIndexesCommandArg.CHECK_FIRST || arg == ValidateIndexesCommandArg.CHECK_THROUGH) {
                int numVal;
                if (!argIter.hasNextSubArg()) {
                    throw new IllegalArgumentException("Numeric value for '" + nextArg + "' parameter expected.");
                }
                String numStr = argIter.nextArg("");
                try {
                    numVal = Integer.parseInt(numStr);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Not numeric value was passed for '" + nextArg + "' parameter: " + numStr);
                }
                if (numVal <= 0) {
                    throw new IllegalArgumentException("Value for '" + nextArg + "' property should be positive.");
                }
                if (arg == ValidateIndexesCommandArg.CHECK_FIRST) {
                    checkFirst = numVal;
                    continue;
                }
                checkThrough = numVal;
                continue;
            }
            if (arg == ValidateIndexesCommandArg.CHECK_CRC) {
                checkCrc = true;
                continue;
            }
            if (ValidateIndexesCommandArg.CHECK_SIZES == arg) {
                checkSizes = true;
                continue;
            }
            try {
                nodeId = UUID.fromString(nextArg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                caches = argIter.parseStringSet(nextArg);
            }
        }
        this.args = new Arguments(caches, nodeId, checkFirst, checkThrough, checkCrc, checkSizes);
    }

    @Override
    public String name() {
        return CacheSubcommands.VALIDATE_INDEXES.text().toUpperCase();
    }

    public class Arguments {
        private final Set<String> caches;
        private final UUID nodeId;
        private final int checkFirst;
        private final int checkThrough;
        private final boolean checkCrc;
        private final boolean checkSizes;

        public Arguments(Set<String> caches, UUID nodeId, int checkFirst, int checkThrough, boolean checkCrc, boolean checkSizes) {
            this.caches = caches;
            this.nodeId = nodeId;
            this.checkFirst = checkFirst;
            this.checkThrough = checkThrough;
            this.checkCrc = checkCrc;
            this.checkSizes = checkSizes;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public int checkFirst() {
            return this.checkFirst;
        }

        public int checkThrough() {
            return this.checkThrough;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public boolean checkCrc() {
            return this.checkCrc;
        }

        public boolean checkSizes() {
            return this.checkSizes;
        }
    }
}

