/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.baseline.AutoAdjustCommandArg;
import org.apache.ignite.internal.commandline.baseline.BaselineArguments;
import org.apache.ignite.internal.commandline.baseline.BaselineSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.baseline.VisorBaselineAutoAdjustSettings;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTask;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskArg;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskResult;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class BaselineCommand
extends AbstractCommand<BaselineArguments> {
    private BaselineArguments baselineArgs;

    @Override
    public void printUsage(Logger logger) {
        String constistIds = "consistentId1[,consistentId2,....,consistentIdN]";
        Command.usage(logger, "Print cluster baseline topology:", CommandList.BASELINE, Collections.singletonMap("verbose", "Show the full list of node ips."), CommandLogger.optional("--verbose"));
        Command.usage(logger, "Add nodes into baseline topology:", CommandList.BASELINE, BaselineSubcommands.ADD.text(), "consistentId1[,consistentId2,....,consistentIdN]", CommandLogger.optional("--yes"));
        Command.usage(logger, "Remove nodes from baseline topology:", CommandList.BASELINE, BaselineSubcommands.REMOVE.text(), "consistentId1[,consistentId2,....,consistentIdN]", CommandLogger.optional("--yes"));
        Command.usage(logger, "Set baseline topology:", CommandList.BASELINE, BaselineSubcommands.SET.text(), "consistentId1[,consistentId2,....,consistentIdN]", CommandLogger.optional("--yes"));
        Command.usage(logger, "Set baseline topology based on version:", CommandList.BASELINE, BaselineSubcommands.VERSION.text() + " topologyVersion", CommandLogger.optional("--yes"));
        Command.usage(logger, "Set baseline autoadjustment settings:", CommandList.BASELINE, BaselineSubcommands.AUTO_ADJUST.text(), "[disable|enable] [timeout <timeoutMillis>]", CommandLogger.optional("--yes"));
    }

    @Override
    public String confirmationPrompt() {
        if (this.baselineArgs != null && BaselineSubcommands.COLLECT != this.baselineArgs.getCmd()) {
            return "Warning: the command will perform changes in baseline.";
        }
        return null;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            UUID coordinatorId = client.compute().nodes(node -> !node.isClient()).stream().min(Comparator.comparingLong(GridClientNode::order)).map(GridClientNode::nodeId).orElse(null);
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorBaselineTask.class.getName(), this.toVisorArguments(this.baselineArgs), coordinatorId, clientCfg);
            this.baselinePrint0(res, logger);
        }
        catch (Throwable e) {
            logger.severe("Failed to execute baseline command='" + this.baselineArgs.getCmd().text() + "'");
            logger.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public BaselineArguments arg() {
        return this.baselineArgs;
    }

    private VisorBaselineTaskArg toVisorArguments(BaselineArguments args) {
        VisorBaselineAutoAdjustSettings settings = args.getCmd() == BaselineSubcommands.AUTO_ADJUST ? new VisorBaselineAutoAdjustSettings(args.getEnableAutoAdjust(), args.getSoftBaselineTimeout()) : null;
        return new VisorBaselineTaskArg(args.getCmd().visorBaselineOperation(), args.getTopVer(), args.getConsistentIds(), settings);
    }

    private void baselinePrint0(VisorBaselineTaskResult res, Logger logger) {
        logger.info("Cluster state: " + (res.isActive() ? "active" : "inactive"));
        logger.info("Current topology version: " + res.getTopologyVersion());
        VisorBaselineAutoAdjustSettings autoAdjustSettings = res.getAutoAdjustSettings();
        if (autoAdjustSettings != null) {
            logger.info("Baseline auto adjustment " + (Boolean.TRUE.equals(autoAdjustSettings.getEnabled()) ? "enabled" : "disabled") + ": softTimeout=" + autoAdjustSettings.getSoftTimeout());
        }
        if (autoAdjustSettings.enabled.booleanValue()) {
            if (res.isBaselineAdjustInProgress()) {
                logger.info("Baseline auto-adjust is in progress");
            } else if (res.getRemainingTimeToBaselineAdjust() < 0L) {
                logger.info("Baseline auto-adjust are not scheduled");
            } else {
                logger.info("Baseline auto-adjust will happen in '" + res.getRemainingTimeToBaselineAdjust() + "' ms");
            }
        }
        logger.info("");
        Map baseline = res.getBaseline();
        Map srvs = res.getServers();
        Function<VisorBaselineNode, String> extractFormattedAddrs = node -> {
            Stream<String> sortedByIpHosts = ((Collection)Optional.ofNullable(node).map(addrs -> node.getAddrs()).orElse(Collections.emptyList())).stream().sorted(Comparator.comparing(resolvedAddr -> new VisorTaskUtils.SortableAddress(resolvedAddr.address()))).map(resolvedAddr -> {
                if (!resolvedAddr.hostname().equals(resolvedAddr.address())) {
                    return resolvedAddr.hostname() + "/" + resolvedAddr.address();
                }
                return resolvedAddr.address();
            });
            if (this.verbose) {
                String hosts = String.join((CharSequence)",", sortedByIpHosts.collect(Collectors.toList()));
                if (!hosts.isEmpty()) {
                    return ", Addresses=" + hosts;
                }
                return "";
            }
            return sortedByIpHosts.findFirst().map(ip -> ", Address=" + ip).orElse("");
        };
        String crdStr = srvs.values().stream().filter(node -> node.getOrder() != null).min(Comparator.comparing(VisorBaselineNode::getOrder)).map(crd -> " (Coordinator: ConsistentId=" + crd.getConsistentId() + (String)extractFormattedAddrs.apply((VisorBaselineNode)crd) + ", Order=" + crd.getOrder() + ")").orElse("");
        logger.info("Current topology version: " + res.getTopologyVersion() + crdStr);
        logger.info("");
        if (F.isEmpty((Map)baseline)) {
            logger.info("Baseline nodes not found.");
        } else {
            logger.info("Baseline nodes:");
            for (VisorBaselineNode node2 : baseline.values()) {
                VisorBaselineNode srvNode = (VisorBaselineNode)srvs.get(node2.getConsistentId());
                String state = ", State=" + (srvNode != null ? "ONLINE" : "OFFLINE");
                String order = srvNode != null ? ", Order=" + srvNode.getOrder() : "";
                logger.info("    ConsistentId=" + node2.getConsistentId() + extractFormattedAddrs.apply(srvNode) + state + order);
            }
            logger.info("--------------------------------------------------------------------------------");
            logger.info("Number of baseline nodes: " + baseline.size());
            logger.info("");
            ArrayList<VisorBaselineNode> others = new ArrayList<VisorBaselineNode>();
            for (VisorBaselineNode node3 : srvs.values()) {
                if (baseline.containsKey(node3.getConsistentId())) continue;
                others.add(node3);
            }
            if (F.isEmpty(others)) {
                logger.info("Other nodes not found.");
            } else {
                logger.info("Other nodes:");
                for (VisorBaselineNode node3 : others) {
                    logger.info("    ConsistentId=" + node3.getConsistentId() + ", Order=" + node3.getOrder());
                }
                logger.info("Number of other nodes: " + others.size());
            }
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.baselineArgs = new BaselineArguments.Builder(BaselineSubcommands.COLLECT).build();
            return;
        }
        BaselineSubcommands cmd = BaselineSubcommands.of(argIter.nextArg("Expected baseline action"));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct baseline action");
        }
        BaselineArguments.Builder baselineArgs = new BaselineArguments.Builder(cmd);
        switch (cmd) {
            case ADD: 
            case REMOVE: 
            case SET: {
                Set<String> ids = argIter.nextStringSet("list of consistent ids");
                if (F.isEmpty(ids)) {
                    throw new IllegalArgumentException("Empty list of consistent IDs");
                }
                baselineArgs.withConsistentIds(new ArrayList<String>(ids));
                break;
            }
            case VERSION: {
                baselineArgs.withTopVer(argIter.nextNonNegativeLongArg("topology version"));
                break;
            }
            case AUTO_ADJUST: {
                do {
                    AutoAdjustCommandArg autoAdjustArg;
                    if ((autoAdjustArg = CommandArgUtils.of(argIter.nextArg("Expected one of auto-adjust arguments"), AutoAdjustCommandArg.class)) == null) {
                        throw new IllegalArgumentException("Expected one of auto-adjust arguments");
                    }
                    if (autoAdjustArg == AutoAdjustCommandArg.ENABLE || autoAdjustArg == AutoAdjustCommandArg.DISABLE) {
                        baselineArgs.withEnable(autoAdjustArg == AutoAdjustCommandArg.ENABLE);
                    }
                    if (autoAdjustArg != AutoAdjustCommandArg.TIMEOUT) continue;
                    baselineArgs.withSoftBaselineTimeout(argIter.nextNonNegativeLongArg("soft timeout"));
                } while (argIter.hasNextSubArg());
            }
        }
        this.baselineArgs = baselineArgs.build();
    }

    @Override
    public String name() {
        return CommandList.BASELINE.toCommandName();
    }
}

