/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration;

import io.micronaut.context.ApplicationContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.rest.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.rest.presentation.TestRootConfiguration;
import org.apache.ignite.internal.rest.api.ErrorResult;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@MicronautTest
public abstract class ConfigurationControllerBaseTest {
    @Inject
    private EmbeddedServer server;
    @Inject
    private ConfigurationPresentation<String> cfgPresentation;
    @Inject
    private ConfigurationRegistry configurationRegistry;
    @Inject
    private ApplicationContext context;

    abstract HttpClient client();

    @BeforeEach
    void beforeEach() throws Exception {
        TestRootConfiguration cfg = (TestRootConfiguration)this.configurationRegistry.getConfiguration(TestRootConfiguration.KEY);
        cfg.change(c -> c.changeFoo("foo").changeSubCfg(subCfg -> subCfg.changeBar("bar"))).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testGetConfig() {
        HttpResponse response = this.client().toBlocking().exchange("", String.class);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.status());
        Assertions.assertEquals((Object)this.cfgPresentation.represent(), (Object)response.body());
    }

    @Test
    void testGetConfigByPath() {
        HttpResponse response = this.client().toBlocking().exchange("/root.subCfg", String.class);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.status());
        Assertions.assertEquals((Object)this.cfgPresentation.representByPath("root.subCfg"), (Object)response.body());
    }

    @Test
    void testUpdateConfig() {
        String givenChangedConfig = "{root:{foo:foo,subCfg:{bar:changed}}}";
        HttpResponse response = this.client().toBlocking().exchange((HttpRequest)HttpRequest.PATCH((String)"", (Object)givenChangedConfig).contentType((CharSequence)"text/plain"));
        Assertions.assertEquals((Object)response.status(), (Object)HttpStatus.OK);
        String changedConfigValue = (String)this.client().toBlocking().exchange("/root.subCfg.bar", String.class).body();
        Assertions.assertEquals((Object)"\"changed\"", (Object)changedConfigValue);
    }

    @Test
    void testUnrecognizedConfigPath() {
        HttpClientResponseException thrown = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, () -> this.client().toBlocking().exchange("/no-such-root.some-value"));
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)thrown.getResponse().status());
        ErrorResult errorResult = this.getErrorResult(thrown);
        Assertions.assertEquals((Object)"CONFIG_PATH_UNRECOGNIZED", (Object)errorResult.type());
        Assertions.assertEquals((Object)"Configuration value 'no-such-root' has not been found", (Object)errorResult.message());
    }

    @Test
    void testUnrecognizedConfigPathForUpdate() {
        String givenBrokenConfig = "{root:{foo:foo,subCfg:{no-such-bar:bar}}}";
        HttpClientResponseException thrown = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, () -> this.client().toBlocking().exchange((HttpRequest)HttpRequest.PATCH((String)"", (Object)givenBrokenConfig).contentType((CharSequence)"text/plain")));
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)thrown.getResponse().status());
        ErrorResult errorResult = this.getErrorResult(thrown);
        Assertions.assertEquals((Object)"INVALID_CONFIG_FORMAT", (Object)errorResult.type());
        Assertions.assertEquals((Object)"'root.subCfg' configuration doesn't have the 'no-such-bar' sub-configuration", (Object)errorResult.message());
    }

    @Test
    void testValidationForUpdate() {
        String givenConfigWithError = "{root:{foo:error,subCfg:{bar:bar}}}";
        HttpClientResponseException thrown = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, () -> this.client().toBlocking().exchange((HttpRequest)HttpRequest.PATCH((String)"", (Object)givenConfigWithError).contentType((CharSequence)"text/plain")));
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)thrown.getResponse().status());
        ErrorResult errorResult = this.getErrorResult(thrown);
        Assertions.assertEquals((Object)"VALIDATION_EXCEPTION", (Object)errorResult.type());
        Assertions.assertEquals((Object)"Error word", (Object)errorResult.message());
    }

    @NotNull
    private ErrorResult getErrorResult(HttpClientResponseException exception) {
        return (ErrorResult)exception.getResponse().getBody(ErrorResult.class).orElseThrow();
    }
}

