/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.validation.PolyValidatedChildView;
import org.apache.ignite.internal.configuration.validation.ValidatedChildView;
import org.apache.ignite.internal.configuration.validation.ValidatedRootConfiguration;
import org.apache.ignite.internal.configuration.validation.ValidationUtil;
import org.apache.ignite.internal.tostring.S;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidationUtilTest {
    private static ConfigurationAsmGenerator cgen;
    private InnerNode root;

    @BeforeAll
    public static void beforeAll() {
        cgen = new ConfigurationAsmGenerator();
        cgen.compileRootSchema(ValidatedRootConfigurationSchema.class, Map.of(ValidatedChildConfigurationSchema.class, Set.of(InternalValidatedChildConfigurationSchema.class)), Map.of(PolyValidatedChildConfigurationSchema.class, Set.of(FirstPolyValidatedChildConfigurationSchema.class)));
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    @BeforeEach
    public void before() {
        this.root = cgen.instantiateNode(ValidatedRootConfigurationSchema.class);
        ConfigurationUtil.addDefaults((InnerNode)this.root);
    }

    @Test
    public void validateLeafNode() {
        SuperRoot rootsNode = new SuperRoot(key -> null, Map.of(ValidatedRootConfiguration.KEY, this.root));
        Validator<LeafValidation, String> validator = new Validator<LeafValidation, String>(){

            public void validate(LeafValidation annotation, ValidationContext<String> ctx) {
                ctx.addIssue((ValidationIssue)new ExValidationIssue("bar", ctx.currentKey(), ctx.getOldValue(), ctx.getNewValue()));
            }
        };
        Map<Class<LeafValidation>, Set<1>> validators = Map.of(LeafValidation.class, Set.of(validator));
        List actual = ValidationUtil.validate((SuperRoot)rootsNode, (SuperRoot)rootsNode, null, new HashMap(), validators);
        List<ValidationIssue> expected = List.of(new ExValidationIssue("bar", "root.child.str", "foo", "foo"), new ExValidationIssue("bar", "root.child.strInternal", "fooInternal", "fooInternal"), new ExValidationIssue("bar", "root.poly.type", "first", "first"), new ExValidationIssue("bar", "root.poly.strPoly", "fooPolyFirst", "fooPolyFirst"));
        MatcherAssert.assertThat(ExValidationIssue.sortedByCurrentKey(actual), (Matcher)Matchers.equalTo(ExValidationIssue.sortedByCurrentKey(expected)));
    }

    @Test
    public void validateInnerNode() throws Exception {
        SuperRoot rootsNode = new SuperRoot(key -> null, Map.of(ValidatedRootConfiguration.KEY, this.root));
        Validator<InnerValidation, Object> validator = new Validator<InnerValidation, Object>(){

            public void validate(InnerValidation annotation, ValidationContext<Object> ctx) {
                Object oldValue = ctx.getOldValue();
                Object newValue = ctx.getNewValue();
                if (oldValue instanceof ValidatedChildView) {
                    oldValue = ((ValidatedChildView)oldValue).str();
                    newValue = ((ValidatedChildView)newValue).str();
                } else {
                    oldValue = ((PolyValidatedChildView)oldValue).type();
                    newValue = ((PolyValidatedChildView)newValue).type();
                }
                ctx.addIssue((ValidationIssue)new ExValidationIssue("bar", ctx.currentKey(), oldValue, newValue));
            }
        };
        Map<Class<InnerValidation>, Set<2>> validators = Map.of(InnerValidation.class, Set.of(validator));
        List actual = ValidationUtil.validate((SuperRoot)rootsNode, (SuperRoot)rootsNode, null, new HashMap(), validators);
        List<ValidationIssue> expected = List.of(new ExValidationIssue("bar", "root.child", "foo", "foo"), new ExValidationIssue("bar", "root.poly", "first", "first"));
        MatcherAssert.assertThat(ExValidationIssue.sortedByCurrentKey(actual), (Matcher)Matchers.equalTo(ExValidationIssue.sortedByCurrentKey(expected)));
    }

    @Test
    public void validateNamedListNode() {
        SuperRoot rootsNode = new SuperRoot(key -> null, Map.of(ValidatedRootConfiguration.KEY, this.root));
        Validator validator = new Validator<NamedListValidation, NamedListView<?>>(){

            public void validate(NamedListValidation annotation, ValidationContext<NamedListView<?>> ctx) {
                ctx.addIssue((ValidationIssue)new ExValidationIssue("bar", ctx.currentKey(), ((NamedListView)ctx.getOldValue()).namedListKeys(), ((NamedListView)ctx.getNewValue()).namedListKeys()));
            }
        };
        Map<Class<NamedListValidation>, Set<3>> validators = Map.of(NamedListValidation.class, Set.of(validator));
        List actual = ValidationUtil.validate((SuperRoot)rootsNode, (SuperRoot)rootsNode, null, new HashMap(), validators);
        List<ValidationIssue> expected = List.of(new ExValidationIssue("bar", "root.elements", List.of(), List.of()), new ExValidationIssue("bar", "root.polyChildren", List.of(), List.of()));
        MatcherAssert.assertThat(ExValidationIssue.sortedByCurrentKey(actual), (Matcher)Matchers.equalTo(ExValidationIssue.sortedByCurrentKey(expected)));
    }

    private static class ExValidationIssue
    extends ValidationIssue {
        final String currentKey;
        @Nullable
        final Object oldVal;
        final Object newVal;

        ExValidationIssue(String message, String currentKey, @Nullable Object oldVal, Object newVal) {
            super(message);
            this.currentKey = currentKey;
            this.oldVal = oldVal;
            this.newVal = newVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ExValidationIssue that = (ExValidationIssue)((Object)o);
            return Objects.equals(this.currentKey, that.currentKey) && Objects.equals(this.oldVal, that.oldVal) && Objects.equals(this.newVal, that.newVal);
        }

        public int hashCode() {
            return Objects.hash(this.currentKey, this.oldVal, this.newVal);
        }

        public String toString() {
            return S.toString(ExValidationIssue.class, (Object)((Object)this));
        }

        static int compareByCurrentKey(ValidationIssue o1, ValidationIssue o2) {
            ExValidationIssue ex1 = (ExValidationIssue)o1;
            ExValidationIssue ex2 = (ExValidationIssue)o2;
            return ex1.currentKey.compareTo(ex2.currentKey);
        }

        static List<ExValidationIssue> sortedByCurrentKey(List<ValidationIssue> issues) {
            return issues.stream().sorted(ExValidationIssue::compareByCurrentKey).map(ExValidationIssue.class::cast).collect(Collectors.toList());
        }
    }

    @PolymorphicConfigInstance(value="first")
    public static class FirstPolyValidatedChildConfigurationSchema
    extends PolyValidatedChildConfigurationSchema {
        @LeafValidation
        @Value(hasDefault=true)
        public String strPoly = "fooPolyFirst";
    }

    @PolymorphicConfig
    public static class PolyValidatedChildConfigurationSchema {
        public static final String DEFAULT_POLY_TYPE = "first";
        @PolymorphicId(hasDefault=true)
        @LeafValidation
        public String type = "first";
    }

    @InternalConfiguration
    public static class InternalValidatedChildConfigurationSchema
    extends ValidatedChildConfigurationSchema {
        @LeafValidation
        @Value(hasDefault=true)
        public String strInternal = "fooInternal";
    }

    @Config
    public static class ValidatedChildConfigurationSchema {
        @LeafValidation
        @Value(hasDefault=true)
        public String str = "foo";
    }

    @ConfigurationRoot(rootName="root", type=ConfigurationType.LOCAL)
    public static class ValidatedRootConfigurationSchema {
        @InnerValidation
        @ConfigValue
        public ValidatedChildConfigurationSchema child;
        @NamedListValidation
        @NamedConfigValue
        public ValidatedChildConfigurationSchema elements;
        @InnerValidation
        @ConfigValue
        public PolyValidatedChildConfigurationSchema poly;
        @NamedListValidation
        @NamedConfigValue
        public PolyValidatedChildConfigurationSchema polyChildren;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NamedListValidation {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface InnerValidation {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface LeafValidation {
    }
}

