/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.lang.annotation.Annotation;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.Nullable;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestValidationUtil {
    public static <VIEWT> ValidationContext<VIEWT> mockValidationContext(@Nullable VIEWT oldValue, VIEWT newValue) {
        ValidationContext mock = (ValidationContext)Mockito.mock(ValidationContext.class);
        Mockito.when((Object)mock.getOldValue()).thenReturn(oldValue);
        Mockito.when((Object)mock.getNewValue()).thenReturn(newValue);
        return mock;
    }

    public static <VIEWT> ArgumentCaptor<ValidationIssue> addIssuesCaptor(ValidationContext<VIEWT> mock) {
        ArgumentCaptor issuesCaptor = ArgumentCaptor.forClass(ValidationIssue.class);
        ((ValidationContext)Mockito.doNothing().when(mock)).addIssue((ValidationIssue)issuesCaptor.capture());
        return issuesCaptor;
    }

    public static <A extends Annotation, VIEWT> void validate(Validator<A, VIEWT> validator, A annotation, ValidationContext<VIEWT> ctx, @Nullable String errorMessagePrefix) {
        ArgumentCaptor<ValidationIssue> argumentCaptor = TestValidationUtil.addIssuesCaptor(ctx);
        validator.validate(annotation, ctx);
        if (errorMessagePrefix == null) {
            MatcherAssert.assertThat((Object)argumentCaptor.getAllValues(), (Matcher)Matchers.empty());
        } else {
            MatcherAssert.assertThat((Object)argumentCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((ValidationIssue)argumentCaptor.getValue()).message(), (Matcher)Matchers.startsWith((String)errorMessagePrefix));
        }
    }
}

