/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import org.apache.ignite.configuration.validation.Range;
import org.apache.ignite.internal.configuration.validation.RangeValidator;
import org.apache.ignite.internal.configuration.validation.TestValidationUtil;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RangeValidatorTest {
    @Test
    void testValidationSuccess() {
        Range range0 = this.createRange(0L, 100L);
        RangeValidator validator = new RangeValidator();
        TestValidationUtil.validate(validator, range0, TestValidationUtil.mockValidationContext(null, 0), null);
        TestValidationUtil.validate(validator, range0, TestValidationUtil.mockValidationContext(null, 50), null);
        TestValidationUtil.validate(validator, range0, TestValidationUtil.mockValidationContext(null, 100), null);
        Range range1 = this.createRange(0L, null);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, 0), null);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, 50), null);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, 100), null);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, Long.MAX_VALUE), null);
        Range range2 = this.createRange(null, 100L);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, 0), null);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, 50), null);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, 100), null);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, Long.MIN_VALUE), null);
    }

    @Test
    void testValidationFail() {
        RangeValidator validator = new RangeValidator();
        String lessThanErrorPrefix = "Configuration value 'null' must not be less than";
        String greaterThanErrorPrefix = "Configuration value 'null' must not be greater than";
        Range range0 = this.createRange(0L, 100L);
        TestValidationUtil.validate(validator, range0, TestValidationUtil.mockValidationContext(null, -1), lessThanErrorPrefix);
        TestValidationUtil.validate(validator, range0, TestValidationUtil.mockValidationContext(null, 101), greaterThanErrorPrefix);
        Range range1 = this.createRange(0L, null);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, -1), lessThanErrorPrefix);
        TestValidationUtil.validate(validator, range1, TestValidationUtil.mockValidationContext(null, Long.MIN_VALUE), lessThanErrorPrefix);
        Range range2 = this.createRange(null, 100L);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, 101), greaterThanErrorPrefix);
        TestValidationUtil.validate(validator, range2, TestValidationUtil.mockValidationContext(null, Long.MAX_VALUE), greaterThanErrorPrefix);
    }

    private Range createRange(@Nullable Long min, @Nullable Long max) {
        Range range = (Range)Mockito.mock(Range.class);
        Mockito.when((Object)range.min()).then(answer -> min == null ? answer.getMethod().getDefaultValue() : min);
        Mockito.when((Object)range.max()).then(answer -> max == null ? answer.getMethod().getDefaultValue() : max);
        return range;
    }
}

