/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import org.apache.ignite.configuration.validation.OneOf;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.internal.configuration.validation.OneOfValidator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class OneOfValidatorTest {
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testValidate(boolean caseSensitive) {
        OneOf oneOfAnnotation = (OneOf)Mockito.mock(OneOf.class);
        Mockito.when((Object)oneOfAnnotation.value()).thenReturn((Object)new String[]{"foo", "bar"});
        Mockito.when((Object)oneOfAnnotation.caseSensitive()).thenReturn((Object)caseSensitive);
        ValidationContext ctx = (ValidationContext)Mockito.mock(ValidationContext.class);
        Mockito.when((Object)ctx.currentKey()).thenReturn((Object)"x");
        Mockito.when((Object)((String)ctx.getNewValue())).thenReturn((Object)"foo", (Object[])new String[]{"Bar", "no"});
        ArgumentCaptor issuesCaptor = ArgumentCaptor.forClass(ValidationIssue.class);
        ((ValidationContext)Mockito.doNothing().when((Object)ctx)).addIssue((ValidationIssue)issuesCaptor.capture());
        OneOfValidator oneOfValidator = new OneOfValidator();
        oneOfValidator.validate(oneOfAnnotation, ctx);
        MatcherAssert.assertThat((Object)issuesCaptor.getAllValues(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        oneOfValidator.validate(oneOfAnnotation, ctx);
        if (caseSensitive) {
            MatcherAssert.assertThat((Object)((ValidationIssue)issuesCaptor.getValue()).message(), (Matcher)CoreMatchers.is((Object)"'x' configuration value must be one of [foo, bar] (case sensitive)"));
        } else {
            MatcherAssert.assertThat((Object)issuesCaptor.getAllValues(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        }
        oneOfValidator.validate(oneOfAnnotation, ctx);
        if (caseSensitive) {
            MatcherAssert.assertThat((Object)((ValidationIssue)issuesCaptor.getValue()).message(), (Matcher)CoreMatchers.is((Object)"'x' configuration value must be one of [foo, bar] (case sensitive)"));
        } else {
            MatcherAssert.assertThat((Object)((ValidationIssue)issuesCaptor.getValue()).message(), (Matcher)CoreMatchers.is((Object)"'x' configuration value must be one of [foo, bar] (case insensitive)"));
        }
    }
}

