/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConverterToMapVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationFlattener;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.DistributedFirstConfiguration;
import org.apache.ignite.internal.configuration.util.DistributedFirstView;
import org.apache.ignite.internal.configuration.util.DistributedSecondConfiguration;
import org.apache.ignite.internal.configuration.util.InternalWithoutSuperclassConfiguration;
import org.apache.ignite.internal.configuration.util.InternalWithoutSuperclassView;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.util.LocalFirstConfiguration;
import org.apache.ignite.internal.configuration.util.LocalSecondConfiguration;
import org.apache.ignite.internal.configuration.util.NamedElementChange;
import org.apache.ignite.internal.configuration.util.NamedElementView;
import org.apache.ignite.internal.configuration.util.ParentChange;
import org.apache.ignite.internal.configuration.util.ParentConfiguration;
import org.apache.ignite.internal.configuration.util.ParentView;
import org.apache.ignite.internal.configuration.util.PolymorphicRootChange;
import org.apache.ignite.internal.configuration.util.PolymorphicRootConfiguration;
import org.apache.ignite.internal.configuration.util.PolymorphicRootView;
import org.apache.ignite.internal.configuration.util.SecondPolymorphicInstanceChange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ConfigurationUtilTest {
    private static ConfigurationAsmGenerator cgen;

    @BeforeAll
    public static void beforeAll() {
        cgen = new ConfigurationAsmGenerator();
        cgen.compileRootSchema(ParentConfigurationSchema.class, Map.of(), Map.of());
        cgen.compileRootSchema(PolymorphicRootConfigurationSchema.class, Map.of(), Map.of(PolymorphicConfigurationSchema.class, Set.of(FirstPolymorphicInstanceConfigurationSchema.class, SecondPolymorphicInstanceConfigurationSchema.class)));
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    public static <P extends InnerNode> P newNodeInstance(Class<?> schemaClass) {
        return (P)cgen.instantiateNode(schemaClass);
    }

    @Test
    public void escape() {
        Assertions.assertEquals((Object)"foo", (Object)ConfigurationUtil.escape((String)"foo"));
        Assertions.assertEquals((Object)"foo\\.bar", (Object)ConfigurationUtil.escape((String)"foo.bar"));
        Assertions.assertEquals((Object)"foo\\\\bar", (Object)ConfigurationUtil.escape((String)"foo\\bar"));
        Assertions.assertEquals((Object)"\\\\a\\.b\\\\c\\.", (Object)ConfigurationUtil.escape((String)"\\a.b\\c."));
    }

    @Test
    public void unescape() {
        Assertions.assertEquals((Object)"foo", (Object)ConfigurationUtil.unescape((String)"foo"));
        Assertions.assertEquals((Object)"foo.bar", (Object)ConfigurationUtil.unescape((String)"foo\\.bar"));
        Assertions.assertEquals((Object)"foo\\bar", (Object)ConfigurationUtil.unescape((String)"foo\\\\bar"));
        Assertions.assertEquals((Object)"\\a.b\\c.", (Object)ConfigurationUtil.unescape((String)"\\\\a\\.b\\\\c\\."));
    }

    @Test
    public void split() {
        Assertions.assertEquals(List.of("a", "b.b", "c\\c", ""), (Object)ConfigurationUtil.split((String)"a.b\\.b.c\\\\c."));
    }

    @Test
    public void join() {
        Assertions.assertEquals((Object)"a.b\\.b.c\\\\c", (Object)ConfigurationUtil.join(List.of("a", "b.b", "c\\c")));
    }

    @Test
    public void findSuccessfully() {
        Object parentNode = ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class);
        ParentChange parentChange = (ParentChange)parentNode;
        parentChange.changeElements(elements -> elements.createOrUpdate("name", element -> element.changeChild(child -> child.changeStr("value"))));
        Assertions.assertSame(parentNode, (Object)ConfigurationUtil.find(List.of(), parentNode, (boolean)true));
        Assertions.assertSame(parentChange.elements(), (Object)ConfigurationUtil.find(List.of("elements"), parentNode, (boolean)true));
        Assertions.assertSame((Object)parentChange.elements().get("name"), (Object)ConfigurationUtil.find(List.of("elements", "name"), parentNode, (boolean)true));
        Assertions.assertSame((Object)((NamedElementView)parentChange.elements().get("name")).child(), (Object)ConfigurationUtil.find(List.of("elements", "name", "child"), parentNode, (boolean)true));
        Assertions.assertSame((Object)((NamedElementView)parentChange.elements().get("name")).child().str(), (Object)ConfigurationUtil.find(List.of("elements", "name", "child", "str"), parentNode, (boolean)true));
    }

    @Test
    public void findNulls() {
        Object parentNode = ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class);
        ParentChange parentChange = (ParentChange)parentNode;
        Assertions.assertNull((Object)ConfigurationUtil.find(List.of("elements", "name"), parentNode, (boolean)true));
        parentChange.changeElements(elements -> elements.createOrUpdate("name", element -> {}));
        Assertions.assertNull((Object)ConfigurationUtil.find(List.of("elements", "name", "child", "str"), parentNode, (boolean)true));
    }

    @Test
    public void findUnsuccessfully() {
        Object parentNode = ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class);
        ParentChange parentChange = (ParentChange)parentNode;
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("elements", "name", "child"), (TraversableTreeNode)parentNode, (boolean)true));
        parentChange.changeElements(elements -> elements.createOrUpdate("name", element -> {}));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("elements", "name", "child", "str0"), (TraversableTreeNode)parentNode, (boolean)true));
        ((NamedElementChange)parentChange.elements().get("name")).changeChild(child -> child.changeStr("value"));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("elements", "name", "child", "str", "foo"), (TraversableTreeNode)parentNode, (boolean)true));
    }

    @Test
    public void toPrefixMap() {
        Assertions.assertEquals(Map.of("foo", 42), (Object)ConfigurationUtil.toPrefixMap(Map.of("foo", 42)));
        Assertions.assertEquals(Map.of("foo.bar", 42), (Object)ConfigurationUtil.toPrefixMap(Map.of("foo\\.bar", 42)));
        Assertions.assertEquals(Map.of("foo", Map.of("bar1", 10, "bar2", 20)), (Object)ConfigurationUtil.toPrefixMap(Map.of("foo.bar1", 10, "foo.bar2", 20)));
        Assertions.assertEquals(Map.of("root1", Map.of("leaf1", 10), "root2", Map.of("leaf2", 20)), (Object)ConfigurationUtil.toPrefixMap(Map.of("root1.leaf1", 10, "root2.leaf2", 20)));
    }

    @Test
    public void fillFromPrefixMapSuccessfully() {
        Object parentNode = ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class);
        ParentChange parentChange = (ParentChange)parentNode;
        ConfigurationUtil.fillFromPrefixMap(parentNode, Map.of("elements", Map.of("01234567-89ab-cdef-0123-456789abcdef", Map.of("child", Map.of("str", "value2"), "<order>", 1, "<name>", "name2"), "12345678-9abc-def0-1234-56789abcdef0", Map.of("child", Map.of("str", "value1"), "<order>", 0, "<name>", "name1"))));
        Assertions.assertEquals((Object)"value1", (Object)((NamedElementView)parentChange.elements().get("name1")).child().str());
        Assertions.assertEquals((Object)"value2", (Object)((NamedElementView)parentChange.elements().get("name2")).child().str());
    }

    @Test
    public void fillFromPrefixMapSuccessfullyWithRemove() {
        Object parentNode = ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class);
        ParentChange parentChange = (ParentChange)parentNode;
        parentChange.changeElements(elements -> elements.createOrUpdate("name", element -> element.changeChild(child -> {})));
        UUID internalId = ((InnerNode)((ParentView)parentNode).elements().get("name")).internalId();
        ConfigurationUtil.fillFromPrefixMap(parentNode, Map.of("elements", Collections.singletonMap(internalId.toString(), null)));
        Assertions.assertNull((Object)parentChange.elements().get("node"));
    }

    @Test
    public void flattenedUpdatesMap() {
        SuperRoot superRoot = new SuperRoot(key -> null, Map.of(ParentConfiguration.KEY, ConfigurationUtilTest.newNodeInstance(ParentConfigurationSchema.class)));
        MatcherAssert.assertThat(this.flattenedMap(superRoot, ParentConfiguration.KEY, node -> {}), (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
        MatcherAssert.assertThat(this.flattenedMap(superRoot, ParentConfiguration.KEY, node -> ((ParentChange)node).changeElements(elements -> elements.create("name", element -> element.changeChild(child -> child.changeStr("foo"))))), (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)4), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.]<ids>[.]name"), (Matcher)Matchers.hasToString((Matcher)Matchers.matchesPattern((String)"[-\\w]{36}"))), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]child[.]str"), (Matcher)Matchers.hasToString((String)"foo")), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]<order>"), (Matcher)Matchers.is((Object)0)), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]<name>"), (Matcher)Matchers.hasToString((String)"name")))));
        MatcherAssert.assertThat(this.flattenedMap(superRoot, ParentConfiguration.KEY, node -> ((ParentChange)node).changeElements(elements1 -> elements1.delete("void"))), (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
        MatcherAssert.assertThat(this.flattenedMap(superRoot, ParentConfiguration.KEY, node -> ((ParentChange)node).changeElements(elements -> elements.delete("name"))), (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)4), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.]<ids>[.]name"), (Matcher)Matchers.nullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]child[.]str"), (Matcher)Matchers.nullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]<order>"), (Matcher)Matchers.nullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.matchesPattern((String)"root[.]elements[.][-\\w]{36}[.]<name>"), (Matcher)Matchers.nullValue()))));
    }

    @Test
    void testCheckConfigurationTypeMixedTypes() {
        List<RootKey<DistributedFirstConfiguration, DistributedFirstView>> rootKeys = List.of(LocalFirstConfiguration.KEY, DistributedFirstConfiguration.KEY);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.checkConfigurationType((Collection)rootKeys, (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.checkConfigurationType((Collection)rootKeys, (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.DISTRIBUTED)));
    }

    @Test
    void testCheckConfigurationTypeOppositeTypes() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.checkConfigurationType(List.of(DistributedFirstConfiguration.KEY, DistributedSecondConfiguration.KEY), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.checkConfigurationType(List.of(LocalFirstConfiguration.KEY, LocalSecondConfiguration.KEY), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.DISTRIBUTED)));
    }

    @Test
    void testCheckConfigurationTypeNoError() {
        ConfigurationUtil.checkConfigurationType(List.of(LocalFirstConfiguration.KEY, LocalSecondConfiguration.KEY), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL));
        ConfigurationUtil.checkConfigurationType(List.of(DistributedFirstConfiguration.KEY, DistributedSecondConfiguration.KEY), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.DISTRIBUTED));
    }

    @Test
    void testInternalSchemaExtensions() {
        Assertions.assertTrue((boolean)ConfigurationUtil.internalSchemaExtensions(List.of()).isEmpty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.internalSchemaExtensions(List.of(Object.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.internalSchemaExtensions(List.of(InternalRootConfigurationSchema.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.internalSchemaExtensions(List.of(InternalConfigurationSchema.class)));
        Map extensions = ConfigurationUtil.internalSchemaExtensions(List.of(InternalFirstRootConfigurationSchema.class, InternalSecondRootConfigurationSchema.class, InternalFirstConfigurationSchema.class, InternalSecondConfigurationSchema.class));
        Assertions.assertEquals((int)2, (int)extensions.size());
        Assertions.assertEquals(Set.of(InternalFirstRootConfigurationSchema.class, InternalSecondRootConfigurationSchema.class), extensions.get(InternalRootConfigurationSchema.class));
        Assertions.assertEquals(Set.of(InternalFirstConfigurationSchema.class, InternalSecondConfigurationSchema.class), extensions.get(InternalConfigurationSchema.class));
    }

    @Test
    void testSchemaFields() {
        Assertions.assertTrue((boolean)ConfigurationUtil.extensionsFields(List.of(), (boolean)true).isEmpty());
        Assertions.assertTrue((boolean)ConfigurationUtil.extensionsFields(List.of(), (boolean)false).isEmpty());
        List<Class<ErrorInternalExtendedRootConfigurationSchema>> extensions0 = List.of(InternalExtendedRootConfigurationSchema.class, ErrorInternalExtendedRootConfigurationSchema.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.extensionsFields((Collection)extensions0, (boolean)true));
        Assertions.assertEquals(extensions0.stream().flatMap(cls -> Arrays.stream(cls.getDeclaredFields())).collect(Collectors.toList()), List.copyOf(ConfigurationUtil.extensionsFields(extensions0, (boolean)false)));
        List<Class<InternalSecondRootConfigurationSchema>> extensions1 = List.of(InternalFirstRootConfigurationSchema.class, InternalSecondRootConfigurationSchema.class);
        Assertions.assertEquals(extensions1.stream().flatMap(cls -> Arrays.stream(cls.getDeclaredFields())).collect(Collectors.toList()), List.copyOf(ConfigurationUtil.extensionsFields(extensions1, (boolean)true)));
        Assertions.assertEquals(extensions1.stream().flatMap(cls -> Arrays.stream(cls.getDeclaredFields())).collect(Collectors.toList()), List.copyOf(ConfigurationUtil.extensionsFields(extensions1, (boolean)false)));
    }

    @Test
    void testFindInternalConfigs() {
        Map internalExtensions = ConfigurationUtil.internalSchemaExtensions(List.of(InternalFirstRootConfigurationSchema.class, InternalSecondRootConfigurationSchema.class, InternalFirstConfigurationSchema.class, InternalSecondConfigurationSchema.class));
        ConfigurationAsmGenerator generator = new ConfigurationAsmGenerator();
        generator.compileRootSchema(InternalRootConfigurationSchema.class, internalExtensions, Map.of());
        InnerNode innerNode = generator.instantiateNode(InternalRootConfigurationSchema.class);
        ConfigurationUtil.addDefaults((InnerNode)innerNode);
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("str2"), (TraversableTreeNode)innerNode, (boolean)false));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("str3"), (TraversableTreeNode)innerNode, (boolean)false));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("subCfg1"), (TraversableTreeNode)innerNode, (boolean)false));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("subCfg", "str01"), (TraversableTreeNode)innerNode, (boolean)false));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of("subCfg", "str02"), (TraversableTreeNode)innerNode, (boolean)false));
        Assertions.assertNull((Object)ConfigurationUtil.find(List.of("str2"), (TraversableTreeNode)innerNode, (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)ConfigurationUtil.find(List.of("str3"), (TraversableTreeNode)innerNode, (boolean)true));
        Assertions.assertNotNull((Object)ConfigurationUtil.find(List.of("subCfg1"), (TraversableTreeNode)innerNode, (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)ConfigurationUtil.find(List.of("subCfg", "str01"), (TraversableTreeNode)innerNode, (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)ConfigurationUtil.find(List.of("subCfg", "str02"), (TraversableTreeNode)innerNode, (boolean)true));
    }

    @Test
    void testGetInternalConfigs() {
        Map internalExtensions = ConfigurationUtil.internalSchemaExtensions(List.of(InternalFirstRootConfigurationSchema.class, InternalSecondRootConfigurationSchema.class, InternalFirstConfigurationSchema.class, InternalSecondConfigurationSchema.class));
        ConfigurationAsmGenerator generator = new ConfigurationAsmGenerator();
        generator.compileRootSchema(InternalRootConfigurationSchema.class, internalExtensions, Map.of());
        InnerNode innerNode = generator.instantiateNode(InternalRootConfigurationSchema.class);
        ConfigurationUtil.addDefaults((InnerNode)innerNode);
        Map config = (Map)innerNode.accept(null, (ConfigurationVisitor)new ConverterToMapVisitor(false));
        Assertions.assertEquals((int)4, (int)config.size());
        Assertions.assertNull(config.get("str0"));
        Assertions.assertEquals((Object)"foo", config.get("str1"));
        Assertions.assertNotNull(config.get("subCfg"));
        Assertions.assertNotNull(config.get("namedCfg"));
        Map subConfig = (Map)config.get("subCfg");
        Assertions.assertEquals((int)1, (int)subConfig.size());
        Assertions.assertEquals((Object)"foo", subConfig.get("str00"));
        config = (Map)innerNode.accept(null, (ConfigurationVisitor)new ConverterToMapVisitor(true));
        Assertions.assertEquals((int)7, (int)config.size());
        Assertions.assertNull(config.get("str0"));
        Assertions.assertNull(config.get("str2"));
        Assertions.assertEquals((Object)"foo", config.get("str1"));
        Assertions.assertEquals((Object)"foo", config.get("str3"));
        Assertions.assertNotNull(config.get("subCfg"));
        Assertions.assertNotNull(config.get("subCfg1"));
        Assertions.assertNotNull(config.get("namedCfg"));
        subConfig = (Map)config.get("subCfg");
        Assertions.assertEquals((int)3, (int)subConfig.size());
        Assertions.assertEquals((Object)"foo", subConfig.get("str00"));
        Assertions.assertEquals((Object)"foo", subConfig.get("str01"));
        Assertions.assertEquals((Object)"foo", subConfig.get("str02"));
        subConfig = (Map)config.get("subCfg1");
        Assertions.assertEquals((int)3, (int)subConfig.size());
        Assertions.assertEquals((Object)"foo", subConfig.get("str00"));
        Assertions.assertEquals((Object)"foo", subConfig.get("str01"));
        Assertions.assertEquals((Object)"foo", subConfig.get("str02"));
    }

    @Test
    void testSuperRootWithInternalConfig() {
        ConfigurationAsmGenerator generator = new ConfigurationAsmGenerator();
        Class<InternalWithoutSuperclassConfigurationSchema> schemaClass = InternalWithoutSuperclassConfigurationSchema.class;
        RootKey<InternalWithoutSuperclassConfiguration, InternalWithoutSuperclassView> schemaKey = InternalWithoutSuperclassConfiguration.KEY;
        generator.compileRootSchema(schemaClass, Map.of(), Map.of());
        SuperRoot superRoot = new SuperRoot(s -> new RootInnerNode(schemaKey, generator.instantiateNode(schemaClass)));
        Assertions.assertThrows(NoSuchElementException.class, () -> superRoot.construct(schemaKey.key(), null, false));
        superRoot.construct(schemaKey.key(), null, true);
        superRoot.addRoot(schemaKey, generator.instantiateNode(schemaClass));
        Assertions.assertThrows(KeyNotFoundException.class, () -> ConfigurationUtil.find(List.of(schemaKey.key()), (TraversableTreeNode)superRoot, (boolean)false));
        Assertions.assertNotNull((Object)ConfigurationUtil.find(List.of(schemaKey.key()), (TraversableTreeNode)superRoot, (boolean)true));
        Map config = (Map)superRoot.accept(schemaKey.key(), (ConfigurationVisitor)new ConverterToMapVisitor(false));
        Assertions.assertTrue((boolean)config.isEmpty());
        config = (Map)superRoot.accept(schemaKey.key(), (ConfigurationVisitor)new ConverterToMapVisitor(true));
        Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertNotNull(config.get(schemaKey.key()));
    }

    @Test
    void testCollectSchemas() {
        Assertions.assertTrue((boolean)ConfigurationUtil.collectSchemas(List.of()).isEmpty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.collectSchemas(List.of(Object.class)));
        Set<Class<PolymorphicConfigurationSchema>> schemas = Set.of(LocalFirstConfigurationSchema.class, InternalConfigurationSchema.class, PolymorphicConfigurationSchema.class);
        Assertions.assertEquals(schemas, (Object)ConfigurationUtil.collectSchemas(schemas));
        Assertions.assertEquals(Set.of(InternalRootConfigurationSchema.class, PolymorphicRootConfigurationSchema.class, InternalConfigurationSchema.class, PolymorphicConfigurationSchema.class), (Object)ConfigurationUtil.collectSchemas(List.of(InternalRootConfigurationSchema.class, PolymorphicRootConfigurationSchema.class)));
    }

    @Test
    void testPolymorphicSchemaExtensions() {
        Assertions.assertTrue((boolean)ConfigurationUtil.polymorphicSchemaExtensions(List.of()).isEmpty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.polymorphicSchemaExtensions(List.of(Object.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtil.polymorphicSchemaExtensions(List.of(LocalFirstConfigurationSchema.class)));
        Set<Class<SecondPolymorphicInstanceConfigurationSchema>> extensions = Set.of(FirstPolymorphicInstanceConfigurationSchema.class, SecondPolymorphicInstanceConfigurationSchema.class);
        Assertions.assertEquals(Map.of(PolymorphicConfigurationSchema.class, extensions), (Object)ConfigurationUtil.polymorphicSchemaExtensions(extensions));
    }

    @Test
    void testCompressDeletedEntries() {
        HashMap<String, String> containsNullLeaf = new HashMap<String, String>();
        containsNullLeaf.put("first", "1");
        containsNullLeaf.put("second", null);
        HashMap<String, Object> deletedNamedListElement = new HashMap<String, Object>();
        deletedNamedListElement.put("third", null);
        deletedNamedListElement.put("<name>", null);
        HashMap<String, Object> regular = new HashMap<String, Object>();
        regular.put("strVal", "foo");
        regular.put("intVal", 10);
        HashMap<String, HashMap<String, Object>> prefixMap = new HashMap<String, HashMap<String, Object>>();
        prefixMap.put("0", containsNullLeaf);
        prefixMap.put("1", deletedNamedListElement);
        prefixMap.put("2", regular);
        HashMap<String, Map<String, Object>> exp = new HashMap<String, Map<String, Object>>();
        exp.put("0", Map.of("first", "1"));
        exp.put("1", null);
        exp.put("2", Map.of("strVal", "foo", "intVal", 10));
        ConfigurationUtil.compressDeletedEntries(prefixMap);
        Assertions.assertEquals(exp, prefixMap);
    }

    @Test
    void testFlattenedMapPolymorphicConfig() {
        Object polymorphicRootInnerNode = ConfigurationUtilTest.newNodeInstance(PolymorphicRootConfigurationSchema.class);
        ConfigurationUtil.addDefaults(polymorphicRootInnerNode);
        RootKey<PolymorphicRootConfiguration, PolymorphicRootView> rootKey = PolymorphicRootConfiguration.KEY;
        SuperRoot superRoot = new SuperRoot(key -> null, Map.of(rootKey, polymorphicRootInnerNode));
        Map<String, Serializable> act = this.flattenedMap(superRoot, rootKey, node -> ((PolymorphicRootChange)node).changePolymorphicSubCfg(c -> c.convert(SecondPolymorphicInstanceChange.class)));
        HashMap<String, Object> exp = new HashMap<String, Object>();
        exp.put("rootPolymorphic.polymorphicSubCfg.typeId", "second");
        exp.put("rootPolymorphic.polymorphicSubCfg.longVal", 0L);
        exp.put("rootPolymorphic.polymorphicSubCfg.strVal", null);
        exp.put("rootPolymorphic.polymorphicSubCfg.intVal", 0);
        Assertions.assertEquals(exp, act);
    }

    @Test
    void testFlattenedMapPolymorphicNamedConfig() {
        Object polymorphicRootInnerNode = ConfigurationUtilTest.newNodeInstance(PolymorphicRootConfigurationSchema.class);
        PolymorphicRootChange polymorphicRootChange = (PolymorphicRootChange)polymorphicRootInnerNode;
        polymorphicRootChange.changePolymorphicNamedCfg(c -> c.create("0", c1 -> {}));
        ConfigurationUtil.addDefaults(polymorphicRootInnerNode);
        RootKey<PolymorphicRootConfiguration, PolymorphicRootView> rootKey = PolymorphicRootConfiguration.KEY;
        SuperRoot superRoot = new SuperRoot(key -> null, Map.of(rootKey, polymorphicRootInnerNode));
        Map<String, Serializable> act = this.flattenedMap(superRoot, rootKey, node -> ((PolymorphicRootChange)node).changePolymorphicNamedCfg(c -> c.createOrUpdate("0", c1 -> c1.convert(SecondPolymorphicInstanceChange.class))));
        NamedListNode polymorphicNamedCfgListNode = (NamedListNode)polymorphicRootChange.polymorphicNamedCfg();
        UUID internalId = polymorphicNamedCfgListNode.internalId("0");
        HashMap<CallSite, Object> exp = new HashMap<CallSite, Object>();
        exp.put((CallSite)((Object)("rootPolymorphic.polymorphicNamedCfg." + internalId + ".typeId")), "second");
        exp.put((CallSite)((Object)("rootPolymorphic.polymorphicNamedCfg." + internalId + ".longVal")), 0L);
        exp.put((CallSite)((Object)("rootPolymorphic.polymorphicNamedCfg." + internalId + ".strVal")), null);
        exp.put((CallSite)((Object)("rootPolymorphic.polymorphicNamedCfg." + internalId + ".intVal")), 0);
        Assertions.assertEquals(exp, act);
    }

    @Test
    void testRemoveLastKey() {
        Assertions.assertEquals(List.of(), (Object)ConfigurationUtil.removeLastKey(List.of()));
        Assertions.assertEquals(List.of(), (Object)ConfigurationUtil.removeLastKey(List.of("0")));
        Assertions.assertEquals(List.of("0"), (Object)ConfigurationUtil.removeLastKey(List.of("0", "1")));
    }

    @NotNull
    private Map<String, Serializable> flattenedMap(SuperRoot superRoot, RootKey<?, ?> rootKey, Consumer<InnerNode> patch) {
        SuperRoot originalSuperRoot = superRoot.copy();
        superRoot.construct(rootKey.key(), ConfigurationUtil.EMPTY_CFG_SRC, true);
        patch.accept(superRoot.getRoot(rootKey));
        return ConfigurationFlattener.createFlattenedUpdatesMap((SuperRoot)originalSuperRoot, (SuperRoot)superRoot);
    }

    @PolymorphicConfigInstance(value="second")
    public static class SecondPolymorphicInstanceConfigurationSchema
    extends PolymorphicConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
    }

    @PolymorphicConfigInstance(value="first")
    public static class FirstPolymorphicInstanceConfigurationSchema
    extends PolymorphicConfigurationSchema {
        @Value(hasDefault=true)
        public String strVal = "strVal";
    }

    @PolymorphicConfig
    public static class PolymorphicConfigurationSchema {
        @PolymorphicId(hasDefault=true)
        public String typeId = "first";
        @Value(hasDefault=true)
        public long longVal = 0L;
    }

    @ConfigurationRoot(rootName="rootPolymorphic")
    public static class PolymorphicRootConfigurationSchema {
        @ConfigValue
        public PolymorphicConfigurationSchema polymorphicSubCfg;
        @NamedConfigValue
        public PolymorphicConfigurationSchema polymorphicNamedCfg;
    }

    @InternalConfiguration
    public static class ErrorInternalExtendedRootConfigurationSchema
    extends InternalRootConfigurationSchema {
        @Value
        public String str00;
    }

    @InternalConfiguration
    public static class InternalExtendedRootConfigurationSchema
    extends InternalRootConfigurationSchema {
        @Value
        public String str00;
        @Value(hasDefault=true)
        public String str01 = "foo";
        @ConfigValue
        public InternalConfigurationSchema subCfg0;
        @NamedConfigValue
        public InternalConfigurationSchema namedCfg0;
    }

    @InternalConfiguration
    public static class InternalSecondRootConfigurationSchema
    extends InternalRootConfigurationSchema {
        @ConfigValue
        public InternalConfigurationSchema subCfg1;
    }

    @InternalConfiguration
    public static class InternalFirstRootConfigurationSchema
    extends InternalRootConfigurationSchema {
        @Value
        public String str2;
        @Value(hasDefault=true)
        public String str3 = "foo";
    }

    @InternalConfiguration
    public static class InternalSecondConfigurationSchema
    extends InternalConfigurationSchema {
        @Value(hasDefault=true)
        public String str02 = "foo";
    }

    @InternalConfiguration
    public static class InternalFirstConfigurationSchema
    extends InternalConfigurationSchema {
        @Value(hasDefault=true)
        public String str01 = "foo";
    }

    @InternalConfiguration
    @ConfigurationRoot(rootName="testRootInternal")
    public static class InternalWithoutSuperclassConfigurationSchema {
    }

    @Config
    public static class InternalConfigurationSchema {
        @Value(hasDefault=true)
        public String str00 = "foo";
    }

    @ConfigurationRoot(rootName="rootInternal")
    public static class InternalRootConfigurationSchema {
        @Value
        public String str0;
        @Value(hasDefault=true)
        public String str1 = "foo";
        @ConfigValue
        public InternalConfigurationSchema subCfg;
        @NamedConfigValue
        public InternalConfigurationSchema namedCfg;
    }

    @ConfigurationRoot(rootName="distributedSecond", type=ConfigurationType.DISTRIBUTED)
    public static class DistributedSecondConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }

    @ConfigurationRoot(rootName="distributedFirst", type=ConfigurationType.DISTRIBUTED)
    public static class DistributedFirstConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }

    @ConfigurationRoot(rootName="localSecond", type=ConfigurationType.LOCAL)
    public static class LocalSecondConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }

    @ConfigurationRoot(rootName="localFirst", type=ConfigurationType.LOCAL)
    public static class LocalFirstConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }

    @Config
    public static class ChildConfigurationSchema {
        @Value
        public String str;
    }

    @Config
    public static class NamedElementConfigurationSchema {
        @ConfigValue
        public ChildConfigurationSchema child;
    }

    @ConfigurationRoot(rootName="root", type=ConfigurationType.LOCAL)
    public static class ParentConfigurationSchema {
        @NamedConfigValue
        public NamedElementConfigurationSchema elements;
    }
}

