/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.ignite.internal.configuration.util.ConfigurationSerializationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfigurationSerializationUtilTest {
    ConfigurationSerializationUtilTest() {
    }

    @Test
    void testSingleValuesConsistency() {
        this.assertSingleValue(Boolean.FALSE);
        this.assertSingleValue(Boolean.TRUE);
        this.assertSingleValue((byte)123);
        this.assertSingleValue((short)4660);
        this.assertSingleValue(305419896);
        this.assertSingleValue(1311768467463790320L);
        this.assertSingleValue(Character.valueOf('F'));
        this.assertSingleValue(Float.valueOf(0.3f));
        this.assertSingleValue(0.3);
        this.assertSingleValue("foo");
    }

    @Test
    void testArraysConsistency() {
        this.assertArray(new boolean[]{false, true});
        this.assertArray(new byte[]{10, -10});
        this.assertArray(new short[]{1000, -1000});
        this.assertArray(new int[]{1000000, -1000000});
        this.assertArray(new long[]{1000000000000L, -1000000000000L});
        this.assertArray(new char[]{'X', 'Y'});
        this.assertArray(new float[]{0.1f, -0.1f});
        this.assertArray(new double[]{0.1, -0.1});
        this.assertArray(new String[]{"foo", "bar"});
    }

    private void assertSingleValue(Object value) {
        Assertions.assertEquals((Object)value, (Object)ConfigurationSerializationUtil.fromBytes((byte[])ConfigurationSerializationUtil.toBytes((Object)value)));
    }

    private void assertArray(Object value) {
        Serializable res = ConfigurationSerializationUtil.fromBytes((byte[])ConfigurationSerializationUtil.toBytes((Object)value));
        Assertions.assertEquals(value.getClass(), res.getClass());
        Assertions.assertEquals((int)Array.getLength(value), (int)Array.getLength(res));
        for (int i = 0; i < Array.getLength(value); ++i) {
            Assertions.assertEquals((Object)Array.get(value, i), (Object)Array.get(res, i));
        }
    }
}

