/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.Immutable;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.tree.ChildChange;
import org.apache.ignite.internal.configuration.tree.ChildView;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedElementChange;
import org.apache.ignite.internal.configuration.tree.NamedElementView;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.ParentChange;
import org.apache.ignite.internal.configuration.tree.ParentView;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TraversableTreeNodeTest {
    private static ConfigurationAsmGenerator cgen;

    @BeforeAll
    public static void beforeAll() {
        cgen = new ConfigurationAsmGenerator();
        cgen.compileRootSchema(ParentConfigurationSchema.class, Map.of(), Map.of());
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    public static <P extends InnerNode> P newParentInstance() {
        return (P)cgen.instantiateNode(ParentConfigurationSchema.class);
    }

    public static <C extends InnerNode> C newChildInstance() {
        return (C)cgen.instantiateNode(ChildConfigurationSchema.class);
    }

    @Test
    public void nodeClassesImplementRequiredInterfaces() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        MatcherAssert.assertThat(parentNode, (Matcher)CoreMatchers.instanceOf(ParentView.class));
        MatcherAssert.assertThat(parentNode, (Matcher)CoreMatchers.instanceOf(ParentChange.class));
        InnerNode namedElementNode = cgen.instantiateNode(NamedElementConfigurationSchema.class);
        MatcherAssert.assertThat((Object)namedElementNode, (Matcher)CoreMatchers.instanceOf(NamedElementView.class));
        MatcherAssert.assertThat((Object)namedElementNode, (Matcher)CoreMatchers.instanceOf(NamedElementChange.class));
        Object childNode = TraversableTreeNodeTest.newChildInstance();
        MatcherAssert.assertThat(childNode, (Matcher)CoreMatchers.instanceOf(ChildView.class));
        MatcherAssert.assertThat(childNode, (Matcher)CoreMatchers.instanceOf(ChildChange.class));
    }

    @Test
    public void changeLeaf() {
        Object childNode = TraversableTreeNodeTest.newChildInstance();
        Assertions.assertNull((Object)((ChildView)childNode).strCfg());
        ((ChildChange)childNode).changeStrCfg("value");
        Assertions.assertEquals((Object)"value", (Object)((ChildView)childNode).strCfg());
        Assertions.assertThrows(NullPointerException.class, () -> ((ChildChange)childNode).changeStrCfg(null));
    }

    @Test
    public void changeInnerChild() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        Assertions.assertNull((Object)((ParentView)parentNode).child());
        ((ParentChange)parentNode).changeChild(child -> {});
        ChildView childNode = ((ParentView)parentNode).child();
        Assertions.assertNotNull((Object)childNode);
        ((ParentChange)parentNode).changeChild(child -> child.changeStrCfg("value"));
        Assertions.assertNotSame((Object)childNode, (Object)((ParentView)parentNode).child());
        Assertions.assertThrows(NullPointerException.class, () -> ((ParentChange)parentNode).changeChild(null));
        Assertions.assertThrows(NullPointerException.class, () -> ((ParentChange)parentNode).changeElements(null));
    }

    @Test
    public void changeNamedChild() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        NamedListView<? extends NamedElementView> elementsNode = ((ParentView)parentNode).elements();
        Assertions.assertNotNull(elementsNode);
        ((ParentChange)parentNode).changeElements(elements -> elements.createOrUpdate("key", element -> {}));
        Assertions.assertNotSame(elementsNode, ((ParentView)parentNode).elements());
    }

    @Test
    public void putRemoveNamedConfiguration() {
        NamedListChange elementsNode = (NamedListChange)((ParentView)TraversableTreeNodeTest.newParentInstance()).elements();
        Assertions.assertEquals(List.of(), (Object)elementsNode.namedListKeys());
        elementsNode.createOrUpdate("keyPut", element -> {});
        Assertions.assertThrows(IllegalArgumentException.class, () -> elementsNode.create("keyPut", element -> {}));
        MatcherAssert.assertThat((Object)elementsNode.namedListKeys(), (Matcher)CoreMatchers.hasItem((Object)"keyPut"));
        NamedElementView elementNode = (NamedElementView)elementsNode.get("keyPut");
        Assertions.assertNotNull((Object)elementNode);
        Assertions.assertSame((Object)elementNode, (Object)elementsNode.get(0));
        Assertions.assertNull((Object)elementNode.strCfg());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> elementsNode.get(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> elementsNode.get(1));
        elementsNode.createOrUpdate("keyPut", element -> element.changeStrCfg("val"));
        Assertions.assertNotSame((Object)elementNode, (Object)elementsNode.get("keyPut"));
        elementNode = (NamedElementView)elementsNode.get("keyPut");
        Assertions.assertEquals((Object)"val", (Object)elementNode.strCfg());
        elementsNode.delete("keyPut");
        MatcherAssert.assertThat((Object)elementsNode.namedListKeys(), (Matcher)CoreMatchers.hasItem((Object)"keyPut"));
        Assertions.assertNull((Object)elementsNode.get("keyPut"));
        elementsNode.delete("keyPut");
        MatcherAssert.assertThat((Object)elementsNode.namedListKeys(), (Matcher)CoreMatchers.hasItem((Object)"keyPut"));
        Assertions.assertNull((Object)elementsNode.get("keyPut"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> elementsNode.createOrUpdate("keyPut", element -> {}));
    }

    @Test
    public void innerNodeAcceptVisitor() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        Assertions.assertThrows(VisitException.class, () -> parentNode.accept("root", (ConfigurationVisitor)new ConfigurationVisitor<Void>(){

            public Void visitInnerNode(String key, InnerNode node) {
                throw new VisitException();
            }
        }));
    }

    @Test
    public void namedListNodeAcceptVisitor() {
        TraversableTreeNode elementsNode = (TraversableTreeNode)((ParentView)TraversableTreeNodeTest.newParentInstance()).elements();
        Assertions.assertThrows(VisitException.class, () -> elementsNode.accept("root", (ConfigurationVisitor)new ConfigurationVisitor<Void>(){

            public Void visitNamedListNode(String key, NamedListNode<?> node) {
                throw new VisitException();
            }
        }));
    }

    @Test
    public void traverseChildren() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        final TreeSet keys = new TreeSet();
        parentNode.traverseChildren((ConfigurationVisitor)new ConfigurationVisitor<Object>(){

            public Object visitInnerNode(String key, InnerNode node) {
                Assertions.assertNull((Object)node);
                Assertions.assertEquals((Object)"child", (Object)key);
                return keys.add(key);
            }

            public Object visitNamedListNode(String key, NamedListNode<?> node) {
                Assertions.assertEquals((Object)"elements", (Object)key);
                return keys.add(key);
            }
        }, true);
        Assertions.assertEquals(new TreeSet<String>(List.of("child", "elements")), keys);
        keys.clear();
        Object childNode = TraversableTreeNodeTest.newChildInstance();
        childNode.traverseChildren((ConfigurationVisitor)new ConfigurationVisitor<Object>(){

            public Object visitLeafNode(String key, Serializable val) {
                return keys.add(key);
            }
        }, true);
        Assertions.assertEquals(new TreeSet<String>(List.of("intCfg", "strCfg")), keys);
    }

    @Test
    public void traverseSingleChild() {
        Object parentNode = TraversableTreeNodeTest.newParentInstance();
        Assertions.assertThrows(VisitException.class, () -> parentNode.traverseChild("child", (ConfigurationVisitor)new ConfigurationVisitor<Void>(){

            public Void visitInnerNode(String key, InnerNode node) {
                Assertions.assertEquals((Object)"child", (Object)key);
                throw new VisitException();
            }
        }, true));
        Assertions.assertThrows(VisitException.class, () -> parentNode.traverseChild("elements", (ConfigurationVisitor)new ConfigurationVisitor<Void>(){

            public Void visitNamedListNode(String key, NamedListNode<?> node) {
                Assertions.assertEquals((Object)"elements", (Object)key);
                throw new VisitException();
            }
        }, true));
        Object childNode = TraversableTreeNodeTest.newChildInstance();
        Assertions.assertThrows(VisitException.class, () -> childNode.traverseChild("intCfg", (ConfigurationVisitor)new ConfigurationVisitor<Void>(){

            public Void visitLeafNode(String key, Serializable val) {
                Assertions.assertEquals((Object)"intCfg", (Object)key);
                throw new VisitException();
            }
        }, true));
        Assertions.assertThrows(NoSuchElementException.class, () -> childNode.traverseChild("foo", (ConfigurationVisitor)new ConfigurationVisitor<Object>(){}, true));
    }

    private static class VisitException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private VisitException() {
        }
    }

    @Config
    public static class NamedElementConfigurationSchema {
        @Value
        public String strCfg;
    }

    @Config
    public static class ChildConfigurationSchema {
        @Value(hasDefault=true)
        @Immutable
        public int intCfg = 99;
        @Value
        public String strCfg;
    }

    @Config
    public static class ParentConfigurationSchema {
        @ConfigValue
        public ChildConfigurationSchema child;
        @NamedConfigValue
        public NamedElementConfigurationSchema elements;
    }
}

