/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.List;
import org.apache.ignite.internal.configuration.tree.OrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OrderedMapTest {
    private final OrderedMap<String> map = new OrderedMap();

    @Test
    public void putGetRemove() {
        Assertions.assertNull((Object)this.map.get("key1"));
        this.map.put("key", (Object)"value");
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)"value", (Object)this.map.get("key"));
        Assertions.assertEquals((Object)"value", (Object)this.map.get(0));
        this.map.remove("key");
        Assertions.assertNull((Object)this.map.get("key1"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.map.get(0));
    }

    @Test
    public void keysOrder() {
        this.map.put("key1", (Object)"value1");
        this.map.put("key2", (Object)"value2");
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals(List.of("key1", "key2"), (Object)this.map.keys());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertEquals(List.of(), (Object)this.map.keys());
        this.map.put("key2", (Object)"value2");
        this.map.put("key1", (Object)"value1");
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals(List.of("key2", "key1"), (Object)this.map.keys());
        this.map.put("key2", (Object)"value3");
        Assertions.assertEquals(List.of("key2", "key1"), (Object)this.map.keys());
    }

    @Test
    public void putByIndex() {
        this.map.putByIndex(0, "key1", (Object)"value1");
        this.map.putByIndex(0, "key2", (Object)"value2");
        Assertions.assertEquals(List.of("key2", "key1"), (Object)this.map.keys());
        this.map.putByIndex(1, "key3", (Object)"value3");
        Assertions.assertEquals(List.of("key2", "key3", "key1"), (Object)this.map.keys());
        this.map.putByIndex(3, "key4", (Object)"value4");
        Assertions.assertEquals(List.of("key2", "key3", "key1", "key4"), (Object)this.map.keys());
        this.map.putByIndex(5, "key5", (Object)"value5");
        Assertions.assertEquals(List.of("key2", "key3", "key1", "key4", "key5"), (Object)this.map.keys());
    }

    @Test
    public void putAfter() {
        this.map.put("key1", (Object)"value1");
        Assertions.assertEquals(List.of("key1"), (Object)this.map.keys());
        this.map.putAfter("key1", "key2", (Object)"value2");
        Assertions.assertEquals(List.of("key1", "key2"), (Object)this.map.keys());
        this.map.putAfter("key1", "key3", (Object)"value3");
        Assertions.assertEquals(List.of("key1", "key3", "key2"), (Object)this.map.keys());
        this.map.putAfter("key2", "key4", (Object)"value4");
        Assertions.assertEquals(List.of("key1", "key3", "key2", "key4"), (Object)this.map.keys());
    }

    @Test
    public void rename() {
        this.map.put("key1", (Object)"value1");
        this.map.put("key2", (Object)"value2");
        this.map.put("key3", (Object)"value3");
        this.map.rename("key2", "key4");
        Assertions.assertEquals((Object)"value2", (Object)this.map.get("key4"));
        Assertions.assertFalse((boolean)this.map.containsKey("key2"));
        Assertions.assertEquals(List.of("key1", "key4", "key3"), (Object)this.map.keys());
    }

    @Test
    public void reorderKeys() {
        this.map.put("key1", (Object)"value1");
        this.map.put("key2", (Object)"value2");
        this.map.put("key3", (Object)"value3");
        Assertions.assertEquals(List.of("key1", "key2", "key3"), (Object)this.map.keys());
        this.map.reorderKeys(List.of("key2", "key1", "key3"));
        Assertions.assertEquals(List.of("key2", "key1", "key3"), (Object)this.map.keys());
        this.map.reorderKeys(List.of("key2", "key3", "key1"));
        Assertions.assertEquals(List.of("key2", "key3", "key1"), (Object)this.map.keys());
        this.map.reorderKeys(List.of("key1", "key3", "key2"));
        Assertions.assertEquals(List.of("key1", "key3", "key2"), (Object)this.map.keys());
    }
}

