/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.TestConfigurationChanger;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.FirstConfiguration;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.SecondChange;
import org.apache.ignite.internal.configuration.tree.SecondConfiguration;
import org.apache.ignite.internal.testframework.matchers.CompletableFutureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NamedListNodeTest {
    private static ConfigurationAsmGenerator cgen;
    private TestConfigurationStorage storage;
    private TestConfigurationChanger changer;

    @BeforeAll
    public static void beforeAll() {
        cgen = new ConfigurationAsmGenerator();
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    @BeforeEach
    public void before() {
        this.storage = new TestConfigurationStorage(ConfigurationType.LOCAL);
        this.changer = new TestConfigurationChanger(cgen, List.of(FirstConfiguration.KEY), Map.of(), this.storage, List.of(), List.of());
        this.changer.start();
    }

    @AfterEach
    public void after() throws Exception {
        this.changer.stop();
    }

    @Test
    public void storageData() throws Exception {
        FirstConfiguration a = (FirstConfiguration)cgen.instantiateCfg(FirstConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        a.second().change(b -> b.create("X", x -> x.changeThird(xb -> xb.create("Z0", z0 -> {})))).get();
        String x0Id = ((NamedListNode)a.second().value()).internalId("X").toString();
        String z0Id = ((NamedListNode)((SecondConfiguration)a.second().get("X")).third().value()).internalId("Z0").toString();
        CompletionStage storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)8), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z0", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z0")})));
        SecondConfiguration x = (SecondConfiguration)a.second().get("X");
        x.third().change(xb -> xb.create("Z5", z5 -> {})).get();
        String z5Id = ((NamedListNode)((SecondConfiguration)a.second().get("X")).third().value()).internalId("Z5").toString();
        storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)12), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z0", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z5", x0Id), (Object)z5Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z0"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z5Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z5Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z5Id), (Object)"Z5")})));
        x.third().change(xb -> xb.create(1, "Z2", z2 -> {})).get();
        String z2Id = ((NamedListNode)((SecondConfiguration)a.second().get("X")).third().value()).internalId("Z2").toString();
        storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)16), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z0", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z2", x0Id), (Object)z2Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z5", x0Id), (Object)z5Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z0"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z2Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z2Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z2Id), (Object)"Z2"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z5Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z5Id), (Object)2), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z5Id), (Object)"Z5")})));
        x.third().change(xb -> xb.createAfter("Z2", "Z3", z3 -> {})).get();
        String z3Id = ((NamedListNode)((SecondConfiguration)a.second().get("X")).third().value()).internalId("Z3").toString();
        storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)20), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z0", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z2", x0Id), (Object)z2Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z3", x0Id), (Object)z3Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z5", x0Id), (Object)z5Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z0"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z2Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z2Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z2Id), (Object)"Z2"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z3Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z3Id), (Object)2), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z3Id), (Object)"Z3"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z5Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z5Id), (Object)3), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z5Id), (Object)"Z5")})));
        x.third().change(xb -> xb.delete("Z2").delete("Z5")).get();
        storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)12), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z0", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z3", x0Id), (Object)z3Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z0"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z3Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z3Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z3Id), (Object)"Z3")})));
        x.third().change(xb -> xb.rename("Z0", "Z1")).get();
        storageValues = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)storageValues, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.aMapWithSize((int)12), Matchers.hasEntry((Object)String.format("a.second.<ids>.X", new Object[0]), (Object)x0Id), Matchers.hasEntry((Object)String.format("a.second.%s.str", x0Id), (Object)"foo"), Matchers.hasEntry((Object)String.format("a.second.%s.<order>", x0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.<name>", x0Id), (Object)"X"), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z1", x0Id), (Object)z0Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.<ids>.Z3", x0Id), (Object)z3Id), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z0Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z0Id), (Object)0), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z0Id), (Object)"Z1"), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.intVal", x0Id, z3Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<order>", x0Id, z3Id), (Object)1), Matchers.hasEntry((Object)String.format("a.second.%s.third.%s.<name>", x0Id, z3Id), (Object)"Z3")})));
        a.second().change(b -> b.delete("X")).get();
        MatcherAssert.assertThat((Object)this.storage.readAll().thenApply(Data::values), (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.anEmptyMap()));
    }

    @Test
    public void errors() throws Exception {
        NamedListNode b = new NamedListNode("name", () -> cgen.instantiateNode(SecondConfigurationSchema.class), null);
        b.create("X", x -> {}).create("Y", y -> {});
        Assertions.assertThrows(NullPointerException.class, () -> b.create(null, z -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> b.createOrUpdate(null, z -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> b.create(0, null, z -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> b.rename(null, "Z"));
        Assertions.assertThrows(NullPointerException.class, () -> b.rename("X", null));
        Assertions.assertThrows(NullPointerException.class, () -> b.delete(null));
        Assertions.assertThrows(NullPointerException.class, () -> b.create("Z", null));
        Assertions.assertThrows(NullPointerException.class, () -> b.createOrUpdate("Z", null));
        Assertions.assertThrows(NullPointerException.class, () -> b.create(0, "Z", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.create("X", x -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.create(0, "X", x -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.rename("X", "Y"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> b.create(-1, "Z", z -> {}));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> b.create(3, "Z", z -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.rename("A", "Z"));
        b.delete("X");
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.create("X", x -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.create(0, "X", x -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.rename("X", "Z"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> b.rename("Y", "X"));
        b.delete("X");
        b.delete("Y");
    }

    @Test
    public void testUpdate() {
        NamedListNode list = new NamedListNode("name", () -> cgen.instantiateNode(SecondConfigurationSchema.class), null);
        list.create("foo", ch -> ch.changeStr("bar"));
        MatcherAssert.assertThat((Object)((SecondChange)list.get("foo")).str(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bar")));
        list.update("foo", ch -> ch.changeStr("baz"));
        MatcherAssert.assertThat((Object)((SecondChange)list.get("foo")).str(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"baz")));
        list.delete("foo");
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.update("foo", ch -> {}));
    }

    @Test
    public void testUpdateErrors() {
        NamedListNode list = new NamedListNode("name", () -> cgen.instantiateNode(SecondConfigurationSchema.class), null);
        Assertions.assertThrows(NullPointerException.class, () -> list.update(null, ch -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> list.update("foo", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.update("wrong", ch -> {}));
    }

    @Test
    void testCreateAfterErrors() {
        NamedListNode list = new NamedListNode("name", () -> cgen.instantiateNode(SecondConfigurationSchema.class), null);
        list.create("X", x -> {}).create("Y", y -> {});
        Assertions.assertThrows(NullPointerException.class, () -> list.createAfter(null, "Z", z -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> list.createAfter("X", null, z -> {}));
        Assertions.assertThrows(NullPointerException.class, () -> list.createAfter("X", "Z", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.createAfter("X", "Y", y -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.createAfter("A", "Z", z -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.delete("X").createAfter("X", "foo", foo -> {}));
    }

    @Config
    public static class ThirdConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 1;
    }

    @Config
    public static class SecondConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "foo";
        @NamedConfigValue
        public ThirdConfigurationSchema third;
    }

    @ConfigurationRoot(rootName="a")
    public static class FirstConfigurationSchema {
        @NamedConfigValue
        public SecondConfigurationSchema second;
    }
}

