/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.InternalIdFooChange;
import org.apache.ignite.internal.configuration.tree.InternalIdInternalConfiguration;
import org.apache.ignite.internal.configuration.tree.InternalIdInternalView;
import org.apache.ignite.internal.configuration.tree.InternalIdParentConfiguration;
import org.apache.ignite.internal.configuration.tree.InternalIdPolymorphicConfiguration;
import org.apache.ignite.internal.configuration.tree.InternalIdPolymorphicView;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InternalIdTest {
    private final ConfigurationRegistry registry = new ConfigurationRegistry(List.of(InternalIdParentConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(InternalIdInternalConfigurationSchema.class), List.of(InternalIdFooConfigurationSchema.class));

    @BeforeEach
    void setUp() {
        this.registry.start();
        this.registry.initializeDefaults();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.registry.stop();
    }

    @Test
    public void testInternalExtension() {
        InternalIdParentConfiguration cfg = (InternalIdParentConfiguration)this.registry.getConfiguration(InternalIdParentConfiguration.KEY);
        UUID internalId = UUID.randomUUID();
        ((InnerNode)cfg.value()).internalId(internalId);
        MatcherAssert.assertThat((Object)((UUID)((InternalIdInternalConfiguration)cfg).id().value()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
        MatcherAssert.assertThat((Object)((InternalIdInternalView)cfg.value()).id(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
    }

    @Test
    public void testPolymorphicExtension() throws Exception {
        InternalIdParentConfiguration cfg = (InternalIdParentConfiguration)this.registry.getConfiguration(InternalIdParentConfiguration.KEY);
        cfg.polymorphic().change(list -> list.create("a", element -> {
            UUID internalId = element.id();
            MatcherAssert.assertThat((Object)internalId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            InternalIdFooChange foo = element.convert(InternalIdFooChange.class);
            MatcherAssert.assertThat((Object)foo.id(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
        })).get(1L, TimeUnit.SECONDS);
        NamedListNode list2 = (NamedListNode)cfg.polymorphic().value();
        UUID internalId = list2.internalId("a");
        MatcherAssert.assertThat((Object)list2.getInnerNode("a").internalId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
        MatcherAssert.assertThat((Object)((InternalIdPolymorphicView)list2.get("a")).id(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
        MatcherAssert.assertThat((Object)((UUID)((InternalIdPolymorphicConfiguration)cfg.polymorphic().get("a")).id().value()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
        MatcherAssert.assertThat((Object)((InternalIdPolymorphicView)((InternalIdPolymorphicConfiguration)cfg.polymorphic().get("a")).value()).id(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)internalId)));
    }

    @PolymorphicConfigInstance(value="foo")
    public static class InternalIdFooConfigurationSchema
    extends InternalIdPolymorphicConfigurationSchema {
    }

    @PolymorphicConfig
    public static class InternalIdPolymorphicConfigurationSchema {
        @PolymorphicId
        public String type;
        @InternalId
        public UUID id;
    }

    @InternalConfiguration
    public static class InternalIdInternalConfigurationSchema
    extends InternalIdParentConfigurationSchema {
        @InternalId
        public UUID id;
    }

    @ConfigurationRoot(rootName="root", type=ConfigurationType.LOCAL)
    public static class InternalIdParentConfigurationSchema {
        @NamedConfigValue
        public InternalIdPolymorphicConfigurationSchema polymorphic;
    }
}

