/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.tree.ChildView;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedElementView;
import org.apache.ignite.internal.configuration.tree.ParentChange;
import org.apache.ignite.internal.configuration.tree.ParentView;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNodeTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ConstructableTreeNodeTest {
    private static ConfigurationAsmGenerator cgen;

    @BeforeAll
    public static void beforeAll() {
        cgen = new ConfigurationAsmGenerator();
        cgen.compileRootSchema(TraversableTreeNodeTest.ParentConfigurationSchema.class, Map.of(), Map.of());
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    public static <P extends InnerNode> P newParentInstance() {
        return (P)cgen.instantiateNode(TraversableTreeNodeTest.ParentConfigurationSchema.class);
    }

    public static <C extends InnerNode> C newChildInstance() {
        return (C)cgen.instantiateNode(TraversableTreeNodeTest.ChildConfigurationSchema.class);
    }

    @Test
    public void noKey() {
        Object childNode = ConstructableTreeNodeTest.newChildInstance();
        Assertions.assertThrows(NoSuchElementException.class, () -> childNode.construct("foo", null, true));
    }

    @Test
    public void nullSource() {
        Object parentNode = ConstructableTreeNodeTest.newParentInstance();
        ((ParentChange)parentNode).changeChild(child -> child.changeStrCfg("value")).changeElements(elements -> elements.create("name", element -> {}));
        NamedListView<? extends NamedElementView> elements2 = ((ParentView)parentNode).elements();
        parentNode.construct("elements", null, true);
        Assertions.assertNotNull(((ParentView)parentNode).elements());
        Assertions.assertNotSame(elements2, ((ParentView)parentNode).elements());
        Assertions.assertEquals(List.of(), (Object)((ParentView)parentNode).elements().namedListKeys());
        NamedElementView element = (NamedElementView)elements2.get("name");
        ((ConstructableTreeNode)elements2).construct("name", null, true);
        Assertions.assertNull((Object)elements2.get("name"));
        ((ConstructableTreeNode)element).construct("strCfg", null, true);
        Assertions.assertNull((Object)element.strCfg());
    }

    @Test
    public void unwrap() {
        Object childNode = ConstructableTreeNodeTest.newChildInstance();
        childNode.construct("strCfg", (ConfigurationSource)new ConstantConfigurationSource("value"), true);
        Assertions.assertEquals((Object)"value", (Object)((ChildView)childNode).strCfg());
        childNode.construct("intCfg", (ConfigurationSource)new ConstantConfigurationSource(255), true);
        Assertions.assertEquals((int)255, (int)((ChildView)childNode).intCfg());
        Assertions.assertThrows(ClassCastException.class, () -> childNode.construct("intCfg", (ConfigurationSource)new ConstantConfigurationSource(new Object()), true));
    }

    @Test
    public void descend() {
        Object parentNode = ConstructableTreeNodeTest.newParentInstance();
        parentNode.construct("child", new ConfigurationSource(){

            public <T> T unwrap(Class<T> clazz) {
                throw new UnsupportedOperationException("unwrap");
            }

            public void descend(ConstructableTreeNode node) {
                node.construct("strCfg", (ConfigurationSource)new ConstantConfigurationSource("value"), true);
            }
        }, true);
        Assertions.assertEquals((Object)"value", (Object)((ParentView)parentNode).child().strCfg());
        NamedListView<? extends NamedElementView> elementsNode = ((ParentView)parentNode).elements();
        ((ConstructableTreeNode)elementsNode).construct("name", new ConfigurationSource(){

            public <T> T unwrap(Class<T> clazz) {
                throw new UnsupportedOperationException("unwrap");
            }

            public void descend(ConstructableTreeNode node) {
                node.construct("strCfg", (ConfigurationSource)new ConstantConfigurationSource("value"), true);
            }
        }, true);
        Assertions.assertEquals((Object)"value", (Object)((NamedElementView)elementsNode.get("name")).strCfg());
    }

    @Test
    public void constructDefault() {
        Object parentNode = ConstructableTreeNodeTest.newParentInstance();
        Assertions.assertThrows(NoSuchElementException.class, () -> parentNode.constructDefault("child"));
        Assertions.assertThrows(NoSuchElementException.class, () -> parentNode.constructDefault("elements"));
        ((ParentChange)parentNode).changeElements(elements -> elements.create("name", element -> {}));
        NamedElementView elementNode = (NamedElementView)((ParentView)parentNode).elements().get("name");
        ((InnerNode)elementNode).constructDefault("strCfg");
        Assertions.assertNull((Object)elementNode.strCfg());
        ((ParentChange)parentNode).changeChild(child -> {});
        ChildView child2 = ((ParentView)parentNode).child();
        ((InnerNode)child2).constructDefault("strCfg");
        Assertions.assertThrows(NullPointerException.class, () -> child2.intCfg());
        ((InnerNode)child2).constructDefault("intCfg");
        Assertions.assertEquals((int)99, (int)child2.intCfg());
    }

    private static class ConstantConfigurationSource
    implements ConfigurationSource {
        private final Object constant;

        private ConstantConfigurationSource(Object constant) {
            this.constant = constant;
        }

        public <T> T unwrap(Class<T> clazz) {
            return clazz.cast(this.constant);
        }
    }
}

