/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ConfigurationArrayTest {
    private static ConfigurationAsmGenerator cgen = new ConfigurationAsmGenerator();

    @BeforeAll
    public static void beforeAll() {
        cgen.compileRootSchema(TestArrayConfigurationSchema.class, Map.of(), Map.of());
    }

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    static Stream<Class<?>> supportedTypes() {
        return Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, String[].class);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedTypes"})
    public void testChange(Class<?> type) throws Exception {
        InnerNode arrayNode = cgen.instantiateNode(TestArrayConfigurationSchema.class);
        Object initialValue = ConfigurationArrayTest.createTestValue(type);
        ConfigurationArrayTest.changeArray(arrayNode, initialValue);
        MatcherAssert.assertThat(ConfigurationArrayTest.getArray(arrayNode, type), (Matcher)CoreMatchers.is((Object)initialValue));
        MatcherAssert.assertThat(ConfigurationArrayTest.getViewField(arrayNode, type), (Matcher)CoreMatchers.is((Object)initialValue));
        MatcherAssert.assertThat(ConfigurationArrayTest.getArray(arrayNode, type), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)initialValue)));
        MatcherAssert.assertThat(ConfigurationArrayTest.getArray(arrayNode, type), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(ConfigurationArrayTest.getViewField(arrayNode, type))));
        Object newValue = ConfigurationArrayTest.createTestValue(type);
        ConfigurationArrayTest.changeArray(arrayNode, newValue);
        MatcherAssert.assertThat(ConfigurationArrayTest.getArray(arrayNode, type), (Matcher)CoreMatchers.is((Object)newValue));
        MatcherAssert.assertThat(ConfigurationArrayTest.getViewField(arrayNode, type), (Matcher)CoreMatchers.is((Object)newValue));
    }

    private static <T> T getArray(InnerNode arrayNode, Class<T> cls) {
        return cls.cast(arrayNode.traverseChild(ConfigurationArrayTest.getFieldName(cls), ConfigurationUtil.leafNodeVisitor(), true));
    }

    private static <T> T getViewField(InnerNode arrayNode, Class<T> cls) throws Exception {
        String methodName = ConfigurationArrayTest.getFieldName(cls);
        return cls.cast(arrayNode.getClass().getMethod(methodName, new Class[0]).invoke((Object)arrayNode, new Object[0]));
    }

    private static void changeArray(InnerNode arrayNode, Object newValue) throws Exception {
        String fieldName = ConfigurationArrayTest.getFieldName(newValue.getClass());
        String methodName = "change" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        arrayNode.getClass().getMethod(methodName, newValue.getClass()).invoke((Object)arrayNode, newValue);
    }

    private static String getFieldName(Class<?> cls) {
        if (cls == boolean[].class) {
            return "booleanArray";
        }
        if (cls == byte[].class) {
            return "byteArray";
        }
        if (cls == short[].class) {
            return "shortArray";
        }
        if (cls == int[].class) {
            return "intArray";
        }
        if (cls == long[].class) {
            return "longArray";
        }
        if (cls == char[].class) {
            return "charArray";
        }
        if (cls == float[].class) {
            return "floatArray";
        }
        if (cls == double[].class) {
            return "doubleArray";
        }
        if (cls == String[].class) {
            return "stringArray";
        }
        throw new AssertionError((Object)("Invalid field type: " + cls));
    }

    private static Object createTestValue(Class<?> cls) {
        Random random = new Random();
        if (cls == boolean[].class) {
            return new boolean[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean()};
        }
        if (cls == byte[].class) {
            return new byte[]{(byte)random.nextInt(), (byte)random.nextInt(), (byte)random.nextInt()};
        }
        if (cls == short[].class) {
            return new short[]{(short)random.nextInt(), (short)random.nextInt(), (short)random.nextInt()};
        }
        if (cls == int[].class) {
            return new int[]{random.nextInt(), random.nextInt(), random.nextInt()};
        }
        if (cls == long[].class) {
            return new long[]{random.nextLong(), random.nextLong(), random.nextLong()};
        }
        if (cls == char[].class) {
            return new char[]{(char)random.nextInt(), (char)random.nextInt(), (char)random.nextInt()};
        }
        if (cls == float[].class) {
            return new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat()};
        }
        if (cls == double[].class) {
            return new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
        }
        if (cls == String[].class) {
            return new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()};
        }
        throw new AssertionError((Object)("Invalid field type: " + cls));
    }

    @Config
    public static class TestArrayConfigurationSchema {
        @Value
        public boolean[] booleanArray;
        @Value
        public byte[] byteArray;
        @Value
        public short[] shortArray;
        @Value
        public int[] intArray;
        @Value
        public long[] longArray;
        @Value
        public char[] charArray;
        @Value
        public float[] floatArray;
        @Value
        public double[] doubleArray;
        @Value
        public String[] stringArray;
    }
}

