/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.testframework;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListenerHolder;
import org.apache.ignite.internal.configuration.sample.DiscoveryConfiguration;
import org.apache.ignite.internal.configuration.testframework.BasicConfiguration;
import org.apache.ignite.internal.configuration.testframework.ConfigurationExtension;
import org.apache.ignite.internal.configuration.testframework.ExtendedChange;
import org.apache.ignite.internal.configuration.testframework.ExtendedConfiguration;
import org.apache.ignite.internal.configuration.testframework.ExtendedConfigurationSchema;
import org.apache.ignite.internal.configuration.testframework.InjectConfiguration;
import org.apache.ignite.internal.configuration.testframework.InjectRevisionListenerHolder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ConfigurationExtension.class})
class ConfigurationExtensionTest {
    @InjectConfiguration
    private DiscoveryConfiguration fieldCfg;
    @InjectRevisionListenerHolder
    private ConfigurationStorageRevisionListenerHolder fieldRevisionListenerHolder;

    ConfigurationExtensionTest() {
    }

    @Test
    public void injectConfiguration(@InjectConfiguration(value="mock.joinTimeout=100") DiscoveryConfiguration paramCfg) throws Exception {
        Assertions.assertEquals((int)5000, (Integer)((Integer)this.fieldCfg.joinTimeout().value()));
        Assertions.assertEquals((int)100, (Integer)((Integer)paramCfg.joinTimeout().value()));
        paramCfg.change(d -> d.changeJoinTimeout(200)).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)200, (Integer)((Integer)paramCfg.joinTimeout().value()));
        paramCfg.joinTimeout().update((Object)300).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)300, (Integer)((Integer)paramCfg.joinTimeout().value()));
    }

    @Test
    public void notifications() throws Exception {
        ArrayList log = new ArrayList();
        this.fieldCfg.listen(ctx -> {
            log.add("update");
            return CompletableFuture.completedFuture(null);
        });
        this.fieldCfg.joinTimeout().listen(ctx -> {
            log.add("join");
            return CompletableFuture.completedFuture(null);
        });
        this.fieldCfg.failureDetectionTimeout().listen(ctx -> {
            log.add("failure");
            return CompletableFuture.completedFuture(null);
        });
        this.fieldCfg.change(change -> change.changeJoinTimeout(1000000)).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("update", "join"), log);
        log.clear();
        this.fieldCfg.failureDetectionTimeout().update((Object)2000000).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("update", "failure"), log);
    }

    @Test
    public void internalConfiguration(@InjectConfiguration(internalExtensions={ExtendedConfigurationSchema.class}) BasicConfiguration cfg) throws Exception {
        MatcherAssert.assertThat((Object)cfg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExtendedConfiguration.class)));
        Assertions.assertEquals((int)1, (Integer)((Integer)cfg.visible().value()));
        Assertions.assertEquals((int)2, (Integer)((Integer)((ExtendedConfiguration)cfg).invisible().value()));
        cfg.change(change -> {
            MatcherAssert.assertThat((Object)change, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExtendedChange.class)));
            change.changeVisible(3);
            ((ExtendedChange)change).changeInvisible(4);
        }).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)3, (Integer)((Integer)cfg.visible().value()));
        Assertions.assertEquals((int)4, (Integer)((Integer)((ExtendedConfiguration)cfg).invisible().value()));
    }

    @Test
    void testFieldConfigurationStorageRevisionListenerHolder() throws Exception {
        Assertions.assertNotNull((Object)this.fieldRevisionListenerHolder);
        CopyOnWriteArrayList revisions = new CopyOnWriteArrayList();
        this.fieldRevisionListenerHolder.listenUpdateStorageRevision(revision -> {
            revisions.add(revision);
            return CompletableFuture.completedFuture(null);
        });
        this.fieldCfg.joinTimeout().update((Object)1000000).get(1L, TimeUnit.SECONDS);
        this.fieldCfg.joinTimeout().update((Object)2000000).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)revisions.size(), revisions::toString);
        Assertions.assertTrue(((Long)revisions.get(0) < (Long)revisions.get(1) ? 1 : 0) != 0, revisions::toString);
    }

    @Test
    void testParamConfigurationStorageRevisionListenerHolder(@InjectConfiguration(value="mock.joinTimeout=100") DiscoveryConfiguration paramCfg, @InjectRevisionListenerHolder ConfigurationStorageRevisionListenerHolder paramRevisionListenerHolder) throws Exception {
        Assertions.assertNotNull((Object)paramRevisionListenerHolder);
        Assertions.assertSame((Object)this.fieldRevisionListenerHolder, (Object)paramRevisionListenerHolder);
        CopyOnWriteArrayList revisions = new CopyOnWriteArrayList();
        paramRevisionListenerHolder.listenUpdateStorageRevision(revision -> {
            revisions.add(revision);
            return CompletableFuture.completedFuture(null);
        });
        paramCfg.joinTimeout().update((Object)1000000).get(1L, TimeUnit.SECONDS);
        paramCfg.joinTimeout().update((Object)2000000).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)revisions.size(), revisions::toString);
        Assertions.assertTrue(((Long)revisions.get(0) < (Long)revisions.get(1) ? 1 : 0) != 0, revisions::toString);
    }
}

