/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.testframework;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.ConfigurationListenerHolder;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotifier;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListener;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListenerHolder;
import org.apache.ignite.internal.configuration.testframework.InjectConfiguration;
import org.apache.ignite.internal.configuration.testframework.InjectRevisionListenerHolder;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.mockito.Mockito;

public class ConfigurationExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ConfigurationExtension.class});
    private static final Object CGEN_KEY = new Object();
    private static final Object POOL_KEY = new Object();
    private static final Object REVISION_LISTENER_HOLDER_KEY = new Object();

    public void beforeAll(ExtensionContext context) throws Exception {
        context.getStore(NAMESPACE).put(POOL_KEY, (Object)Executors.newSingleThreadExecutor());
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ExecutorService pool = (ExecutorService)context.getStore(NAMESPACE).remove(POOL_KEY, ExecutorService.class);
        pool.shutdownNow();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ConfigurationAsmGenerator cgen = new ConfigurationAsmGenerator();
        context.getStore(NAMESPACE).put(CGEN_KEY, (Object)cgen);
        Object testInstance = context.getRequiredTestInstance();
        ExecutorService pool = (ExecutorService)context.getStore(NAMESPACE).get(POOL_KEY, ExecutorService.class);
        StorageRevisionListenerHolderImpl revisionListenerHolder = new StorageRevisionListenerHolderImpl();
        context.getStore(NAMESPACE).put(REVISION_LISTENER_HOLDER_KEY, (Object)revisionListenerHolder);
        for (Field field : ConfigurationExtension.getInjectConfigurationFields(testInstance.getClass())) {
            field.setAccessible(true);
            InjectConfiguration annotation = field.getAnnotation(InjectConfiguration.class);
            field.set(testInstance, ConfigurationExtension.cfgValue(field.getType(), annotation, cgen, pool, revisionListenerHolder));
        }
        for (Field field : ConfigurationExtension.getInjectRevisionListenerHolderFields(testInstance.getClass())) {
            field.setAccessible(true);
            field.set(testInstance, revisionListenerHolder);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        context.getStore(NAMESPACE).remove(CGEN_KEY);
        context.getStore(NAMESPACE).remove(REVISION_LISTENER_HOLDER_KEY);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return parameterContext.isAnnotated(InjectConfiguration.class) && ConfigurationExtension.supportsAsConfigurationType(parameterType) || parameterContext.isAnnotated(InjectRevisionListenerHolder.class) && ConfigurationExtension.isRevisionListenerHolder(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(InjectConfiguration.class)) {
            Parameter parameter = parameterContext.getParameter();
            ConfigurationAsmGenerator cgen = (ConfigurationAsmGenerator)extensionContext.getStore(NAMESPACE).get(CGEN_KEY, ConfigurationAsmGenerator.class);
            StorageRevisionListenerHolderImpl revisionListenerHolder = (StorageRevisionListenerHolderImpl)extensionContext.getStore(NAMESPACE).get(REVISION_LISTENER_HOLDER_KEY, StorageRevisionListenerHolderImpl.class);
            try {
                ExecutorService pool = (ExecutorService)extensionContext.getStore(NAMESPACE).get(POOL_KEY, ExecutorService.class);
                return ConfigurationExtension.cfgValue(parameter.getType(), parameter.getAnnotation(InjectConfiguration.class), cgen, pool, revisionListenerHolder);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParameterResolutionException("Cannot find a configuration schema class that matches " + parameter.getType().getCanonicalName(), (Throwable)classNotFoundException);
            }
        }
        if (parameterContext.isAnnotated(InjectRevisionListenerHolder.class)) {
            return extensionContext.getStore(NAMESPACE).get(REVISION_LISTENER_HOLDER_KEY, StorageRevisionListenerHolderImpl.class);
        }
        throw new ParameterResolutionException("Unknown parametr:" + parameterContext.getParameter());
    }

    private static Object cfgValue(Class<?> type, InjectConfiguration annotation, ConfigurationAsmGenerator cgen, final ExecutorService pool, final StorageRevisionListenerHolderImpl revisionListenerHolder) throws ClassNotFoundException {
        Class<?> schemaClass = Class.forName(type.getCanonicalName() + "Schema");
        cgen.compileRootSchema(schemaClass, ConfigurationUtil.internalSchemaExtensions(List.of(annotation.internalExtensions())), ConfigurationUtil.polymorphicSchemaExtensions(List.of(annotation.polymorphicExtensions())));
        final RootKey rootKey = (RootKey)Mockito.mock(RootKey.class);
        Mockito.when((Object)rootKey.key()).thenReturn((Object)"mock");
        Mockito.when((Object)rootKey.type()).thenReturn((Object)ConfigurationType.LOCAL);
        Mockito.when((Object)rootKey.schemaClass()).thenReturn(schemaClass);
        Mockito.when((Object)rootKey.internal()).thenReturn((Object)false);
        SuperRoot superRoot = new SuperRoot(s -> new RootInnerNode(rootKey, cgen.instantiateNode(schemaClass)));
        ConfigObject hoconCfg = ConfigFactory.parseString((String)annotation.value()).root();
        HoconConverter.hoconSource((ConfigObject)hoconCfg).descend((ConstructableTreeNode)superRoot);
        ConfigurationUtil.addDefaults((InnerNode)superRoot);
        if (!annotation.name().isEmpty()) {
            superRoot.getRoot(rootKey).setInjectedNameFieldValue(annotation.name());
        }
        final AtomicReference<SuperRoot> superRootRef = new AtomicReference<SuperRoot>(superRoot);
        final AtomicReference<DynamicConfiguration> cfgRef = new AtomicReference<DynamicConfiguration>();
        cfgRef.set(cgen.instantiateCfg(rootKey, new DynamicConfigurationChanger(){

            public CompletableFuture<Void> change(ConfigurationSource change) {
                return CompletableFuture.supplyAsync(() -> {
                    SuperRoot sr = (SuperRoot)superRootRef.get();
                    SuperRoot copy = sr.copy();
                    change.descend((ConstructableTreeNode)copy);
                    ConfigurationUtil.dropNulls((InnerNode)copy);
                    if (superRootRef.compareAndSet(sr, copy)) {
                        long storageRevision = revisionListenerHolder2.storageRev.incrementAndGet();
                        long notificationNumber = revisionListenerHolder2.notificationListenerCnt.incrementAndGet();
                        ArrayList futures = new ArrayList();
                        futures.addAll(ConfigurationNotifier.notifyListeners((InnerNode)sr.getRoot(rootKey), (InnerNode)copy.getRoot(rootKey), (DynamicConfiguration)((DynamicConfiguration)cfgRef.get()), (long)storageRevision, (long)notificationNumber));
                        futures.addAll(revisionListenerHolder.notifyStorageRevisionListeners(storageRevision, notificationNumber));
                        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
                    }
                    return this.change(change);
                }, pool).thenCompose(Function.identity());
            }

            public InnerNode getRootNode(RootKey<?, ?> rk) {
                return ((SuperRoot)superRootRef.get()).getRoot(rk);
            }

            public <T> T getLatest(List<KeyPathNode> path) {
                return (T)ConfigurationUtil.findEx(path, (InnerNode)((InnerNode)superRootRef.get()));
            }

            public long notificationCount() {
                return revisionListenerHolder.notificationListenerCnt.get();
            }
        }));
        ConfigurationUtil.touch((DynamicConfiguration)((DynamicConfiguration)cfgRef.get()));
        return cfgRef.get();
    }

    private static List<Field> getInjectConfigurationFields(Class<?> testClass) {
        return AnnotationSupport.findAnnotatedFields(testClass, InjectConfiguration.class, field -> ConfigurationExtension.supportsAsConfigurationType(field.getType()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
    }

    private static List<Field> getInjectRevisionListenerHolderFields(Class<?> testClass) {
        return AnnotationSupport.findAnnotatedFields(testClass, InjectRevisionListenerHolder.class, field -> ConfigurationExtension.isRevisionListenerHolder(field.getType()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
    }

    private static boolean supportsAsConfigurationType(Class<?> type) {
        return type.getCanonicalName().endsWith("Configuration");
    }

    private static boolean isRevisionListenerHolder(Class<?> type) {
        return ConfigurationStorageRevisionListenerHolder.class.isAssignableFrom(type);
    }

    private static class StorageRevisionListenerHolderImpl
    implements ConfigurationStorageRevisionListenerHolder {
        final AtomicLong storageRev = new AtomicLong();
        final AtomicLong notificationListenerCnt = new AtomicLong();
        final ConfigurationListenerHolder<ConfigurationStorageRevisionListener> listeners = new ConfigurationListenerHolder();

        private StorageRevisionListenerHolderImpl() {
        }

        public void listenUpdateStorageRevision(ConfigurationStorageRevisionListener listener) {
            this.listeners.addListener((Object)listener, this.notificationListenerCnt.get());
        }

        public void stopListenUpdateStorageRevision(ConfigurationStorageRevisionListener listener) {
            this.listeners.removeListener((Object)listener);
        }

        private Collection<CompletableFuture<?>> notifyStorageRevisionListeners(long storageRevision, long notificationNumber) {
            ArrayList futures = new ArrayList();
            Iterator it = this.listeners.listeners(notificationNumber);
            while (it.hasNext()) {
                ConfigurationStorageRevisionListener listener = (ConfigurationStorageRevisionListener)it.next();
                try {
                    CompletableFuture future = listener.onUpdate(storageRevision);
                    assert (future != null);
                    if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                    futures.add(future);
                }
                catch (Throwable t) {
                    futures.add(CompletableFuture.failedFuture(t));
                }
            }
            return futures;
        }
    }
}

