/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.jetbrains.annotations.NotNull;

public class TestConfigurationStorage
implements ConfigurationStorage {
    private final ConfigurationType configurationType;
    private final Map<String, Serializable> map = new HashMap<String, Serializable>();
    private final Collection<ConfigurationStorageListener> listeners = new ArrayList<ConfigurationStorageListener>();
    private long version = 0L;
    private boolean fail = false;

    public TestConfigurationStorage(ConfigurationType type) {
        this.configurationType = type;
    }

    public void close() throws Exception {
    }

    public synchronized void fail(boolean fail) {
        this.fail = fail;
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        return CompletableFuture.supplyAsync(() -> {
            TestConfigurationStorage testConfigurationStorage = this;
            synchronized (testConfigurationStorage) {
                if (this.fail) {
                    throw new StorageException("Failed to read data");
                }
                return this.map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        });
    }

    public CompletableFuture<Serializable> readLatest(String key) throws StorageException {
        return CompletableFuture.supplyAsync(() -> {
            TestConfigurationStorage testConfigurationStorage = this;
            synchronized (testConfigurationStorage) {
                if (this.fail) {
                    throw new StorageException("Failed to read data");
                }
                return this.map.get(key);
            }
        });
    }

    public CompletableFuture<Data> readAll() {
        return CompletableFuture.supplyAsync(() -> {
            TestConfigurationStorage testConfigurationStorage = this;
            synchronized (testConfigurationStorage) {
                if (this.fail) {
                    throw new StorageException("Failed to read data");
                }
                return new Data(new HashMap<String, Serializable>(this.map), this.version);
            }
        });
    }

    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long sentVersion) {
        return CompletableFuture.supplyAsync(() -> {
            TestConfigurationStorage testConfigurationStorage = this;
            synchronized (testConfigurationStorage) {
                if (this.fail) {
                    throw new StorageException("Failed to write data");
                }
                if (sentVersion != this.version) {
                    return false;
                }
                for (Map.Entry entry : newValues.entrySet()) {
                    if (entry.getValue() != null) {
                        this.map.put((String)entry.getKey(), (Serializable)entry.getValue());
                        continue;
                    }
                    this.map.remove(entry.getKey());
                }
                ++this.version;
                Data data = new Data(newValues, this.version);
                this.listeners.forEach(listener -> listener.onEntriesChanged(data).join());
                return true;
            }
        });
    }

    public synchronized void registerConfigurationListener(@NotNull ConfigurationStorageListener listener) {
        this.listeners.add(listener);
    }

    public ConfigurationType type() {
        return this.configurationType;
    }

    public synchronized CompletableFuture<Long> lastRevision() {
        return CompletableFuture.completedFuture(this.version);
    }

    public synchronized long incrementAndGetRevision() {
        return ++this.version;
    }

    public synchronized long decrementAndGetRevision() {
        return --this.version;
    }
}

