/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.sample;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.sample.AutoAdjustView;
import org.apache.ignite.internal.configuration.sample.BaselineView;
import org.apache.ignite.internal.configuration.sample.LocalConfiguration;
import org.apache.ignite.internal.configuration.sample.LocalView;
import org.apache.ignite.internal.configuration.sample.NetworkConfiguration;
import org.apache.ignite.internal.configuration.sample.NodeConfiguration;
import org.apache.ignite.internal.configuration.sample.NodeView;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UsageTest {
    private ConfigurationRegistry registry;

    @AfterEach
    public void after() throws Exception {
        this.registry.stop();
    }

    @Test
    public void test() throws Exception {
        this.registry = new ConfigurationRegistry(List.of(LocalConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of());
        this.registry.start();
        this.registry.initializeDefaults();
        LocalConfiguration root = (LocalConfiguration)this.registry.getConfiguration(LocalConfiguration.KEY);
        root.change(local -> local.changeBaseline(baseline -> baseline.changeNodes(nodes -> nodes.create("node1", node -> node.changeConsistentId("test").changePort(1000))).changeAutoAdjust(autoAdjust -> autoAdjust.changeEnabled(true).changeTimeout(100000L)))).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)((Boolean)root.baseline().autoAdjust().enabled().value()));
        root.baseline().autoAdjust().enabled().update((Object)false).get(1L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)((LocalView)root.value()).baseline().autoAdjust().enabled());
        Assertions.assertFalse((boolean)((BaselineView)root.baseline().value()).autoAdjust().enabled());
        Assertions.assertFalse((boolean)((AutoAdjustView)root.baseline().autoAdjust().value()).enabled());
        Assertions.assertFalse((boolean)((Boolean)root.baseline().autoAdjust().enabled().value()));
        ((NodeConfiguration)root.baseline().nodes().get("node1")).autoAdjustEnabled().update((Object)true).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)((NodeView)((LocalView)root.value()).baseline().nodes().get("node1")).autoAdjustEnabled());
        Assertions.assertTrue((boolean)((NodeView)((BaselineView)root.baseline().value()).nodes().get("node1")).autoAdjustEnabled());
        Assertions.assertTrue((boolean)((NodeView)((NamedListView)root.baseline().nodes().value()).get("node1")).autoAdjustEnabled());
        Assertions.assertTrue((boolean)((NodeView)((NodeConfiguration)root.baseline().nodes().get("node1")).value()).autoAdjustEnabled());
        Assertions.assertTrue((boolean)((Boolean)((NodeConfiguration)root.baseline().nodes().get("node1")).autoAdjustEnabled().value()));
        ((NodeConfiguration)root.baseline().nodes().get("node1")).change(node -> node.changeAutoAdjustEnabled(false)).get(1L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)((NodeView)((LocalView)root.value()).baseline().nodes().get("node1")).autoAdjustEnabled());
        root.baseline().nodes().change(nodes -> nodes.delete("node1")).get(1L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)root.baseline().nodes().get("node1"));
        Assertions.assertNull((Object)((LocalView)root.value()).baseline().nodes().get("node1"));
    }

    @Test
    public void multiRootConfiguration() throws Exception {
        int failureDetectionTimeout = 30000;
        int joinTimeout = 10000;
        long autoAdjustTimeout = 30000L;
        this.registry = new ConfigurationRegistry(List.of(NetworkConfiguration.KEY, LocalConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of());
        this.registry.start();
        ((LocalConfiguration)this.registry.getConfiguration(LocalConfiguration.KEY)).change(local -> local.changeBaseline(baseline -> baseline.changeAutoAdjust(autoAdjust -> autoAdjust.changeEnabled(true).changeTimeout(autoAdjustTimeout)))).get(1L, TimeUnit.SECONDS);
        ((NetworkConfiguration)this.registry.getConfiguration(NetworkConfiguration.KEY)).change(network -> network.changeDiscovery(discovery -> discovery.changeFailureDetectionTimeout(30000).changeJoinTimeout(10000))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)30000, (Integer)((Integer)((NetworkConfiguration)this.registry.getConfiguration(NetworkConfiguration.KEY)).discovery().failureDetectionTimeout().value()));
        Assertions.assertEquals((long)autoAdjustTimeout, (Long)((Long)((LocalConfiguration)this.registry.getConfiguration(LocalConfiguration.KEY)).baseline().autoAdjust().timeout().value()));
    }
}

