/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.rest.presentation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.rest.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.rest.presentation.TestRootConfiguration;
import org.apache.ignite.internal.configuration.rest.presentation.hocon.HoconPresentation;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.testframework.matchers.CompletableFutureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationPresentationTest {
    private static ConfigurationRegistry cfgRegistry;
    private static ConfigurationPresentation<String> cfgPresentation;
    private static TestRootConfiguration cfg;

    @BeforeAll
    static void beforeAll() {
        Validator<Value, Object> validator = new Validator<Value, Object>(){

            public void validate(Value annotation, ValidationContext<Object> ctx) {
                if (Objects.equals("error", ctx.getNewValue())) {
                    ctx.addIssue(new ValidationIssue("Error word"));
                }
            }
        };
        cfgRegistry = new ConfigurationRegistry(List.of(TestRootConfiguration.KEY), Map.of(Value.class, Set.of(validator)), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of());
        cfgRegistry.start();
        cfgPresentation = new HoconPresentation(cfgRegistry);
        cfg = (TestRootConfiguration)cfgRegistry.getConfiguration(TestRootConfiguration.KEY);
    }

    @AfterAll
    static void afterAll() throws Exception {
        cfgRegistry.stop();
        cfgRegistry = null;
        cfgPresentation = null;
        cfg = null;
    }

    @BeforeEach
    void beforeEach() throws Exception {
        ConfigurationPresentationTest.cfg.change(cfg -> cfg.changeFoo("foo").changeSubCfg(subCfg -> subCfg.changeBar("bar"))).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testRepresentWholeCfg() {
        String s = "{\"root\":{\"foo\":\"foo\",\"subCfg\":{\"bar\":\"bar\"}}}";
        Assertions.assertEquals((Object)s, (Object)cfgPresentation.represent());
        Assertions.assertEquals((Object)s, (Object)cfgPresentation.representByPath(null));
    }

    @Test
    void testCorrectRepresentCfgByPath() {
        Assertions.assertEquals((Object)"{\"foo\":\"foo\",\"subCfg\":{\"bar\":\"bar\"}}", (Object)cfgPresentation.representByPath("root"));
        Assertions.assertEquals((Object)"\"foo\"", (Object)cfgPresentation.representByPath("root.foo"));
        Assertions.assertEquals((Object)"{\"bar\":\"bar\"}", (Object)cfgPresentation.representByPath("root.subCfg"));
        Assertions.assertEquals((Object)"\"bar\"", (Object)cfgPresentation.representByPath("root.subCfg.bar"));
    }

    @Test
    void testErrorRepresentCfgByPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> cfgPresentation.representByPath(UUID.randomUUID().toString()));
    }

    @Test
    void testCorrectUpdateFullCfg() {
        String updateVal = "{\"root\":{\"foo\":\"bar\",\"subCfg\":{\"bar\":\"foo\"}}}";
        MatcherAssert.assertThat((Object)cfgPresentation.update((Object)updateVal), (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.nullValue(Void.class)));
        Assertions.assertEquals((Object)"bar", (Object)cfg.foo().value());
        Assertions.assertEquals((Object)"foo", (Object)cfg.subCfg().bar().value());
        Assertions.assertEquals((Object)updateVal, (Object)cfgPresentation.represent());
    }

    @Test
    void testCorrectUpdateSubCfg() {
        String updateVal = "{\"root\":{\"subCfg\":{\"bar\":\"foo\"}}}";
        MatcherAssert.assertThat((Object)cfgPresentation.update((Object)updateVal), (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.nullValue(Void.class)));
        Assertions.assertEquals((Object)"foo", (Object)cfg.foo().value());
        Assertions.assertEquals((Object)"foo", (Object)cfg.subCfg().bar().value());
        Assertions.assertEquals((Object)"{\"root\":{\"foo\":\"foo\",\"subCfg\":{\"bar\":\"foo\"}}}", (Object)cfgPresentation.represent());
    }

    @Test
    void testErrorUpdateCfg() {
        ConfigurationPresentationTest.assertFutureThrows(IllegalArgumentException.class, cfgPresentation.update((Object)"{\"root\":{\"foo\":100,\"subCfg\":{\"bar\":\"foo\"}}}"));
        ConfigurationPresentationTest.assertFutureThrows(IllegalArgumentException.class, cfgPresentation.update((Object)"{\"root0\":{\"foo\":\"foo\",\"subCfg\":{\"bar\":\"foo\"}}}"));
        ConfigurationPresentationTest.assertFutureThrows(IllegalArgumentException.class, cfgPresentation.update((Object)"{"));
        ConfigurationPresentationTest.assertFutureThrows(IllegalArgumentException.class, cfgPresentation.update((Object)""));
        ConfigurationPresentationTest.assertFutureThrows(ConfigurationValidationException.class, cfgPresentation.update((Object)"{\"root\":{\"foo\":\"error\",\"subCfg\":{\"bar\":\"foo\"}}}"));
    }

    private static void assertFutureThrows(Class<?> expectedType, CompletableFuture<?> future) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(1L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.isA(expectedType));
    }

    @Config
    public static class TestSubConfigurationSchema {
        @Value(hasDefault=true)
        public String bar = "bar";
    }

    @ConfigurationRoot(rootName="root")
    public static class TestRootConfigurationSchema {
        @Value(hasDefault=true)
        public String foo = "foo";
        @ConfigValue
        public TestSubConfigurationSchema subCfg;
    }
}

