/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListener;
import org.junit.jupiter.api.Assertions;

class ConfigurationListenerTestUtils {
    private ConfigurationListenerTestUtils() {
    }

    static <T> Consumer<T> doNothingConsumer() {
        return t -> {};
    }

    static <T> ConfigurationListener<T> configListener(Consumer<ConfigurationNotificationEvent<T>> consumer) {
        return ctx -> {
            try {
                consumer.accept(ctx);
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
            return CompletableFuture.completedFuture(null);
        };
    }

    static void checkContainsListeners(Supplier<CompletableFuture<Void>> changeFun, List<String> events, List<String> expContains, List<String> expNotContains) throws Exception {
        events.clear();
        changeFun.get().get(1L, TimeUnit.SECONDS);
        for (String exp : expContains) {
            Assertions.assertTrue((boolean)events.contains(exp), () -> exp + " not contains in " + events);
        }
        for (String exp : expNotContains) {
            Assertions.assertFalse((boolean)events.contains(exp), () -> exp + " contains in " + events);
        }
    }

    static void checkEqualsListeners(Supplier<CompletableFuture<Void>> changeFun, List<String> exp, List<String> act) throws Exception {
        act.clear();
        changeFun.get().get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(exp, act);
    }

    static <T> ConfigurationNamedListListener<T> configNamedListenerOnDelete(final Consumer<ConfigurationNotificationEvent<T>> consumer) {
        return new ConfigurationNamedListListener<T>(){

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<T> ctx) {
                try {
                    consumer.accept(ctx);
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    static <T> ConfigurationNamedListListener<T> configNamedListenerOnRename(final Consumer<ConfigurationNotificationEvent<T>> consumer) {
        return new ConfigurationNamedListListener<T>(){

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<T> ctx) {
                try {
                    consumer.accept(ctx);
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    static <T> ConfigurationNamedListListener<T> configNamedListenerOnCreate(final Consumer<ConfigurationNotificationEvent<T>> consumer) {
        return new ConfigurationNamedListListener<T>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<T> ctx) {
                try {
                    consumer.accept(ctx);
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    static <T> ConfigurationNamedListListener<T> configNamedListenerOnUpdate(final Consumer<ConfigurationNotificationEvent<T>> consumer) {
        return new ConfigurationNamedListListener<T>(){

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<T> ctx) {
                try {
                    consumer.accept(ctx);
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    static ConfigurationStorageRevisionListener configStorageRevisionListener(LongConsumer consumer) {
        return newStorageRevision -> {
            consumer.accept(newStorageRevision);
            return CompletableFuture.completedFuture(null);
        };
    }

    static String randomUuid() {
        return UUID.randomUUID().toString();
    }
}

