/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.notifications.ChildConfiguration;
import org.apache.ignite.internal.configuration.notifications.ChildView;
import org.apache.ignite.internal.configuration.notifications.ConfigurationListenerTestUtils;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotifier;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListener;
import org.apache.ignite.internal.configuration.notifications.InternalChildConfiguration;
import org.apache.ignite.internal.configuration.notifications.InternalChildView;
import org.apache.ignite.internal.configuration.notifications.LongPolyChange;
import org.apache.ignite.internal.configuration.notifications.LongPolyConfiguration;
import org.apache.ignite.internal.configuration.notifications.LongPolyView;
import org.apache.ignite.internal.configuration.notifications.ParentConfiguration;
import org.apache.ignite.internal.configuration.notifications.ParentView;
import org.apache.ignite.internal.configuration.notifications.PolyConfiguration;
import org.apache.ignite.internal.configuration.notifications.PolyView;
import org.apache.ignite.internal.configuration.notifications.StringPolyChange;
import org.apache.ignite.internal.configuration.notifications.StringPolyConfiguration;
import org.apache.ignite.internal.configuration.notifications.StringPolyView;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.testframework.IgniteTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationListenerTest {
    private ConfigurationStorage storage;
    private ConfigurationRegistry registry;
    private ParentConfiguration config;

    @BeforeEach
    public void before() {
        this.storage = new TestConfigurationStorage(ConfigurationType.LOCAL);
        this.registry = new ConfigurationRegistry(List.of(ParentConfiguration.KEY), Map.of(), this.storage, List.of(InternalChildConfigurationSchema.class), List.of(StringPolyConfigurationSchema.class, LongPolyConfigurationSchema.class));
        this.registry.start();
        this.registry.initializeDefaults();
        this.config = (ParentConfiguration)this.registry.getConfiguration(ParentConfiguration.KEY);
    }

    @AfterEach
    public void after() throws Exception {
        this.registry.stop();
    }

    @Test
    public void childNode() throws Exception {
        ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            Assertions.assertEquals((Object)((ParentView)ctx.oldValue()).child().str(), (Object)"default");
            Assertions.assertEquals((Object)((ParentView)ctx.newValue()).child().str(), (Object)"foo");
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            Assertions.assertEquals((Object)((ChildView)ctx.oldValue()).str(), (Object)"default");
            Assertions.assertEquals((Object)((ChildView)ctx.newValue()).str(), (Object)"foo");
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().str().listen(ctx -> {
            Assertions.assertEquals((Object)ctx.oldValue(), (Object)"default");
            Assertions.assertEquals((Object)ctx.newValue(), (Object)"foo");
            log.add("str");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.change(parent -> parent.changeChild(child -> child.changeStr("foo"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "child", "str"), log);
    }

    @Test
    public void namedListNodeOnCreate() throws Exception {
        final ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            Assertions.assertEquals((int)0, (int)((NamedListView)ctx.oldValue()).size());
            ChildView newValue = (ChildView)((NamedListView)ctx.newValue()).get("name");
            Assertions.assertNotNull((Object)newValue);
            Assertions.assertEquals((Object)"default", (Object)newValue.str());
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertNull((Object)ctx.oldValue());
                ChildView newValue = (ChildView)ctx.newValue();
                Assertions.assertNotNull((Object)newValue);
                Assertions.assertEquals((Object)"default", (Object)newValue.str());
                log.add("create");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("update");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("rename");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("delete");
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", element -> {}))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "elements", "create"), log);
    }

    @Test
    public void namedListNodeOnUpdate() throws Exception {
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", element -> {}))).get(1L, TimeUnit.SECONDS);
        final ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            ChildView oldValue = (ChildView)((NamedListView)ctx.oldValue()).get("name");
            Assertions.assertNotNull((Object)oldValue);
            Assertions.assertEquals((Object)"default", (Object)oldValue.str());
            ChildView newValue = (ChildView)((NamedListView)ctx.newValue()).get("name");
            Assertions.assertNotNull((Object)newValue);
            Assertions.assertEquals((Object)"foo", (Object)newValue.str());
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("create");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                ChildView oldValue = (ChildView)ctx.oldValue();
                Assertions.assertNotNull((Object)oldValue);
                Assertions.assertEquals((Object)"default", (Object)oldValue.str());
                ChildView newValue = (ChildView)ctx.newValue();
                Assertions.assertNotNull((Object)newValue);
                Assertions.assertEquals((Object)"foo", (Object)newValue.str());
                log.add("update");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("rename");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("delete");
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.change(parent -> parent.changeChildren(elements -> elements.createOrUpdate("name", element -> element.changeStr("foo")))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "elements", "update"), log);
    }

    @Test
    public void namedListNodeOnRename() throws Exception {
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", element -> {}))).get(1L, TimeUnit.SECONDS);
        final ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            Assertions.assertEquals((int)1, (int)((NamedListView)ctx.oldValue()).size());
            ChildView oldValue = (ChildView)((NamedListView)ctx.oldValue()).get("name");
            Assertions.assertNotNull((Object)oldValue);
            Assertions.assertEquals((Object)"default", (Object)oldValue.str());
            Assertions.assertEquals((int)1, (int)((NamedListView)ctx.newValue()).size());
            ChildView newValue = (ChildView)((NamedListView)ctx.newValue()).get("newName");
            Assertions.assertNotSame((Object)oldValue, (Object)newValue);
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("create");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("update");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertEquals((Object)"name", (Object)oldName);
                Assertions.assertEquals((Object)"newName", (Object)newName);
                ChildView oldValue = (ChildView)ctx.oldValue();
                Assertions.assertNotNull((Object)oldValue);
                Assertions.assertEquals((Object)"default", (Object)oldValue.str());
                ChildView newValue = (ChildView)ctx.newValue();
                Assertions.assertNotSame((Object)oldValue, (Object)newValue);
                log.add("rename");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("delete");
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.change(parent -> parent.changeChildren(elements -> elements.rename("name", "newName"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "elements", "rename"), log);
    }

    @Test
    public void namedListNodeOnRenameAndUpdate() throws Exception {
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", element -> {}))).get(1L, TimeUnit.SECONDS);
        final ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            Assertions.assertEquals((int)1, (int)((NamedListView)ctx.oldValue()).size());
            ChildView oldValue = (ChildView)((NamedListView)ctx.oldValue()).get("name");
            Assertions.assertNotNull((Object)oldValue);
            Assertions.assertEquals((Object)"default", (Object)oldValue.str());
            Assertions.assertEquals((int)1, (int)((NamedListView)ctx.newValue()).size());
            ChildView newValue = (ChildView)((NamedListView)ctx.newValue()).get("newName");
            Assertions.assertNotNull((Object)newValue, (String)((NamedListView)ctx.newValue()).namedListKeys().toString());
            Assertions.assertEquals((Object)"foo", (Object)newValue.str());
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("create");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("update");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertEquals((Object)"name", (Object)oldName);
                Assertions.assertEquals((Object)"newName", (Object)newName);
                ChildView oldValue = (ChildView)ctx.oldValue();
                Assertions.assertNotNull((Object)oldValue);
                Assertions.assertEquals((Object)"default", (Object)oldValue.str());
                ChildView newValue = (ChildView)ctx.newValue();
                Assertions.assertNotNull((Object)newValue);
                Assertions.assertEquals((Object)"foo", (Object)newValue.str());
                log.add("rename");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("delete");
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.change(parent -> parent.changeChildren(elements -> elements.rename("name", "newName").createOrUpdate("newName", element -> element.changeStr("foo")))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "elements", "rename"), log);
    }

    @Test
    public void namedListNodeOnDelete() throws Exception {
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", element -> {}))).get(1L, TimeUnit.SECONDS);
        final ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            log.add("parent");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().listen(ctx -> {
            log.add("child");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listen(ctx -> {
            Assertions.assertEquals((int)0, (int)((NamedListView)ctx.newValue()).size());
            ChildView oldValue = (ChildView)((NamedListView)ctx.oldValue()).get("name");
            Assertions.assertNotNull((Object)oldValue);
            Assertions.assertEquals((Object)"default", (Object)oldValue.str());
            log.add("elements");
            return CompletableFuture.completedFuture(null);
        });
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("create");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("update");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                log.add("rename");
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertNull((Object)ctx.newValue());
                ChildView oldValue = (ChildView)ctx.oldValue();
                Assertions.assertNotNull((Object)oldValue);
                Assertions.assertEquals((Object)"default", (Object)oldValue.str());
                log.add("delete");
                return CompletableFuture.completedFuture(null);
            }
        });
        ((ChildConfiguration)this.config.children().get("name")).listen(ctx -> CompletableFuture.completedFuture(null));
        this.config.change(parent -> parent.changeChildren(elements -> elements.delete("name"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("parent", "elements", "delete"), log);
    }

    @Test
    public void dataRace() throws Exception {
        this.config.change(parent -> parent.changeChildren(elements -> elements.create("name", e -> {}))).get(1L, TimeUnit.SECONDS);
        CountDownLatch wait = new CountDownLatch(1);
        CountDownLatch release = new CountDownLatch(1);
        ArrayList log = new ArrayList();
        this.config.listen(ctx -> {
            try {
                wait.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.getMessage());
            }
            release.countDown();
            return CompletableFuture.completedFuture(null);
        });
        ((ChildConfiguration)this.config.children().get("name")).listen(ctx -> {
            Assertions.assertNull((Object)ctx.newValue());
            log.add("deleted");
            return CompletableFuture.completedFuture(null);
        });
        CompletableFuture fut = this.config.change(parent -> parent.changeChildren(elements -> elements.delete("name")));
        wait.countDown();
        this.config.children();
        release.await(1L, TimeUnit.SECONDS);
        fut.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("deleted"), log);
    }

    @Test
    void testStopListen() throws Exception {
        ArrayList<String> events = new ArrayList<String>();
        ConfigurationListener listener0 = ConfigurationListenerTestUtils.configListener(ctx -> events.add("0"));
        ConfigurationListener listener1 = ConfigurationListenerTestUtils.configListener(ctx -> events.add("1"));
        ConfigurationNamedListListener listener2 = ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> events.add("2"));
        ConfigurationNamedListListener listener3 = ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> events.add("3"));
        this.config.listen(listener0);
        this.config.listen(listener1);
        this.config.children().listenElements(listener2);
        this.config.children().listenElements(listener3);
        this.config.children().change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        ConfigurationListenerTestUtils.checkContainsListeners(() -> ((ChildConfiguration)this.config.children().get("0")).str().update((Object)ConfigurationListenerTestUtils.randomUuid()), events, List.of("0", "1", "2", "3"), List.of());
        this.config.stopListen(listener0);
        this.config.children().stopListenElements(listener2);
        ConfigurationListenerTestUtils.checkContainsListeners(() -> ((ChildConfiguration)this.config.children().get("0")).str().update((Object)ConfigurationListenerTestUtils.randomUuid()), events, List.of("1", "3"), List.of("0", "2"));
        this.config.stopListen(listener1);
        this.config.children().stopListenElements(listener3);
        ConfigurationListenerTestUtils.checkContainsListeners(() -> ((ChildConfiguration)this.config.children().get("0")).str().update((Object)ConfigurationListenerTestUtils.randomUuid()), events, List.of(), List.of("0", "1", "2", "3"));
    }

    @Test
    void testGetConfigFromNotificationEvent() throws Exception {
        String newVal = ConfigurationListenerTestUtils.randomUuid();
        this.config.listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            ParentConfiguration parent = (ParentConfiguration)ctx.config(ParentConfiguration.class);
            Assertions.assertNotNull((Object)parent);
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)parent.child().str().value());
        }));
        this.config.child().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)child.str().value());
        }));
        this.config.child().str().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)child.str().value());
        }));
        this.config.change(c0 -> c0.changeChild(c1 -> c1.changeStr(newVal))).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testGetConfigFromNotificationEventOnCreate() throws Exception {
        String newVal = ConfigurationListenerTestUtils.randomUuid();
        String key = ConfigurationListenerTestUtils.randomUuid();
        this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            ParentConfiguration parent = (ParentConfiguration)ctx.config(ParentConfiguration.class);
            Assertions.assertNotNull((Object)parent);
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)((ChildConfiguration)parent.children().get(key)).str().value());
        }));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertEquals((Object)key, (Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)child.str().value());
        }));
        this.config.children().change(c -> c.create(key, c1 -> c1.changeStr(newVal))).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testGetConfigFromNotificationEventOnRename() throws Exception {
        String val = "default";
        String oldKey = ConfigurationListenerTestUtils.randomUuid();
        String newKey = ConfigurationListenerTestUtils.randomUuid();
        this.config.children().change(c -> c.create(oldKey, ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            ParentConfiguration parent = (ParentConfiguration)ctx.config(ParentConfiguration.class);
            Assertions.assertNotNull((Object)parent);
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertNull((Object)parent.children().get(oldKey));
            Assertions.assertEquals((Object)val, (Object)((ChildConfiguration)parent.children().get(newKey)).str().value());
        }));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertEquals((Object)newKey, (Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)val, (Object)child.str().value());
        }));
        this.config.children().change(c -> c.rename(oldKey, newKey));
    }

    @Test
    void testGetConfigFromNotificationEventOnDelete() throws Exception {
        String key = ConfigurationListenerTestUtils.randomUuid();
        this.config.children().change(c -> c.create(key, ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            ParentConfiguration parent = (ParentConfiguration)ctx.config(ParentConfiguration.class);
            Assertions.assertNotNull((Object)parent);
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertNull((Object)parent.children().get(key));
        }));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertEquals((Object)key, (Object)ctx.name(ChildConfiguration.class));
        }));
        ((ChildConfiguration)this.config.children().get(key)).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertEquals((Object)key, (Object)ctx.name(ChildConfiguration.class));
        }));
        this.config.children().change(c -> c.delete(key)).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testGetConfigFromNotificationEventOnUpdate() throws Exception {
        String newVal = ConfigurationListenerTestUtils.randomUuid();
        String key = ConfigurationListenerTestUtils.randomUuid();
        this.config.children().change(c -> c.create(key, ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            ParentConfiguration parent = (ParentConfiguration)ctx.config(ParentConfiguration.class);
            Assertions.assertNotNull((Object)parent);
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)((ChildConfiguration)parent.children().get(key)).str().value());
        }));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertEquals((Object)key, (Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)child.str().value());
        }));
        ((ChildConfiguration)this.config.children().get(key)).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(ParentConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ParentConfiguration.class));
            ChildConfiguration child = (ChildConfiguration)ctx.config(ChildConfiguration.class);
            Assertions.assertNotNull((Object)child);
            Assertions.assertEquals((Object)key, (Object)ctx.name(ChildConfiguration.class));
            Assertions.assertEquals((Object)newVal, (Object)child.str().value());
        }));
        ((ChildConfiguration)this.config.children().get(key)).str().update((Object)newVal).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void polymorphicParentFieldChangeNotificationHappens() throws Exception {
        AtomicInteger intHolder = new AtomicInteger();
        this.config.polyChild().commonIntVal().listen(event -> {
            intHolder.set((Integer)event.newValue());
            return CompletableFuture.completedFuture(null);
        });
        this.config.polyChild().commonIntVal().update((Object)42).get(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)intHolder.get(), (Matcher)Matchers.is((Object)42));
    }

    @Test
    void testNotificationEventConfigForNestedConfiguration() throws Exception {
        this.config.child().listen(ctx -> {
            Assertions.assertInstanceOf(ChildConfiguration.class, (Object)ctx.config(ChildConfiguration.class));
            Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)ctx.config(InternalChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(ChildConfiguration.class));
            Assertions.assertNull((Object)ctx.name(InternalChildConfiguration.class));
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testNotificationEventConfigForNamedConfiguration() throws Exception {
        this.config.children().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<ChildView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertInstanceOf(ChildConfiguration.class, (Object)ctx.config(ChildConfiguration.class));
                Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)ctx.config(InternalChildConfiguration.class));
                Assertions.assertEquals((Object)"0", (Object)ctx.name(ChildConfiguration.class));
                Assertions.assertEquals((Object)"0", (Object)ctx.name(InternalChildConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertInstanceOf(ChildConfiguration.class, (Object)ctx.config(ChildConfiguration.class));
                Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)ctx.config(InternalChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(ChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(InternalChildConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertNull((Object)ctx.config(ChildConfiguration.class));
                Assertions.assertNull((Object)ctx.config(InternalChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(ChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(InternalChildConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ChildView> ctx) {
                Assertions.assertInstanceOf(ChildConfiguration.class, (Object)ctx.config(ChildConfiguration.class));
                Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)ctx.config(InternalChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(ChildConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(InternalChildConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.children().change(c -> c.create("0", c1 -> {})).get(1L, TimeUnit.SECONDS);
        this.config.children().change(c -> c.rename("0", "1")).get(1L, TimeUnit.SECONDS);
        this.config.children().change(c -> c.update("1", c1 -> c1.changeStr(ConfigurationListenerTestUtils.randomUuid()))).get(1L, TimeUnit.SECONDS);
        this.config.children().change(c -> c.delete("1")).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testNotificationEventConfigForNestedPolymorphicConfiguration() throws Exception {
        this.config.polyChild().listen(ctx -> {
            Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
            Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(PolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
            return CompletableFuture.completedFuture(null);
        });
        this.config.polyChild().commonIntVal().update((Object)22).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testNotificationEventConfigForNamedPolymorphicConfiguration() throws Exception {
        this.config.polyChildren().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<PolyView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<PolyView> ctx) {
                Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
                Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
                Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyConfiguration.class));
                Assertions.assertEquals((Object)"0", (Object)ctx.name(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<PolyView> ctx) {
                Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
                Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(PolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<PolyView> ctx) {
                Assertions.assertNull((Object)ctx.config(PolyConfiguration.class));
                Assertions.assertNull((Object)ctx.config(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(PolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<PolyView> ctx) {
                Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
                Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(PolyConfiguration.class));
                Assertions.assertEquals((Object)"1", (Object)ctx.name(StringPolyConfiguration.class));
                Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }
        });
        this.config.polyChildren().change(c -> c.create("0", c1 -> {})).get(1L, TimeUnit.SECONDS);
        this.config.polyChildren().change(c -> c.rename("0", "1")).get(1L, TimeUnit.SECONDS);
        this.config.polyChildren().change(c -> c.update("1", c1 -> c1.changeCommonIntVal(22))).get(1L, TimeUnit.SECONDS);
        this.config.polyChildren().change(c -> c.delete("1")).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testNotificationListenerForNestedPolymorphicConfig() throws Exception {
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.polyChild().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(LongPolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
            Assertions.assertInstanceOf(LongPolyConfiguration.class, (Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(PolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(StringPolyConfiguration.class));
        }));
        this.config.polyChild().change(c -> c.convert(LongPolyChange.class).changeSpecificVal(0L).changeCommonIntVal(0)).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotificationListenerOnCreateNamedPolymorphicConfig() throws Exception {
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.newValue());
            Assertions.assertNull((Object)ctx.oldValue());
            Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
            Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
        }));
        this.config.polyChildren().change(c -> c.create("0", c1 -> c1.convert(StringPolyChange.class).changeSpecificVal("").changeCommonIntVal(0))).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotificationListenerOnUpdateNamedPolymorphicConfig() throws Exception {
        this.config.polyChildren().change(c -> c.create("0", c1 -> c1.convert(StringPolyChange.class).changeSpecificVal("").changeCommonIntVal(0))).get(1L, TimeUnit.SECONDS);
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(LongPolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
            Assertions.assertInstanceOf(LongPolyConfiguration.class, (Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(LongPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(StringPolyConfiguration.class));
        }));
        this.config.polyChildren().change(c -> c.update("0", c1 -> c1.convert(LongPolyChange.class).changeSpecificVal(0L).changeCommonIntVal(0))).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotificationListenerOnRenameNamedPolymorphicConfig() throws Exception {
        this.config.polyChildren().change(c -> c.create("0", c1 -> c1.convert(StringPolyChange.class).changeSpecificVal("").changeCommonIntVal(0))).get(1L, TimeUnit.SECONDS);
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(PolyConfiguration.class, (Object)ctx.config(PolyConfiguration.class));
            Assertions.assertInstanceOf(StringPolyConfiguration.class, (Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertEquals((Object)"1", (Object)ctx.name(PolyConfiguration.class));
            Assertions.assertEquals((Object)"1", (Object)ctx.name(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
        }));
        this.config.polyChildren().change(c -> c.rename("0", "1")).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotificationListenerOnDeleteNamedPolymorphicConfig() throws Exception {
        this.config.polyChildren().change(c -> c.create("0", c1 -> c1.convert(StringPolyChange.class).changeSpecificVal("").changeCommonIntVal(0))).get(1L, TimeUnit.SECONDS);
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> {
            invokeListener.set(true);
            Assertions.assertNull((Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(StringPolyView.class, (Object)ctx.oldValue());
            Assertions.assertNull((Object)ctx.config(PolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(LongPolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(StringPolyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(LongPolyConfiguration.class));
        }));
        this.config.polyChildren().change(c -> c.delete("0")).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotificationEventForNestedConfigAfterNotifyListeners() throws Exception {
        AtomicReference eventRef = new AtomicReference();
        this.config.child().listen(ConfigurationListenerTestUtils.configListener(eventRef::set));
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
        ConfigurationNotificationEvent event = (ConfigurationNotificationEvent)eventRef.get();
        Assertions.assertNotNull((Object)event);
        Assertions.assertInstanceOf(ChildView.class, (Object)event.newValue());
        Assertions.assertInstanceOf(InternalChildView.class, (Object)event.newValue());
        Assertions.assertInstanceOf(ChildView.class, (Object)event.oldValue());
        Assertions.assertInstanceOf(InternalChildView.class, (Object)event.oldValue());
        Assertions.assertInstanceOf(ChildConfiguration.class, (Object)event.config(ChildConfiguration.class));
        Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)event.config(InternalChildConfiguration.class));
        Assertions.assertInstanceOf(ParentConfiguration.class, (Object)event.config(ParentConfiguration.class));
        Assertions.assertNull((Object)event.name(ChildConfiguration.class));
        Assertions.assertNull((Object)event.name(InternalChildConfiguration.class));
    }

    @Test
    void testNotificationEventForNamedConfigAfterNotifyListeners() throws Exception {
        AtomicReference eventRef = new AtomicReference();
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(eventRef::set));
        this.config.children().change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        ConfigurationNotificationEvent event = (ConfigurationNotificationEvent)eventRef.get();
        Assertions.assertNotNull((Object)event);
        Assertions.assertInstanceOf(ChildView.class, (Object)event.newValue());
        Assertions.assertInstanceOf(InternalChildView.class, (Object)event.newValue());
        Assertions.assertNull((Object)event.oldValue());
        Assertions.assertInstanceOf(ChildConfiguration.class, (Object)event.config(ChildConfiguration.class));
        Assertions.assertInstanceOf(InternalChildConfiguration.class, (Object)event.config(InternalChildConfiguration.class));
        Assertions.assertInstanceOf(ParentConfiguration.class, (Object)event.config(ParentConfiguration.class));
        Assertions.assertEquals((Object)"0", (Object)event.name(ChildConfiguration.class));
        Assertions.assertEquals((Object)"0", (Object)event.name(InternalChildConfiguration.class));
    }

    @Test
    void testGetErrorFromListener() {
        this.config.child().listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            throw new RuntimeException("from test");
        }));
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)IgniteTestUtils.hasCause((Throwable)ex, RuntimeException.class, (String)"from test"));
    }

    @Test
    void testGetErrorFromListenerFuture() {
        this.config.child().listen(ctx -> CompletableFuture.failedFuture(new RuntimeException("from test")));
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)IgniteTestUtils.hasCause((Throwable)ex, RuntimeException.class, (String)"from test"));
    }

    @Test
    void testNotifyListenersOnCurrentConfigWithoutChange() throws Exception {
        this.config.children().change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        this.config.polyChildren().change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        ArrayList events = new ArrayList();
        this.config.listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("root")));
        this.config.child().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("child")));
        this.config.child().str().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("child.str")));
        this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("children")));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> events.add("children.onCreate")));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> events.add("children.onUpdate")));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> events.add("children.onRename")));
        this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> events.add("children.onDelete")));
        ((ChildConfiguration)this.config.children().get("0")).listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("children.0")));
        ((ChildConfiguration)this.config.children().get("0")).str().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("children.0.str")));
        ((ChildConfiguration)this.config.children().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("children.any")));
        ((ChildConfiguration)this.config.children().any()).str().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("children.any.str")));
        this.config.polyChild().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChild")));
        this.config.polyChild().commonIntVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChild.int")));
        ((StringPolyConfiguration)this.config.polyChild()).specificVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChild.str")));
        this.config.polyChildren().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren")));
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> events.add("polyChildren.onCreate")));
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> events.add("polyChildren.onUpdate")));
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> events.add("polyChildren.onRename")));
        this.config.polyChildren().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> events.add("polyChildren.onDelete")));
        ((PolyConfiguration)this.config.polyChildren().get("0")).listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren.0")));
        ((PolyConfiguration)this.config.polyChildren().get("0")).commonIntVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren.0.int")));
        ((StringPolyConfiguration)this.config.polyChildren().get("0")).specificVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren.0.str")));
        ((PolyConfiguration)this.config.polyChildren().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren.any")));
        ((PolyConfiguration)this.config.polyChildren().any()).commonIntVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("polyChildren.any.int")));
        Collection futs = ConfigurationNotifier.notifyListeners(null, (InnerNode)((InnerNode)this.config.value()), (DynamicConfiguration)((DynamicConfiguration)this.config), (long)0L, (long)(this.registry.notificationCount() + 1L));
        for (CompletableFuture fut : futs) {
            fut.get(1L, TimeUnit.SECONDS);
        }
        Assertions.assertEquals(List.of("root", "child", "child.str", "children", "children.onCreate", "children.any", "children.0", "children.any.str", "children.0.str", "polyChild", "polyChild.int", "polyChild.str", "polyChildren", "polyChildren.onCreate", "polyChildren.any", "polyChildren.0", "polyChildren.any.int", "polyChildren.0.int", "polyChildren.0.str"), events);
    }

    @Test
    void testNotifyCurrentConfigurationListeners() throws Exception {
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.config.listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            invokeListener.set(true);
            Assertions.assertNull((Object)ctx.oldValue());
            Assertions.assertNotNull((Object)ctx.newValue());
        }));
        this.registry.notifyCurrentConfigurationListeners().get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testNotifyStorageRevisionListener() throws Exception {
        ArrayList events = new ArrayList();
        long currentStorageRevision = (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS);
        this.config.listen(ConfigurationListenerTestUtils.configListener(ctx -> events.add("root")));
        this.registry.listenUpdateStorageRevision(newStorageRevision -> {
            Assertions.assertNotEquals((long)currentStorageRevision, (long)newStorageRevision);
            Assertions.assertTrue((newStorageRevision > currentStorageRevision ? 1 : 0) != 0);
            events.add("0");
            return CompletableFuture.completedFuture(null);
        });
        this.registry.listenUpdateStorageRevision(newStorageRevision -> {
            Assertions.assertNotEquals((long)currentStorageRevision, (long)newStorageRevision);
            Assertions.assertTrue((newStorageRevision > currentStorageRevision ? 1 : 0) != 0);
            events.add("1");
            return CompletableFuture.completedFuture(null);
        });
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("root", "0", "1"), events);
    }

    @Test
    void testRemoveStorageRevisionListener() throws Exception {
        ArrayList events = new ArrayList();
        ConfigurationStorageRevisionListener listener0 = ConfigurationListenerTestUtils.configStorageRevisionListener(newRevision -> events.add("0"));
        ConfigurationStorageRevisionListener listener1 = ConfigurationListenerTestUtils.configStorageRevisionListener(newRevision -> events.add("1"));
        this.registry.listenUpdateStorageRevision(listener0);
        this.registry.listenUpdateStorageRevision(listener1);
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("0", "1"), events);
        this.registry.stopListenUpdateStorageRevision(listener0);
        events.clear();
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("1"), events);
    }

    @Test
    void testNotifyStorageRevisionListenerWithError() {
        ConfigurationStorageRevisionListener listener0 = newStorageRevision -> {
            throw new RuntimeException("from listener 0");
        };
        this.registry.listenUpdateStorageRevision(listener0);
        ExecutionException ex0 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)IgniteTestUtils.hasCause((Throwable)ex0, RuntimeException.class, (String)"from listener 0"));
        this.registry.stopListenUpdateStorageRevision(listener0);
        ConfigurationStorageRevisionListener listener1 = newStorageRevision -> CompletableFuture.failedFuture(new RuntimeException("from listener 1"));
        this.registry.listenUpdateStorageRevision(listener1);
        ExecutionException ex1 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)IgniteTestUtils.hasCause((Throwable)ex1, RuntimeException.class, (String)"from listener 1"));
    }

    @Test
    void testNotifyStorageRevisionListenerForCurrentConfig() throws Exception {
        AtomicBoolean invokeListener = new AtomicBoolean();
        this.registry.listenUpdateStorageRevision(ConfigurationListenerTestUtils.configStorageRevisionListener(newRevision -> invokeListener.set(true)));
        this.registry.notifyCurrentConfigurationListeners().get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testIncreaseNotificationCount() throws Exception {
        long notificationCount = this.registry.notificationCount();
        Assertions.assertTrue((notificationCount >= 0L ? 1 : 0) != 0);
        this.config.child().str().update((Object)ConfigurationListenerTestUtils.randomUuid()).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)(notificationCount + 1L), (long)this.registry.notificationCount());
        this.registry.notifyCurrentConfigurationListeners().get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)(notificationCount + 2L), (long)this.registry.notificationCount());
    }

    @Test
    void testNotifyListenersOnNextUpdateConfiguration() throws Exception {
        ArrayList events = new ArrayList();
        AtomicBoolean addListeners = new AtomicBoolean(true);
        this.config.listen(ConfigurationListenerTestUtils.configListener(ctx0 -> {
            events.add("root");
            if (addListeners.get()) {
                this.registry.listenUpdateStorageRevision(ConfigurationListenerTestUtils.configStorageRevisionListener(ctx -> events.add("storageRevision")));
                this.config.child().listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("child")));
                this.config.child().str().listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("child.str")));
                this.config.children().listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("children")));
                this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx1 -> events.add("children.onCreate")));
                this.config.children().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx1 -> events.add("children.onUpdate")));
                ((ChildConfiguration)this.config.children().get("0")).listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("children.0")));
                ((ChildConfiguration)this.config.children().get("0")).str().listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("children.0.str")));
                ((ChildConfiguration)this.config.children().any()).listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("children.any")));
                ((ChildConfiguration)this.config.children().any()).str().listen(ConfigurationListenerTestUtils.configListener(ctx1 -> events.add("children.any.str")));
                addListeners.set(false);
            }
        }));
        this.config.change(c0 -> c0.changeChild(c1 -> c1.changeStr(ConfigurationListenerTestUtils.randomUuid())).changeChildren(c1 -> c1.create("0", ConfigurationListenerTestUtils.doNothingConsumer()))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("root"), events);
        Assertions.assertFalse((boolean)addListeners.get());
        events.clear();
        this.config.change(c0 -> c0.changeChild(c1 -> c1.changeStr(ConfigurationListenerTestUtils.randomUuid())).changeChildren(c1 -> c1.create("1", ConfigurationListenerTestUtils.doNothingConsumer()).update("0", c2 -> c2.changeStr(ConfigurationListenerTestUtils.randomUuid())))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(List.of("root", "child", "child.str", "children", "children.onCreate", "children.any", "children.any.str", "children.onUpdate", "children.any", "children.0", "children.any.str", "children.0.str", "storageRevision"), events);
        Assertions.assertFalse((boolean)addListeners.get());
    }

    @PolymorphicConfigInstance(value="long")
    public static class LongPolyConfigurationSchema
    extends PolyConfigurationSchema {
        @Value(hasDefault=true)
        public long specificVal = 12L;
    }

    @PolymorphicConfigInstance(value="string")
    public static class StringPolyConfigurationSchema
    extends PolyConfigurationSchema {
        @Value(hasDefault=true)
        public String specificVal = "original";
    }

    @PolymorphicConfig
    public static class PolyConfigurationSchema {
        public static final String STRING = "string";
        public static final String LONG = "long";
        @PolymorphicId(hasDefault=true)
        public String type = "string";
        @Value(hasDefault=true)
        public int commonIntVal = 11;
    }

    @InternalConfiguration
    public static class InternalChildConfigurationSchema
    extends ChildConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
    }

    @Config
    public static class ChildConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "default";
    }

    @ConfigurationRoot(rootName="parent", type=ConfigurationType.LOCAL)
    public static class ParentConfigurationSchema {
        @ConfigValue
        public ChildConfigurationSchema child;
        @NamedConfigValue
        public ChildConfigurationSchema children;
        @ConfigValue
        public PolyConfigurationSchema polyChild;
        @NamedConfigValue
        public PolyConfigurationSchema polyChildren;
    }
}

