/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.configuration.ConfigurationListenOnlyException;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.notifications.ConfigurationListenerTestUtils;
import org.apache.ignite.internal.configuration.notifications.FirstPolyAnyChange;
import org.apache.ignite.internal.configuration.notifications.FirstPolyAnyConfiguration;
import org.apache.ignite.internal.configuration.notifications.FirstPolyAnyView;
import org.apache.ignite.internal.configuration.notifications.FirstSubConfiguration;
import org.apache.ignite.internal.configuration.notifications.PolyAnyConfiguration;
import org.apache.ignite.internal.configuration.notifications.PolyAnyView;
import org.apache.ignite.internal.configuration.notifications.RootConfiguration;
import org.apache.ignite.internal.configuration.notifications.SecondPolyAnyChange;
import org.apache.ignite.internal.configuration.notifications.SecondPolyAnyConfiguration;
import org.apache.ignite.internal.configuration.notifications.SecondPolyAnyView;
import org.apache.ignite.internal.configuration.notifications.SecondSubChange;
import org.apache.ignite.internal.configuration.notifications.SecondSubConfiguration;
import org.apache.ignite.internal.configuration.notifications.SecondSubView;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationAnyListenerTest {
    private ConfigurationRegistry registry;
    private RootConfiguration rootConfig;
    private final List<String> events = new CopyOnWriteArrayList<String>();

    @BeforeEach
    public void before() throws Exception {
        this.registry = new ConfigurationRegistry(List.of(RootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(FirstPolyAnyConfigurationSchema.class, SecondPolyAnyConfigurationSchema.class));
        this.registry.start();
        this.registry.initializeDefaults();
        this.rootConfig = (RootConfiguration)this.registry.getConfiguration(RootConfiguration.KEY);
        this.rootConfig.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root")));
        this.rootConfig.child().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.child")));
        this.rootConfig.child().str().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.child.str")));
        this.rootConfig.child().child2().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.child.child2")));
        this.rootConfig.child().child2().intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.child.child2.i")));
        this.rootConfig.elements().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements")));
        this.rootConfig.elements().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> this.events.add("root.elements.onCrt")));
        this.rootConfig.elements().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> this.events.add("root.elements.onUpd")));
        this.rootConfig.elements().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> this.events.add("root.elements.onRen")));
        this.rootConfig.elements().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> this.events.add("root.elements.onDel")));
        this.rootConfig.elements().change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        FirstSubConfiguration childCfg = (FirstSubConfiguration)this.rootConfig.elements().get("0");
        childCfg.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0")));
        childCfg.str().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.str")));
        childCfg.child2().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.child2")));
        childCfg.child2().intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.child2.i")));
        NamedConfigurationTree<SecondSubConfiguration, SecondSubView, SecondSubChange> elements2 = childCfg.elements2();
        elements2.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.elements2")));
        elements2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> this.events.add("root.elements.0.elements2.onCrt")));
        elements2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> this.events.add("root.elements.0.elements2.onUpd")));
        elements2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> this.events.add("root.elements.0.elements2.onRen")));
        elements2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> this.events.add("root.elements.0.elements2.onDel")));
        elements2.change(c -> c.create("0", ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        SecondSubConfiguration child2 = (SecondSubConfiguration)elements2.get("0");
        child2.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.elements2.0")));
        child2.intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.elements2.0.i")));
        FirstSubConfiguration anyChild = (FirstSubConfiguration)this.rootConfig.elements().any();
        anyChild.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any")));
        anyChild.str().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.str")));
        anyChild.child2().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.child2")));
        anyChild.child2().intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.child2.i")));
        NamedConfigurationTree<SecondSubConfiguration, SecondSubView, SecondSubChange> anyEl2 = anyChild.elements2();
        anyEl2.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.elements2")));
        anyEl2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> this.events.add("root.elements.any.elements2.onCrt")));
        anyEl2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> this.events.add("root.elements.any.elements2.onUpd")));
        anyEl2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> this.events.add("root.elements.any.elements2.onRen")));
        anyEl2.listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> this.events.add("root.elements.any.elements2.onDel")));
        SecondSubConfiguration anyChild2 = (SecondSubConfiguration)anyEl2.any();
        anyChild2.listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.elements2.any")));
        anyChild2.intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any.elements2.any.i")));
        ((SecondSubConfiguration)childCfg.elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.elements2.any")));
        ((SecondSubConfiguration)childCfg.elements2().any()).intVal().listen(ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.0.elements2.any.i")));
    }

    @AfterEach
    public void after() throws Exception {
        this.registry.stop();
    }

    @Test
    void testNoGetOrUpdateConfigValueForAny() throws Exception {
        FirstSubConfiguration any0 = (FirstSubConfiguration)this.rootConfig.elements().any();
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.change(ConfigurationListenerTestUtils.doNothingConsumer()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.str().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.str().update((Object)""));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.child2().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.child2().change(ConfigurationListenerTestUtils.doNothingConsumer()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.child2().intVal().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.child2().intVal().update((Object)100));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.elements2().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.elements2().change(ConfigurationListenerTestUtils.doNothingConsumer()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any0.elements2().get("test"));
        SecondSubConfiguration any1 = (SecondSubConfiguration)any0.elements2().any();
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any1.value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any1.change(ConfigurationListenerTestUtils.doNothingConsumer()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any1.intVal().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any1.intVal().update((Object)200));
        this.rootConfig.elements().change(c0 -> c0.create("test", c1 -> c1.changeStr("foo"))).get(1L, TimeUnit.SECONDS);
        SecondSubConfiguration any2 = (SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get("test")).elements2().any();
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any2.value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any2.change(ConfigurationListenerTestUtils.doNothingConsumer()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any2.intVal().value());
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> any2.intVal().update((Object)300));
    }

    @Test
    void testNoAnyListenerNotification() throws Exception {
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> this.rootConfig.child().change(c -> c.changeStr("x").changeChild2(c0 -> c0.changeIntVal(100))), List.of("root", "root.child", "root.child.str", "root.child.child2", "root.child.child2.i"), this.events);
    }

    @Test
    void testAnyListenerNotificationOnCreate() throws Exception {
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> this.rootConfig.elements().change(c -> c.create("1", c0 -> c0.changeElements2(c1 -> c1.create("2", ConfigurationListenerTestUtils.doNothingConsumer())))), List.of("root", "root.elements", "root.elements.onCrt", "root.elements.any", "root.elements.any.str", "root.elements.any.child2", "root.elements.any.child2.i", "root.elements.any.elements2", "root.elements.any.elements2.onCrt", "root.elements.any.elements2.any", "root.elements.any.elements2.any.i"), this.events);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().change(c -> c.create("1", ConfigurationListenerTestUtils.doNothingConsumer())), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.0", "root.elements.any.elements2", "root.elements.0.elements2", "root.elements.any.elements2.onCrt", "root.elements.0.elements2.onCrt", "root.elements.any.elements2.any", "root.elements.0.elements2.any", "root.elements.any.elements2.any.i", "root.elements.0.elements2.any.i"), this.events);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("1")).elements2().change(c -> c.create("3", ConfigurationListenerTestUtils.doNothingConsumer())), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.any.elements2", "root.elements.any.elements2.onCrt", "root.elements.any.elements2.any", "root.elements.any.elements2.any.i"), this.events);
    }

    @Test
    void testAnyListenerNotificationOnRename() throws Exception {
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().change(c -> c.rename("0", "0x")), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.0", "root.elements.any.elements2", "root.elements.0.elements2", "root.elements.any.elements2.onRen", "root.elements.0.elements2.onRen"), this.events);
        this.rootConfig.elements().change(c -> c.create("1", c0 -> c0.changeElements2(c1 -> c1.create("2", ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("1")).elements2().change(c -> c.rename("2", "2x")), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.any.elements2", "root.elements.any.elements2.onRen"), this.events);
    }

    @Test
    void testAnyListenerNotificationOnDelete() throws Exception {
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().change(c -> c.delete("0")), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.0", "root.elements.any.elements2", "root.elements.0.elements2", "root.elements.any.elements2.onDel", "root.elements.0.elements2.onDel", "root.elements.any.elements2.any", "root.elements.0.elements2.0"), this.events);
        this.rootConfig.elements().change(c -> c.create("1", c0 -> c0.changeElements2(c1 -> c1.create("2", ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("1")).elements2().change(c -> c.delete("2")), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.any.elements2", "root.elements.any.elements2.onDel", "root.elements.any.elements2.any"), this.events);
    }

    @Test
    void testAnyListenerNotificationForLeaf() throws Exception {
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((FirstSubConfiguration)this.rootConfig.elements().get("0")).str().update((Object)"x"), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.0", "root.elements.any.str", "root.elements.0.str"), this.events);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().get("0")).intVal().update((Object)200), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.0", "root.elements.any.elements2", "root.elements.0.elements2", "root.elements.any.elements2.onUpd", "root.elements.0.elements2.onUpd", "root.elements.any.elements2.any", "root.elements.0.elements2.any", "root.elements.0.elements2.0", "root.elements.any.elements2.any.i", "root.elements.0.elements2.any.i", "root.elements.0.elements2.0.i"), this.events);
        this.rootConfig.elements().change(c -> c.create("1", c0 -> c0.changeElements2(c1 -> c1.create("2", ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ConfigurationListenerTestUtils.checkEqualsListeners(() -> ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get("1")).elements2().get("2")).intVal().update((Object)200), List.of("root", "root.elements", "root.elements.onUpd", "root.elements.any", "root.elements.any.elements2", "root.elements.any.elements2.onUpd", "root.elements.any.elements2.any", "root.elements.any.elements2.any.i"), this.events);
    }

    @Test
    void testAnyStopListen() throws Exception {
        ConfigurationListener listener0 = ConfigurationListenerTestUtils.configListener(ctx -> this.events.add("root.elements.any2"));
        ConfigurationNamedListListener listener1 = ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> this.events.add("root.elements.any2.elements2.onUpd"));
        ((FirstSubConfiguration)this.rootConfig.elements().any()).listen(listener0);
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().listenElements(listener1);
        ConfigurationListenerTestUtils.checkContainsListeners(() -> ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().get("0")).intVal().update((Object)Integer.MAX_VALUE), this.events, List.of("root.elements.any", "root.elements.any2", "root.elements.any2.elements2.onUpd"), List.of());
        ((FirstSubConfiguration)this.rootConfig.elements().any()).stopListen(listener0);
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().stopListenElements(listener1);
        ConfigurationListenerTestUtils.checkContainsListeners(() -> ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get("0")).elements2().get("0")).intVal().update((Object)Integer.MIN_VALUE), this.events, List.of("root.elements.any"), List.of("root.elements.any2", "root.elements.any2.elements2.onUpd"));
    }

    @Test
    void testAnyGetConfigFromNotificationEventOnCreate() throws Exception {
        String key0 = UUID.randomUUID().toString();
        String key1 = UUID.randomUUID().toString();
        ((FirstSubConfiguration)this.rootConfig.elements().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
        }));
        this.rootConfig.elements().change(c -> c.create(key0, ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnCreate(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNotNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNotNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().change(c -> c.create(key1, ConfigurationListenerTestUtils.doNothingConsumer())).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testAnyGetConfigFromNotificationEventOnRename() throws Exception {
        String key0 = UUID.randomUUID().toString();
        String oldKey1 = UUID.randomUUID().toString();
        String newKey1 = UUID.randomUUID().toString();
        ((FirstSubConfiguration)this.rootConfig.elements().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
        }));
        this.rootConfig.elements().change(c -> c.create(key0, c1 -> c1.changeElements2(c2 -> c2.create(oldKey1, ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNotNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)newKey1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnRename(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNotNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)newKey1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().change(c -> c.rename(oldKey1, newKey1)).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testAnyGetConfigFromNotificationEventOnDelete() throws Exception {
        String key0 = UUID.randomUUID().toString();
        String key1 = UUID.randomUUID().toString();
        ((FirstSubConfiguration)this.rootConfig.elements().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
        }));
        this.rootConfig.elements().change(c -> c.create(key0, c1 -> c1.changeElements2(c2 -> c2.create(key1, ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnDelete(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            Assertions.assertNull((Object)ctx.config(SecondSubConfiguration.class));
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
        }));
        ((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().change(c -> c.delete(key1)).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testAnyGetConfigFromNotificationEventOnUpdate() throws Exception {
        String key0 = UUID.randomUUID().toString();
        String key1 = UUID.randomUUID().toString();
        int newVal = Integer.MAX_VALUE;
        this.rootConfig.elements().change(c -> c.create(key0, c1 -> c1.changeElements2(c2 -> c2.create(key1, ConfigurationListenerTestUtils.doNothingConsumer())))).get(1L, TimeUnit.SECONDS);
        ((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().listenElements(ConfigurationListenerTestUtils.configNamedListenerOnUpdate(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            SecondSubConfiguration second = (SecondSubConfiguration)ctx.config(SecondSubConfiguration.class);
            Assertions.assertNotNull((Object)second);
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
            Assertions.assertEquals((int)newVal, (Integer)((Integer)second.intVal().value()));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().any()).elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            SecondSubConfiguration second = (SecondSubConfiguration)ctx.config(SecondSubConfiguration.class);
            Assertions.assertNotNull((Object)second);
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
            Assertions.assertEquals((int)newVal, (Integer)((Integer)second.intVal().value()));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            Assertions.assertNotNull((Object)ctx.config(FirstSubConfiguration.class));
            Assertions.assertEquals((Object)key0, (Object)ctx.name(FirstSubConfiguration.class));
            SecondSubConfiguration second = (SecondSubConfiguration)ctx.config(SecondSubConfiguration.class);
            Assertions.assertNotNull((Object)second);
            Assertions.assertEquals((Object)key1, (Object)ctx.name(SecondSubConfiguration.class));
            Assertions.assertEquals((int)newVal, (Integer)((Integer)second.intVal().value()));
        }));
        ((SecondSubConfiguration)((FirstSubConfiguration)this.rootConfig.elements().get(key0)).elements2().get(key1)).intVal().update((Object)newVal).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testAnyCreateNamedPolymorphicConfig() throws Exception {
        AtomicBoolean invokeListener = new AtomicBoolean();
        ((PolyAnyConfiguration)this.rootConfig.polyNamed().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(FirstPolyAnyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyAnyView.class, (Object)ctx.newValue());
            Assertions.assertNull((Object)ctx.oldValue());
            Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyAnyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(FirstPolyAnyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(SecondPolyAnyConfiguration.class));
            Assertions.assertInstanceOf(PolyAnyConfiguration.class, (Object)ctx.config(PolyAnyConfiguration.class));
            Assertions.assertInstanceOf(FirstPolyAnyConfiguration.class, (Object)ctx.config(FirstPolyAnyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(SecondPolyAnyConfiguration.class));
        }));
        this.rootConfig.polyNamed().change(c -> c.create("0", c1 -> c1.convert(FirstPolyAnyChange.class).changeStrVal("0").changeIntVal(0))).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @Test
    void testAnyUpdateNamedPolymorphicConfig() throws Exception {
        this.rootConfig.polyNamed().change(c -> c.create("0", c1 -> c1.convert(FirstPolyAnyChange.class).changeStrVal("0").changeIntVal(0))).get(1L, TimeUnit.SECONDS);
        AtomicBoolean invokeListener = new AtomicBoolean();
        ((PolyAnyConfiguration)this.rootConfig.polyNamed().any()).listen(ConfigurationListenerTestUtils.configListener(ctx -> {
            invokeListener.set(true);
            Assertions.assertInstanceOf(SecondPolyAnyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(PolyAnyView.class, (Object)ctx.newValue());
            Assertions.assertInstanceOf(FirstPolyAnyView.class, (Object)ctx.oldValue());
            Assertions.assertInstanceOf(PolyAnyView.class, (Object)ctx.oldValue());
            Assertions.assertEquals((Object)"0", (Object)ctx.name(PolyAnyConfiguration.class));
            Assertions.assertEquals((Object)"0", (Object)ctx.name(SecondPolyAnyConfiguration.class));
            Assertions.assertNull((Object)ctx.name(FirstPolyAnyConfiguration.class));
            Assertions.assertInstanceOf(PolyAnyConfiguration.class, (Object)ctx.config(PolyAnyConfiguration.class));
            Assertions.assertInstanceOf(SecondPolyAnyConfiguration.class, (Object)ctx.config(SecondPolyAnyConfiguration.class));
            Assertions.assertNull((Object)ctx.config(FirstPolyAnyConfiguration.class));
        }));
        this.rootConfig.polyNamed().change(c -> c.update("0", c1 -> c1.convert(SecondPolyAnyChange.class).changeStrVal("0").changeIntVal(0))).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)invokeListener.get());
    }

    @PolymorphicConfigInstance(value="second")
    public static class SecondPolyAnyConfigurationSchema
    extends PolyAnyConfigurationSchema {
        @Value
        public String strVal;
    }

    @PolymorphicConfigInstance(value="first")
    public static class FirstPolyAnyConfigurationSchema
    extends PolyAnyConfigurationSchema {
        @Value
        public String strVal;
    }

    @PolymorphicConfig
    public static class PolyAnyConfigurationSchema {
        @PolymorphicId
        public String type;
        @Value
        public int intVal;
    }

    @Config
    public static class SecondSubConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 10;
    }

    @Config
    public static class FirstSubConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "default";
        @ConfigValue
        public SecondSubConfigurationSchema child2;
        @NamedConfigValue
        public SecondSubConfigurationSchema elements2;
    }

    @ConfigurationRoot(rootName="root", type=ConfigurationType.LOCAL)
    public static class RootConfigurationSchema {
        @ConfigValue
        public FirstSubConfigurationSchema child;
        @NamedConfigValue
        public FirstSubConfigurationSchema elements;
        @NamedConfigValue
        public PolyAnyConfigurationSchema polyNamed;
    }
}

