/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.hocon;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.hocon.HoconArraysConfiguration;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.hocon.HoconInjectedNameRootConfiguration;
import org.apache.ignite.internal.configuration.hocon.HoconPrimitivesConfiguration;
import org.apache.ignite.internal.configuration.hocon.HoconRootConfiguration;
import org.apache.ignite.internal.configuration.hocon.HoconSecondPolymorphicInstanceConfiguration;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HoconConverterTest {
    private static ConfigurationRegistry registry;
    private static HoconRootConfiguration configuration;
    private static HoconInjectedNameRootConfiguration injectedNameRootConfig;

    @BeforeAll
    public static void beforeAll() {
        registry = new ConfigurationRegistry(List.of(HoconRootConfiguration.KEY, HoconInjectedNameRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(HoconFirstPolymorphicInstanceConfigurationSchema.class, HoconSecondPolymorphicInstanceConfigurationSchema.class));
        registry.start();
        configuration = (HoconRootConfiguration)registry.getConfiguration(HoconRootConfiguration.KEY);
        injectedNameRootConfig = (HoconInjectedNameRootConfiguration)registry.getConfiguration(HoconInjectedNameRootConfiguration.KEY);
    }

    @AfterAll
    public static void after() throws Exception {
        registry.stop();
        registry = null;
        configuration = null;
        injectedNameRootConfig = null;
    }

    @BeforeEach
    public void before() throws Exception {
        configuration.change((T cfg) -> cfg.changePrimitivesList(list -> list.namedListKeys().forEach(arg_0 -> ((NamedListChange)list).delete(arg_0))).changeArraysList(list -> list.namedListKeys().forEach(arg_0 -> ((NamedListChange)list).delete(arg_0))).changePolymorphicCfg(c -> {})).get(1L, TimeUnit.SECONDS);
        injectedNameRootConfig.change((T c) -> c.changeNested(c0 -> {}).changeNestedNamed(list -> list.namedListKeys().forEach(arg_0 -> ((NamedListChange)list).delete(arg_0)))).get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void toHoconBasic() {
        Assertions.assertEquals((Object)"root{arraysList=[],polymorphicCfg=[],primitivesList=[]},rootInjectedName{nested{},nestedNamed=[]}", (Object)HoconConverterTest.asHoconStr(List.of(), new String[0]));
        Assertions.assertEquals((Object)"arraysList=[],polymorphicCfg=[],primitivesList=[]", (Object)HoconConverterTest.asHoconStr(List.of("root"), new String[0]));
        Assertions.assertEquals((Object)"[]", (Object)HoconConverterTest.asHoconStr(List.of("root", "arraysList"), new String[0]));
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverter.represent((ConfigurationRegistry)registry, List.of("doot")), "Configuration value 'doot' has not been found");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverter.represent((ConfigurationRegistry)registry, List.of("root", "x")), "Configuration value 'root.x' has not been found");
        Assertions.assertEquals((Object)"null", (Object)HoconConverterTest.asHoconStr(List.of("root", "primitivesList", "foo"), new String[0]));
    }

    @Test
    public void testHoconPrimitivesSerialization() throws Exception {
        configuration.change((T cfg) -> cfg.changePrimitivesList(primitivesList -> primitivesList.create("name", primitives -> {}))).get(1L, TimeUnit.SECONDS);
        List<String> basePath = List.of("root", "primitivesList", "name");
        Assertions.assertEquals((Object)"booleanVal=false,byteVal=0,charVal=\"\\u0000\",doubleVal=0.0,floatVal=0,intVal=0,longVal=0,shortVal=0,stringVal=\"\"", (Object)HoconConverterTest.asHoconStr(basePath, new String[0]));
        Assertions.assertEquals((Object)"false", (Object)HoconConverterTest.asHoconStr(basePath, "booleanVal"));
        Assertions.assertEquals((Object)"0", (Object)HoconConverterTest.asHoconStr(basePath, "byteVal"));
        Assertions.assertEquals((Object)"0", (Object)HoconConverterTest.asHoconStr(basePath, "shortVal"));
        Assertions.assertEquals((Object)"0", (Object)HoconConverterTest.asHoconStr(basePath, "intVal"));
        Assertions.assertEquals((Object)"0", (Object)HoconConverterTest.asHoconStr(basePath, "longVal"));
        Assertions.assertEquals((Object)"\"\\u0000\"", (Object)HoconConverterTest.asHoconStr(basePath, "charVal"));
        Assertions.assertEquals((Object)"0", (Object)HoconConverterTest.asHoconStr(basePath, "floatVal"));
        Assertions.assertEquals((Object)"0.0", (Object)HoconConverterTest.asHoconStr(basePath, "doubleVal"));
        Assertions.assertEquals((Object)"\"\"", (Object)HoconConverterTest.asHoconStr(basePath, "stringVal"));
    }

    @Test
    public void testHoconArraysSerialization() throws Exception {
        configuration.change((T cfg) -> cfg.changeArraysList(arraysList -> arraysList.create("name", arrays -> {}))).get(1L, TimeUnit.SECONDS);
        List<String> basePath = List.of("root", "arraysList", "name");
        Assertions.assertEquals((Object)"booleans=[false],bytes=[0],chars=[\"\\u0000\"],doubles=[0.0],floats=[0],ints=[0],longs=[0],shorts=[0],strings=[\"\"]", (Object)HoconConverterTest.asHoconStr(basePath, new String[0]));
        Assertions.assertEquals((Object)"[false]", (Object)HoconConverterTest.asHoconStr(basePath, "booleans"));
        Assertions.assertEquals((Object)"[0]", (Object)HoconConverterTest.asHoconStr(basePath, "bytes"));
        Assertions.assertEquals((Object)"[0]", (Object)HoconConverterTest.asHoconStr(basePath, "shorts"));
        Assertions.assertEquals((Object)"[0]", (Object)HoconConverterTest.asHoconStr(basePath, "ints"));
        Assertions.assertEquals((Object)"[0]", (Object)HoconConverterTest.asHoconStr(basePath, "longs"));
        Assertions.assertEquals((Object)"[\"\\u0000\"]", (Object)HoconConverterTest.asHoconStr(basePath, "chars"));
        Assertions.assertEquals((Object)"[0]", (Object)HoconConverterTest.asHoconStr(basePath, "floats"));
        Assertions.assertEquals((Object)"[0.0]", (Object)HoconConverterTest.asHoconStr(basePath, "doubles"));
        Assertions.assertEquals((Object)"[\"\"]", (Object)HoconConverterTest.asHoconStr(basePath, "strings"));
    }

    private static String asHoconStr(List<String> basePath, String ... path) {
        List fullPath = Stream.concat(basePath.stream(), Arrays.stream(path)).collect(Collectors.toList());
        ConfigValue hoconCfg = HoconConverter.represent((ConfigurationRegistry)registry, fullPath);
        return hoconCfg.render(ConfigRenderOptions.concise().setJson(false));
    }

    @Test
    public void fromHoconBasic() {
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("doot : {}"), "'doot' configuration root doesn't exist");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.foo : {}"), "'root' configuration doesn't have the 'foo' sub-configuration");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.x = 1"), "'root.arraysList.name' configuration doesn't have the 'x' sub-configuration");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root = foo"), "'root' is expected to be a composite configuration node, not a single value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList = foo"), "'root.arraysList' is expected to be a composite configuration node, not a single value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name = foo"), "'root.arraysList.name' is expected to be a composite configuration node, not a single value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.ints = {}"), "'int[]' is expected as a type for the 'root.arraysList.name.ints' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList = [1]"), "'root.arraysList[0]' is expected to be a composite configuration node, not a single value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList = [{}]"), "'root.arraysList[0].a' configuration value is mandatory and must be a String");
    }

    @Test
    public void testHoconPrimitivesDeserialization() throws Throwable {
        HoconConverterTest.change("root.primitivesList = [{p = name}]");
        HoconPrimitivesConfiguration primitives = (HoconPrimitivesConfiguration)configuration.primitivesList().get("name");
        Assertions.assertNotNull((Object)primitives);
        HoconConverterTest.change("root.primitivesList.name.booleanVal = true");
        MatcherAssert.assertThat((Object)((Boolean)primitives.booleanVal().value()), (Matcher)CoreMatchers.is((Object)true));
        HoconConverterTest.change("root.primitivesList.name.byteVal = 123");
        MatcherAssert.assertThat((Object)((Byte)primitives.byteVal().value()), (Matcher)CoreMatchers.is((Object)123));
        HoconConverterTest.change("root.primitivesList.name.shortVal = 12345");
        MatcherAssert.assertThat((Object)((Short)primitives.shortVal().value()), (Matcher)CoreMatchers.is((Object)12345));
        HoconConverterTest.change("root.primitivesList.name.intVal = 12345");
        MatcherAssert.assertThat((Object)((Integer)primitives.intVal().value()), (Matcher)CoreMatchers.is((Object)12345));
        HoconConverterTest.change("root.primitivesList.name.longVal = 12345678900");
        MatcherAssert.assertThat((Object)((Long)primitives.longVal().value()), (Matcher)CoreMatchers.is((Object)12345678900L));
        HoconConverterTest.change("root.primitivesList.name.charVal = p");
        MatcherAssert.assertThat((Object)((Character)primitives.charVal().value()), (Matcher)CoreMatchers.is((Object)Character.valueOf('p')));
        HoconConverterTest.change("root.primitivesList.name.floatVal = 2.5");
        MatcherAssert.assertThat((Object)((Float)primitives.floatVal().value()), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.5f)));
        HoconConverterTest.change("root.primitivesList.name.doubleVal = 2.5");
        MatcherAssert.assertThat((Object)((Double)primitives.doubleVal().value()), (Matcher)CoreMatchers.is((Object)2.5));
        HoconConverterTest.change("root.primitivesList.name.stringVal = foo");
        MatcherAssert.assertThat((Object)((String)primitives.stringVal().value()), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void testInvalidHoconPrimitivesDeserialization() {
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.booleanVal = \"true\""), "'boolean' is expected as a type for the 'root.primitivesList.name.booleanVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.byteVal = 290"), "Value '290' of 'root.primitivesList.name.byteVal' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.byteVal = false"), "'byte' is expected as a type for the 'root.primitivesList.name.byteVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.shortVal = 12345678900"), "Value '12345678900' of 'root.primitivesList.name.shortVal' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.shortVal = false"), "'short' is expected as a type for the 'root.primitivesList.name.shortVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.intVal = 12345678900"), "Value '12345678900' of 'root.primitivesList.name.intVal' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.intVal = false"), "'int' is expected as a type for the 'root.primitivesList.name.intVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.longVal = false"), "'long' is expected as a type for the 'root.primitivesList.name.longVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.charVal = 10"), "'char' is expected as a type for the 'root.primitivesList.name.charVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.floatVal = false"), "'float' is expected as a type for the 'root.primitivesList.name.floatVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.doubleVal = []"), "'double' is expected as a type for the 'root.primitivesList.name.doubleVal' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.primitivesList.name.stringVal = 10"), "'String' is expected as a type for the 'root.primitivesList.name.stringVal' configuration value");
    }

    @Test
    public void testHoconArraysDeserialization() throws Throwable {
        HoconConverterTest.change("root.arraysList = [{a = name}]");
        HoconArraysConfiguration arrays = (HoconArraysConfiguration)configuration.arraysList().get("name");
        Assertions.assertNotNull((Object)arrays);
        HoconConverterTest.change("root.arraysList.name.booleans = [true]");
        MatcherAssert.assertThat((Object)((boolean[])arrays.booleans().value()), (Matcher)CoreMatchers.is((Object)new boolean[]{true}));
        HoconConverterTest.change("root.arraysList.name.bytes = [123]");
        MatcherAssert.assertThat((Object)((byte[])arrays.bytes().value()), (Matcher)CoreMatchers.is((Object)new byte[]{123}));
        HoconConverterTest.change("root.arraysList.name.shorts = [123]");
        MatcherAssert.assertThat((Object)((short[])arrays.shorts().value()), (Matcher)CoreMatchers.is((Object)new short[]{123}));
        HoconConverterTest.change("root.arraysList.name.ints = [12345]");
        MatcherAssert.assertThat((Object)((int[])arrays.ints().value()), (Matcher)CoreMatchers.is((Object)new int[]{12345}));
        HoconConverterTest.change("root.arraysList.name.longs = [12345678900]");
        MatcherAssert.assertThat((Object)((long[])arrays.longs().value()), (Matcher)CoreMatchers.is((Object)new long[]{12345678900L}));
        HoconConverterTest.change("root.arraysList.name.chars = [p]");
        MatcherAssert.assertThat((Object)((char[])arrays.chars().value()), (Matcher)CoreMatchers.is((Object)new char[]{'p'}));
        HoconConverterTest.change("root.arraysList.name.floats = [2.5]");
        MatcherAssert.assertThat((Object)((float[])arrays.floats().value()), (Matcher)CoreMatchers.is((Object)new float[]{2.5f}));
        HoconConverterTest.change("root.arraysList.name.doubles = [2.5]");
        MatcherAssert.assertThat((Object)((double[])arrays.doubles().value()), (Matcher)CoreMatchers.is((Object)new double[]{2.5}));
        HoconConverterTest.change("root.arraysList.name.strings = [foo]");
        MatcherAssert.assertThat((Object)((String[])arrays.strings().value()), (Matcher)CoreMatchers.is((Object)new String[]{"foo"}));
    }

    @Test
    public void testInvalidHoconArraysDeserialization() {
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.booleans = true"), "'boolean[]' is expected as a type for the 'root.arraysList.name.booleans' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.booleans = [{}]"), "'boolean' is expected as a type for the 'root.arraysList.name.booleans[0]' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.bytes = [123, 290]"), "Value '290' of 'root.arraysList.name.bytes[1]' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.bytes = false"), "'byte[]' is expected as a type for the 'root.arraysList.name.bytes' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.shorts = [12345678900]"), "Value '12345678900' of 'root.arraysList.name.shorts[0]' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.shorts = [123, false]"), "'short' is expected as a type for the 'root.arraysList.name.shorts[1]' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.ints = [5, 12345678900]"), "Value '12345678900' of 'root.arraysList.name.ints[1]' is out of its declared bounds");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.ints = false"), "'int[]' is expected as a type for the 'root.arraysList.name.ints' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.longs = [foo]"), "'long' is expected as a type for the 'root.arraysList.name.longs[0]' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.chars = 10"), "'char[]' is expected as a type for the 'root.arraysList.name.chars' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.chars = [abc]"), "'char' is expected as a type for the 'root.arraysList.name.chars[0]' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.floats = [1.2, foo]"), "'float' is expected as a type for the 'root.arraysList.name.floats[1]' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.doubles = foo"), "'double[]' is expected as a type for the 'root.arraysList.name.doubles' configuration value");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.arraysList.name.strings = 10"), "'String[]' is expected as a type for the 'root.arraysList.name.strings' configuration value");
    }

    @Test
    void testPolymorphicConfig() throws Throwable {
        Assertions.assertEquals((Object)"arraysList=[],polymorphicCfg=[],primitivesList=[]", (Object)HoconConverterTest.asHoconStr(List.of("root"), new String[0]));
        HoconConverterTest.change("root.polymorphicCfg = [{poly = name, typeId = second}]");
        Assertions.assertInstanceOf(HoconSecondPolymorphicInstanceConfiguration.class, (Object)configuration.polymorphicCfg().get("name"));
        Assertions.assertEquals((Object)"arraysList=[],polymorphicCfg=[{intVal=0,poly=name,typeId=second}],primitivesList=[]", (Object)HoconConverterTest.asHoconStr(List.of("root"), new String[0]));
        HoconConverterTest.change("root.polymorphicCfg.name.intVal = 10");
        Assertions.assertEquals((Object)"arraysList=[],polymorphicCfg=[{intVal=10,poly=name,typeId=second}],primitivesList=[]", (Object)HoconConverterTest.asHoconStr(List.of("root"), new String[0]));
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.polymorphicCfg.name.typeId = ERROR"), "Polymorphic configuration type is not correct: ERROR");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("root.polymorphicCfg.name.longVal = 10"), "'root.polymorphicCfg.name' configuration doesn't have the 'longVal' sub-configuration");
    }

    @Test
    void testInjectedName() throws Throwable {
        Assertions.assertEquals((Object)"nested{},nestedNamed=[]", (Object)HoconConverterTest.asHoconStr(List.of("rootInjectedName"), new String[0]));
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("rootInjectedName.nested.someName = testName"), "rootInjectedName.nested' configuration doesn't have the 'someName' sub-configuration");
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.asHoconStr(List.of("rootInjectedName"), "nested", "someName"), "Configuration value 'rootInjectedName.nested.someName' has not been found");
        HoconConverterTest.change("rootInjectedName.nestedNamed = [{someName = foo}]");
        Assertions.assertEquals((Object)"nested{},nestedNamed=[{someName=foo}]", (Object)HoconConverterTest.asHoconStr(List.of("rootInjectedName"), new String[0]));
        Assertions.assertEquals((Object)"[someName=foo]", (Object)HoconConverterTest.asHoconStr(List.of("rootInjectedName", "nestedNamed"), new String[0]));
        Assertions.assertEquals((Object)"{}", (Object)HoconConverterTest.asHoconStr(List.of("rootInjectedName", "nestedNamed", "foo"), new String[0]));
        HoconConverterTest.assertThrowsIllegalArgException(() -> HoconConverterTest.change("rootInjectedName.nestedNamed = [{superName = foo}]"), "'rootInjectedName.nestedNamed[0].someName' configuration value is mandatory and must be a String");
    }

    private static void change(String hocon) throws Throwable {
        try {
            registry.change(HoconConverter.hoconSource((ConfigObject)ConfigFactory.parseString((String)hocon).root())).get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConfigurationChangeException) {
                throw cause.getCause();
            }
            throw cause;
        }
    }

    private static void assertThrowsIllegalArgException(Executable executable, String msg) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, (Executable)executable);
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)msg));
    }

    @Config
    public static class HoconInjectedNameConfigurationSchema {
        @InjectedName
        public String someName;
    }

    @ConfigurationRoot(rootName="rootInjectedName", type=ConfigurationType.LOCAL)
    public static class HoconInjectedNameRootConfigurationSchema {
        @Name(value="testDefault")
        @org.apache.ignite.configuration.annotation.ConfigValue
        public HoconInjectedNameConfigurationSchema nested;
        @NamedConfigValue(syntheticKeyName="superName")
        public HoconInjectedNameConfigurationSchema nestedNamed;
    }

    @PolymorphicConfigInstance(value="second")
    public static class HoconSecondPolymorphicInstanceConfigurationSchema
    extends HoconPolymorphicConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
    }

    @PolymorphicConfigInstance(value="first")
    public static class HoconFirstPolymorphicInstanceConfigurationSchema
    extends HoconPolymorphicConfigurationSchema {
        @Value(hasDefault=true)
        public int longVal = 0;
    }

    @PolymorphicConfig
    public static class HoconPolymorphicConfigurationSchema {
        @PolymorphicId
        public String typeId;
    }

    @Config
    public static class HoconPrimitivesConfigurationSchema {
        @Value(hasDefault=true)
        public boolean booleanVal = false;
        @Value(hasDefault=true)
        public byte byteVal = 0;
        @Value(hasDefault=true)
        public short shortVal = 0;
        @Value(hasDefault=true)
        public int intVal = 0;
        @Value(hasDefault=true)
        public long longVal = 0L;
        @Value(hasDefault=true)
        public char charVal = '\u0000';
        @Value(hasDefault=true)
        public float floatVal = 0.0f;
        @Value(hasDefault=true)
        public double doubleVal = 0.0;
        @Value(hasDefault=true)
        public String stringVal = "";
    }

    @Config
    public static class HoconArraysConfigurationSchema {
        @Value(hasDefault=true)
        public boolean[] booleans = new boolean[]{false};
        @Value(hasDefault=true)
        public byte[] bytes = new byte[]{0};
        @Value(hasDefault=true)
        public short[] shorts = new short[]{0};
        @Value(hasDefault=true)
        public int[] ints = new int[]{0};
        @Value(hasDefault=true)
        public long[] longs = new long[]{0L};
        @Value(hasDefault=true)
        public char[] chars = new char[]{'\u0000'};
        @Value(hasDefault=true)
        public float[] floats = new float[]{0.0f};
        @Value(hasDefault=true)
        public double[] doubles = new double[]{0.0};
        @Value(hasDefault=true)
        public String[] strings = new String[]{""};
    }

    @ConfigurationRoot(rootName="root", type=ConfigurationType.LOCAL)
    public static class HoconRootConfigurationSchema {
        @NamedConfigValue(syntheticKeyName="a")
        public HoconArraysConfigurationSchema arraysList;
        @NamedConfigValue(syntheticKeyName="p")
        public HoconPrimitivesConfigurationSchema primitivesList;
        @NamedConfigValue(syntheticKeyName="poly")
        public HoconPolymorphicConfigurationSchema polymorphicCfg;
    }
}

