/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.direct;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.ConfigurationListenOnlyException;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.direct.DirectConfiguration;
import org.apache.ignite.internal.configuration.direct.DirectNested2Configuration;
import org.apache.ignite.internal.configuration.direct.DirectNested2View;
import org.apache.ignite.internal.configuration.direct.DirectNestedChange;
import org.apache.ignite.internal.configuration.direct.DirectNestedConfiguration;
import org.apache.ignite.internal.configuration.direct.DirectNestedView;
import org.apache.ignite.internal.configuration.direct.DirectView;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.testframework.matchers.CompletableFutureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DirectPropertiesTest {
    private final ConfigurationRegistry registry = new ConfigurationRegistry(List.of(DirectConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of());

    @BeforeEach
    void setUp() {
        this.registry.start();
        this.registry.initializeDefaults();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.registry.stop();
    }

    @Test
    public void testDirectProperties() {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        MatcherAssert.assertThat((Object)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).directStr(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)((String)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).directStr().value()), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(cfg.directStr())).value()), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).child().str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).child().value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).child().str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(cfg.child().str())).value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).child().id(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).child().value()).id(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((UUID)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).child().id().value()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).id().value()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(cfg.child().id())).value()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testNamedListDirectProperties() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.children().change(change -> change.create("foo", value -> {})).get(1L, TimeUnit.SECONDS);
        UUID fooId = (UUID)((DirectNestedConfiguration)cfg.children().get("foo")).id().value();
        MatcherAssert.assertThat((Object)fooId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).str())).value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).str())).value()), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void testNamedListDirectInternalId() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.children().change(change -> change.create("foo", value -> {})).get(1L, TimeUnit.SECONDS);
        UUID fooId = (UUID)((DirectNestedConfiguration)cfg.children().get("foo")).id().value();
        MatcherAssert.assertThat((Object)fooId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).id())).value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).id())).value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooId)));
    }

    @Test
    public void testNamedListDirectNestedProperties() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.children().change(list -> list.create("foo", e -> e.changeChildren2(list2 -> list2.create("boo", e2 -> {})))).get(1L, TimeUnit.SECONDS);
        UUID fooId = (UUID)((DirectNestedConfiguration)cfg.children().get("foo")).id().value();
        UUID booId = (UUID)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")).id().value();
        MatcherAssert.assertThat((Object)booId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")).str())).value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).children2().get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).value()).get("boo")).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).get("boo")).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).get("boo")).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")).str())).value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)).str())).value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).children2(), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2(), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2(), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).value()), (UUID)booId)).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())), (UUID)booId)).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())), (UUID)booId)).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)))).value()).str(), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)))).str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)).str())).value()), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void testNamedListDirectNestedInternalId() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.children().change(list -> list.create("foo", e -> e.changeChildren2(list2 -> list2.create("boo", e2 -> {})))).get(1L, TimeUnit.SECONDS);
        UUID fooId = (UUID)((DirectNestedConfiguration)cfg.children().get("foo")).id().value();
        UUID booId = (UUID)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")).id().value();
        MatcherAssert.assertThat((Object)booId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")))).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")))).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)((DirectNestedConfiguration)cfg.children().get("foo")).children2().get("boo")).id())).value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).children2().get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).value()).get("boo")).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).get("boo")).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).get("boo")).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")))).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")))).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2().get("boo")).id())).value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("foo")).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("foo")).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("foo")).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("foo")).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("foo")).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("foo")))).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())).value()), (UUID)booId)).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("foo")).children2())), (UUID)booId)).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)))).value()).id(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)))).id().value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)cfg.children().get("foo")).children2(), (UUID)booId)).id())).value()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)booId)));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId(((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children(), (UUID)fooId)).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()), (UUID)fooId)).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fooId)).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()), (UUID)fooId)).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())), (UUID)fooId)).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId(((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).value()).children2(), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2().value()), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2(), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)))).children2(), (UUID)booId)).id().value()), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)ConfigurationUtil.getByInternalId((NamedListView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())).value()), (UUID)booId)).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())), (UUID)booId)).value()).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)((NamedConfigurationTree)ConfigurationUtil.directProxy(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2())), (UUID)booId)).id().value()), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((DirectNested2View)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)))).value()).id(), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((DirectNested2Configuration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)))).id().value()), (Matcher)Matchers.is((Object)booId));
        MatcherAssert.assertThat((Object)((UUID)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(cfg.children(), (UUID)fooId)).children2(), (UUID)booId)).id())).value()), (Matcher)Matchers.is((Object)booId));
    }

    @Test
    public void testNamedListNoSuchElement() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.children().change(list -> list.create("foo", e -> e.changeChildren2(list2 -> list2.create("boo", e2 -> {})))).get(1L, TimeUnit.SECONDS);
        UUID fakeId = UUID.randomUUID();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("a")).value());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DirectNestedConfiguration)ConfigurationUtil.getByInternalId(((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children(), (UUID)fakeId)).value());
        DirectNestedConfiguration foo = (DirectNestedConfiguration)cfg.children().get("foo");
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DirectNested2Configuration)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)foo)).children2().get("b")).value());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DirectNested2Configuration)ConfigurationUtil.getByInternalId(((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)foo)).children2(), (UUID)fakeId)).value());
    }

    @Test
    public void testNamedListDeleteCreate() {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        CompletableFuture changeFuture = cfg.children().change(change -> change.create("x", value -> {}));
        MatcherAssert.assertThat((Object)changeFuture, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.nullValue(Void.class)));
        DirectNestedConfiguration childCfg = (DirectNestedConfiguration)cfg.children().get("x");
        MatcherAssert.assertThat((Object)((String)childCfg.str().value()), (Matcher)Matchers.is((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(childCfg.str())).value()), (Matcher)Matchers.is((Object)"bar"));
        changeFuture = cfg.children().change(change -> change.delete("x"));
        MatcherAssert.assertThat((Object)changeFuture, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.nullValue(Void.class)));
        Assertions.assertThrows(NoSuchElementException.class, () -> childCfg.str().value());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((ConfigurationValue)ConfigurationUtil.directProxy(childCfg.str())).value());
        changeFuture = cfg.children().change(change -> change.create("x", value -> {}));
        MatcherAssert.assertThat((Object)changeFuture, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.nullValue(Void.class)));
        Assertions.assertThrows(NoSuchElementException.class, () -> childCfg.str().value());
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(childCfg.str())).value()), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    void testDirectAccessForAny() {
        NamedConfigurationTree<DirectNestedConfiguration, DirectNestedView, DirectNestedChange> children = ((DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY)).children();
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)children.any())));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> ConfigurationUtil.directProxy(((DirectNestedConfiguration)children.any()).str()));
        Assertions.assertThrows(ConfigurationListenOnlyException.class, () -> ConfigurationUtil.directProxy(((DirectNestedConfiguration)children.any()).children2()));
    }

    @Test
    void testInjectedNameNestedConfig() {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        MatcherAssert.assertThat((Object)((String)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).child().name().value()), (Matcher)Matchers.is((Object)"childTestName"));
        MatcherAssert.assertThat((Object)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).child().name(), (Matcher)Matchers.is((Object)"childTestName"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).name().value()), (Matcher)Matchers.is((Object)"childTestName"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg.child())).value()).name(), (Matcher)Matchers.is((Object)"childTestName"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(cfg.child().name())).value()), (Matcher)Matchers.is((Object)"childTestName"));
    }

    @Test
    void testInjectedNameNamedConfig() throws Exception {
        DirectConfiguration cfg = (DirectConfiguration)this.registry.getConfiguration(DirectConfiguration.KEY);
        cfg.change(c0 -> c0.changeChildren(c1 -> c1.create("0", c2 -> {}))).get(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("0")).name().value()), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).value()).children().get("0")).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().value()).get("0")).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((DirectConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)cfg)).children().get("0")).value()).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("0")).name().value()), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((NamedListView)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).value()).get("0")).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)((NamedConfigurationTree)ConfigurationUtil.directProxy(cfg.children())).get("0")).value()).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((String)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("0")))).name().value()), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((DirectNestedView)((DirectNestedConfiguration)ConfigurationUtil.directProxy((ConfigurationProperty)((DirectNestedConfiguration)cfg.children().get("0")))).value()).name(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((String)((ConfigurationValue)ConfigurationUtil.directProxy(((DirectNestedConfiguration)cfg.children().get("0")).name())).value()), (Matcher)Matchers.is((Object)"0"));
    }

    @Config
    public static class DirectNested2ConfigurationSchema {
        @InternalId
        public UUID id;
        @Value(hasDefault=true)
        public String str = "bar";
    }

    @Config
    public static class DirectNestedConfigurationSchema {
        @InjectedName
        public String name;
        @InternalId
        public UUID id;
        @Value(hasDefault=true)
        public String str = "bar";
        @NamedConfigValue
        public DirectNested2ConfigurationSchema children2;
    }

    @ConfigurationRoot(rootName="root")
    public static class DirectConfigurationSchema {
        @Name(value="childTestName")
        @ConfigValue
        public DirectNestedConfigurationSchema child;
        @NamedConfigValue
        public DirectNestedConfigurationSchema children;
        @Value(hasDefault=true)
        public String directStr = "foo";
    }
}

