/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.ConfigurationReadOnlyException;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.TestConfigurationChanger;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestChange;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestConfiguration;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestRootChange;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestRootConfiguration;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestRootView;
import org.apache.ignite.internal.configuration.asm.ExtendedSecondTestView;
import org.apache.ignite.internal.configuration.asm.ExtendedTestChange;
import org.apache.ignite.internal.configuration.asm.ExtendedTestConfiguration;
import org.apache.ignite.internal.configuration.asm.ExtendedTestRootChange;
import org.apache.ignite.internal.configuration.asm.ExtendedTestRootConfiguration;
import org.apache.ignite.internal.configuration.asm.ExtendedTestRootView;
import org.apache.ignite.internal.configuration.asm.ExtendedTestView;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicInstanceTestChange;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicInstanceTestConfiguration;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicInstanceTestView;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicNamedInstanceTestChange;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicNamedInstanceTestConfiguration;
import org.apache.ignite.internal.configuration.asm.FirstPolymorphicNamedInstanceTestView;
import org.apache.ignite.internal.configuration.asm.InjectedNameConfiguration;
import org.apache.ignite.internal.configuration.asm.InjectedNameRootConfiguration;
import org.apache.ignite.internal.configuration.asm.InjectedNameRootView;
import org.apache.ignite.internal.configuration.asm.InjectedNameView;
import org.apache.ignite.internal.configuration.asm.NonDefaultPolymorphicInstanceTestChange;
import org.apache.ignite.internal.configuration.asm.NonDefaultPolymorphicInstanceTestView;
import org.apache.ignite.internal.configuration.asm.PolyInjectedNameConfiguration;
import org.apache.ignite.internal.configuration.asm.PolyInjectedNameView;
import org.apache.ignite.internal.configuration.asm.PolyInst1InjectedNameChange;
import org.apache.ignite.internal.configuration.asm.PolymorphicNamedTestConfiguration;
import org.apache.ignite.internal.configuration.asm.PolymorphicTestConfiguration;
import org.apache.ignite.internal.configuration.asm.PolymorphicTestView;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicInstanceTestChange;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicInstanceTestConfiguration;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicInstanceTestView;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicNamedInstanceTestChange;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicNamedInstanceTestConfiguration;
import org.apache.ignite.internal.configuration.asm.SecondPolymorphicNamedInstanceTestView;
import org.apache.ignite.internal.configuration.asm.TestConfiguration;
import org.apache.ignite.internal.configuration.asm.TestRootConfiguration;
import org.apache.ignite.internal.configuration.asm.TestRootView;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationAsmGeneratorTest {
    private static ConfigurationAsmGenerator generator;
    private ConfigurationChanger changer;

    @BeforeAll
    public static void beforeAll() {
        generator = new ConfigurationAsmGenerator();
    }

    @AfterAll
    public static void afterAll() {
        generator = null;
    }

    @BeforeEach
    void beforeEach() {
        List<Class<?>> internalExtensions = List.of(ExtendedTestRootConfigurationSchema.class, ExtendedSecondTestRootConfigurationSchema.class, ExtendedTestConfigurationSchema.class, ExtendedSecondTestConfigurationSchema.class);
        List<Class<?>> polymorphicExtensions = List.of(FirstPolymorphicInstanceTestConfigurationSchema.class, SecondPolymorphicInstanceTestConfigurationSchema.class, NonDefaultPolymorphicInstanceTestConfigurationSchema.class, FirstPolymorphicNamedInstanceTestConfigurationSchema.class, SecondPolymorphicNamedInstanceTestConfigurationSchema.class, PolyInst0InjectedNameConfigurationSchema.class, PolyInst1InjectedNameConfigurationSchema.class);
        this.changer = new TestConfigurationChanger(generator, List.of(TestRootConfiguration.KEY, InjectedNameRootConfiguration.KEY), Map.of(), new TestConfigurationStorage(ConfigurationType.LOCAL), internalExtensions, polymorphicExtensions);
        this.changer.start();
        this.changer.initializeDefaults();
    }

    @AfterEach
    void afterEach() throws Exception {
        this.changer.stop();
    }

    @Test
    void testInternalRootConfiguration() throws Exception {
        DynamicConfiguration config = generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        TestRootConfiguration baseRootConfig = (TestRootConfiguration)config;
        ExtendedTestRootConfiguration extendedRootConfig = (ExtendedTestRootConfiguration)config;
        ExtendedSecondTestRootConfiguration extendedSecondRootConfig = (ExtendedSecondTestRootConfiguration)config;
        Assertions.assertSame(baseRootConfig.i0(), extendedRootConfig.i0());
        Assertions.assertSame(baseRootConfig.i0(), extendedSecondRootConfig.i0());
        Assertions.assertSame(baseRootConfig.str0(), extendedRootConfig.str0());
        Assertions.assertSame(baseRootConfig.str0(), extendedSecondRootConfig.str0());
        Assertions.assertSame((Object)baseRootConfig.subCfg(), (Object)extendedRootConfig.subCfg());
        Assertions.assertSame((Object)baseRootConfig.subCfg(), (Object)extendedSecondRootConfig.subCfg());
        Assertions.assertSame(baseRootConfig.namedCfg(), extendedRootConfig.namedCfg());
        Assertions.assertSame(baseRootConfig.namedCfg(), extendedSecondRootConfig.namedCfg());
        Assertions.assertNotNull(extendedSecondRootConfig.i1());
        Assertions.assertTrue((boolean)(baseRootConfig.value() instanceof ExtendedTestRootView));
        Assertions.assertTrue((boolean)(baseRootConfig.value() instanceof ExtendedSecondTestRootView));
        Assertions.assertSame((Object)baseRootConfig.value(), (Object)extendedRootConfig.value());
        Assertions.assertSame((Object)baseRootConfig.value(), (Object)extendedSecondRootConfig.value());
        baseRootConfig.change(c -> {
            Assertions.assertTrue((boolean)(c instanceof ExtendedTestRootChange));
            Assertions.assertTrue((boolean)(c instanceof ExtendedSecondTestRootChange));
            c.changeI0(10).changeStr0("str0");
            ((ExtendedTestRootChange)c).changeStr1("str1").changeStr0("str0");
            ((ExtendedSecondTestRootChange)c).changeI1(200).changeStr0("str0");
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testInternalSubConfiguration() throws Exception {
        DynamicConfiguration config = generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        TestRootConfiguration rootConfig = (TestRootConfiguration)config;
        TestConfiguration baseSubConfig = rootConfig.subCfg();
        ExtendedTestConfiguration extendedSubConfig = (ExtendedTestConfiguration)rootConfig.subCfg();
        ExtendedSecondTestConfiguration extendedSecondSubConfig = (ExtendedSecondTestConfiguration)rootConfig.subCfg();
        Assertions.assertSame(baseSubConfig.i0(), extendedSubConfig.i0());
        Assertions.assertSame(baseSubConfig.i0(), extendedSecondSubConfig.i0());
        Assertions.assertSame(baseSubConfig.str2(), extendedSubConfig.str2());
        Assertions.assertSame(baseSubConfig.str2(), extendedSecondSubConfig.str2());
        Assertions.assertNotNull(extendedSecondSubConfig.i1());
        Assertions.assertTrue((boolean)(baseSubConfig.value() instanceof ExtendedTestView));
        Assertions.assertTrue((boolean)(baseSubConfig.value() instanceof ExtendedSecondTestView));
        Assertions.assertSame((Object)baseSubConfig.value(), (Object)extendedSubConfig.value());
        Assertions.assertSame((Object)baseSubConfig.value(), (Object)extendedSecondSubConfig.value());
        baseSubConfig.change(c -> {
            Assertions.assertTrue((boolean)(c instanceof ExtendedTestChange));
            Assertions.assertTrue((boolean)(c instanceof ExtendedSecondTestChange));
            c.changeI0(10).changeStr2("str2");
            ((ExtendedTestChange)c).changeStr3("str3").changeStr2("str2");
            ((ExtendedSecondTestChange)c).changeI1(200).changeStr2("str2");
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testInternalNamedConfiguration() throws Exception {
        DynamicConfiguration config = generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        TestRootConfiguration rootConfig = (TestRootConfiguration)config;
        String key = UUID.randomUUID().toString();
        rootConfig.namedCfg().change(c -> c.create(key, c0 -> c0.changeI0(0).changeStr2("foo2"))).get(1L, TimeUnit.SECONDS);
        TestConfiguration namedConfig = (TestConfiguration)rootConfig.namedCfg().get(key);
        Assertions.assertTrue((boolean)(namedConfig instanceof ExtendedTestConfiguration));
        Assertions.assertTrue((boolean)(namedConfig instanceof ExtendedSecondTestConfiguration));
        Assertions.assertTrue((boolean)(namedConfig.value() instanceof ExtendedTestView));
        Assertions.assertTrue((boolean)(namedConfig.value() instanceof ExtendedSecondTestView));
        namedConfig.change(c -> {
            Assertions.assertTrue((boolean)(c instanceof ExtendedTestChange));
            Assertions.assertTrue((boolean)(c instanceof ExtendedSecondTestChange));
            c.changeStr2("str2").changeI0(10);
            ((ExtendedTestChange)c).changeStr3("str3").changeStr2("str2");
            ((ExtendedSecondTestChange)c).changeI1(100).changeStr2("str2");
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void testConstructInternalConfig() {
        InnerNode innerNode = generator.instantiateNode(TestRootConfiguration.KEY.schemaClass());
        ConfigurationUtil.addDefaults((InnerNode)innerNode);
        InnerNode subInnerNode = (InnerNode)((TestRootView)innerNode).subCfg();
        Assertions.assertThrows(NoSuchElementException.class, () -> innerNode.construct("str1", null, false));
        Assertions.assertThrows(NoSuchElementException.class, () -> innerNode.construct("i1", null, false));
        Assertions.assertThrows(NoSuchElementException.class, () -> subInnerNode.construct("str3", null, false));
        Assertions.assertThrows(NoSuchElementException.class, () -> subInnerNode.construct("i1", null, false));
        innerNode.construct("str1", null, true);
        innerNode.construct("i1", null, true);
        subInnerNode.construct("str3", null, true);
        subInnerNode.construct("i1", null, true);
    }

    @Test
    void testPolymorphicSubConfiguration() throws Exception {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        FirstPolymorphicInstanceTestConfiguration firstCfg = (FirstPolymorphicInstanceTestConfiguration)rootConfig.polymorphicSubCfg();
        Assertions.assertEquals((Object)"first", (Object)firstCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)0, (Integer)((Integer)firstCfg.intVal().value()));
        FirstPolymorphicInstanceTestView firstVal = (FirstPolymorphicInstanceTestView)firstCfg.value();
        Assertions.assertEquals((Object)"first", (Object)firstVal.typeId());
        Assertions.assertEquals((Object)"strVal", (Object)firstVal.strVal());
        Assertions.assertEquals((int)0, (int)firstVal.intVal());
        firstVal = (FirstPolymorphicInstanceTestView)((TestRootView)rootConfig.value()).polymorphicSubCfg();
        Assertions.assertEquals((Object)"first", (Object)firstVal.typeId());
        Assertions.assertEquals((Object)"strVal", (Object)firstVal.strVal());
        Assertions.assertEquals((int)0, (int)firstVal.intVal());
        firstCfg.strVal().update((Object)"strVal1").get(1L, TimeUnit.SECONDS);
        firstCfg.intVal().update((Object)1).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"first", (Object)firstCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal1", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)1, (Integer)((Integer)firstCfg.intVal().value()));
        firstCfg.change(c -> ((FirstPolymorphicInstanceTestChange)c).changeIntVal(2).changeStrVal("strVal2")).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"first", (Object)firstCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal2", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)2, (Integer)((Integer)firstCfg.intVal().value()));
        rootConfig.change(c -> c.changePolymorphicSubCfg(c1 -> ((FirstPolymorphicInstanceTestChange)c1).changeIntVal(3).changeStrVal("strVal3"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"first", (Object)firstCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal3", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)3, (Integer)((Integer)firstCfg.intVal().value()));
        rootConfig.polymorphicSubCfg().change(c -> {
            MatcherAssert.assertThat((Object)c.convert(FirstPolymorphicInstanceTestChange.class), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(FirstPolymorphicInstanceTestChange.class), (Matcher)Matchers.instanceOf(ConstructableTreeNode.class)));
            MatcherAssert.assertThat((Object)c.convert(SecondPolymorphicInstanceTestChange.class), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SecondPolymorphicInstanceTestChange.class), (Matcher)Matchers.instanceOf(ConstructableTreeNode.class)));
            MatcherAssert.assertThat((Object)c.convert("first"), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(FirstPolymorphicInstanceTestChange.class), (Matcher)Matchers.instanceOf(ConstructableTreeNode.class)));
            MatcherAssert.assertThat((Object)c.convert("second"), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SecondPolymorphicInstanceTestChange.class), (Matcher)Matchers.instanceOf(ConstructableTreeNode.class)));
            Assertions.assertThrows(ConfigurationWrongPolymorphicTypeIdException.class, () -> c.convert(UUID.randomUUID().toString()));
        }).get(1L, TimeUnit.SECONDS);
        SecondPolymorphicInstanceTestConfiguration secondCfg = (SecondPolymorphicInstanceTestConfiguration)rootConfig.polymorphicSubCfg();
        Assertions.assertEquals((Object)"second", (Object)secondCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal3", (Object)secondCfg.strVal().value());
        Assertions.assertEquals((int)0, (Integer)((Integer)secondCfg.intVal().value()));
        Assertions.assertEquals((long)0L, (Long)((Long)secondCfg.longVal().value()));
        SecondPolymorphicInstanceTestView secondView = (SecondPolymorphicInstanceTestView)secondCfg.value();
        Assertions.assertEquals((Object)"second", (Object)secondView.typeId());
        Assertions.assertEquals((Object)"strVal3", (Object)secondView.strVal());
        Assertions.assertEquals((int)0, (int)secondView.intVal());
        Assertions.assertEquals((long)0L, (long)secondView.longVal());
        rootConfig.polymorphicSubCfg().change(c -> c.convert(FirstPolymorphicInstanceTestChange.class)).get(1L, TimeUnit.SECONDS);
        firstCfg = (FirstPolymorphicInstanceTestConfiguration)rootConfig.polymorphicSubCfg();
        Assertions.assertEquals((Object)"first", (Object)firstCfg.typeId().value());
        Assertions.assertEquals((Object)"strVal3", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)0, (Integer)((Integer)firstCfg.intVal().value()));
    }

    @Test
    void testPolymorphicErrors() {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        PolymorphicTestConfiguration polymorphicCfg = rootConfig.polymorphicSubCfg();
        Assertions.assertThrows(ConfigurationReadOnlyException.class, () -> polymorphicCfg.typeId().update((Object)"second").get(1L, TimeUnit.SECONDS));
        Assertions.assertThrows(ExecutionException.class, () -> polymorphicCfg.change(c -> {
            FirstPolymorphicInstanceTestView firstView = (FirstPolymorphicInstanceTestView)((Object)c);
            c.convert(SecondPolymorphicInstanceTestChange.class);
            firstView.intVal();
        }).get(1L, TimeUnit.SECONDS));
        Assertions.assertThrows(ExecutionException.class, () -> polymorphicCfg.change(c -> {
            FirstPolymorphicInstanceTestChange firstChange = (FirstPolymorphicInstanceTestChange)c;
            c.convert(SecondPolymorphicInstanceTestChange.class);
            firstChange.changeIntVal(10);
        }).get(1L, TimeUnit.SECONDS));
    }

    @Test
    void testPolymorphicNamedConfigurationAdd() throws Exception {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        rootConfig.polymorphicNamedCfg().change(c -> c.create("0", c1 -> c1.convert(FirstPolymorphicNamedInstanceTestChange.class)).create("1", c1 -> c1.convert(SecondPolymorphicNamedInstanceTestChange.class).changeIntVal(1).changeLongVal(1L).changeStrVal("strVal1"))).get(1L, TimeUnit.SECONDS);
        FirstPolymorphicNamedInstanceTestConfiguration firstCfg = (FirstPolymorphicNamedInstanceTestConfiguration)rootConfig.polymorphicNamedCfg().get("0");
        Assertions.assertEquals((Object)"strVal", (Object)firstCfg.strVal().value());
        Assertions.assertEquals((int)0, (Integer)((Integer)firstCfg.intVal().value()));
        SecondPolymorphicNamedInstanceTestConfiguration secondCfg = (SecondPolymorphicNamedInstanceTestConfiguration)rootConfig.polymorphicNamedCfg().get("1");
        Assertions.assertEquals((Object)"strVal1", (Object)secondCfg.strVal().value());
        Assertions.assertEquals((int)1, (Integer)((Integer)secondCfg.intVal().value()));
        Assertions.assertEquals((long)1L, (Long)((Long)secondCfg.longVal().value()));
        FirstPolymorphicNamedInstanceTestView firstVal = (FirstPolymorphicNamedInstanceTestView)firstCfg.value();
        Assertions.assertEquals((Object)"strVal", (Object)firstVal.strVal());
        Assertions.assertEquals((int)0, (int)firstVal.intVal());
        firstVal = (FirstPolymorphicNamedInstanceTestView)((NamedListView)rootConfig.polymorphicNamedCfg().value()).get("0");
        Assertions.assertEquals((Object)"strVal", (Object)firstVal.strVal());
        Assertions.assertEquals((int)0, (int)firstVal.intVal());
        firstVal = (FirstPolymorphicNamedInstanceTestView)((TestRootView)rootConfig.value()).polymorphicNamedCfg().get("0");
        Assertions.assertEquals((Object)"strVal", (Object)firstVal.strVal());
        Assertions.assertEquals((int)0, (int)firstVal.intVal());
        SecondPolymorphicNamedInstanceTestView secondVal = (SecondPolymorphicNamedInstanceTestView)secondCfg.value();
        Assertions.assertEquals((Object)"strVal1", (Object)secondVal.strVal());
        Assertions.assertEquals((int)1, (int)secondVal.intVal());
        Assertions.assertEquals((long)1L, (long)secondVal.longVal());
        secondVal = (SecondPolymorphicNamedInstanceTestView)((NamedListView)rootConfig.polymorphicNamedCfg().value()).get("1");
        Assertions.assertEquals((Object)"strVal1", (Object)secondVal.strVal());
        Assertions.assertEquals((int)1, (int)secondVal.intVal());
        Assertions.assertEquals((long)1L, (long)secondVal.longVal());
        secondVal = (SecondPolymorphicNamedInstanceTestView)((TestRootView)rootConfig.value()).polymorphicNamedCfg().get("1");
        Assertions.assertEquals((Object)"strVal1", (Object)secondVal.strVal());
        Assertions.assertEquals((int)1, (int)secondVal.intVal());
        Assertions.assertEquals((long)1L, (long)secondVal.longVal());
    }

    @Test
    void testPolymorphicNamedConfigurationChange() throws Exception {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        rootConfig.polymorphicNamedCfg().change(c -> c.create("0", c1 -> c1.convert(FirstPolymorphicNamedInstanceTestChange.class))).get(1L, TimeUnit.SECONDS);
        FirstPolymorphicNamedInstanceTestConfiguration firstCfg = (FirstPolymorphicNamedInstanceTestConfiguration)rootConfig.polymorphicNamedCfg().get("0");
        firstCfg.intVal().update((Object)1).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (Integer)((Integer)firstCfg.intVal().value()));
        firstCfg.change(c -> ((FirstPolymorphicNamedInstanceTestChange)c).changeIntVal(2).changeStrVal("strVal2")).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (Integer)((Integer)firstCfg.intVal().value()));
        Assertions.assertEquals((Object)"strVal2", (Object)firstCfg.strVal().value());
        ((PolymorphicNamedTestConfiguration)rootConfig.polymorphicNamedCfg().get("0")).change(c -> c.convert(SecondPolymorphicNamedInstanceTestChange.class).changeLongVal(3L).changeIntVal(3).changeStrVal("strVal3")).get(1L, TimeUnit.SECONDS);
        SecondPolymorphicNamedInstanceTestConfiguration secondCfg = (SecondPolymorphicNamedInstanceTestConfiguration)rootConfig.polymorphicNamedCfg().get("0");
        Assertions.assertEquals((int)3, (Integer)((Integer)secondCfg.intVal().value()));
        Assertions.assertEquals((long)3L, (Long)((Long)secondCfg.longVal().value()));
        Assertions.assertEquals((Object)"strVal3", (Object)secondCfg.strVal().value());
    }

    @Test
    void testPolymorphicNamedConfigurationRemove() throws Exception {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        rootConfig.polymorphicNamedCfg().change(c -> c.create("0", c1 -> c1.convert(FirstPolymorphicNamedInstanceTestChange.class))).get(1L, TimeUnit.SECONDS);
        rootConfig.polymorphicNamedCfg().change(c -> c.delete("0")).get(1L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)rootConfig.polymorphicNamedCfg().get("0"));
    }

    @Test
    void testPolymorphicConfigurationNonDefaultValues() throws Exception {
        TestRootConfiguration rootConfig = (TestRootConfiguration)generator.instantiateCfg(TestRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        rootConfig.polymorphicSubCfg().change(c -> c.convert(NonDefaultPolymorphicInstanceTestChange.class).changeNonDefaultValue("foo")).get(1L, TimeUnit.SECONDS);
        PolymorphicTestView view = ((TestRootView)rootConfig.value()).polymorphicSubCfg();
        MatcherAssert.assertThat((Object)view, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NonDefaultPolymorphicInstanceTestView.class)));
        MatcherAssert.assertThat((Object)((NonDefaultPolymorphicInstanceTestView)view).nonDefaultValue(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    void testNestedConfigurationWithInjectedNameField() throws Exception {
        InjectedNameRootConfiguration rootCfg = (InjectedNameRootConfiguration)generator.instantiateCfg(InjectedNameRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        Assertions.assertThrows(ConfigurationReadOnlyException.class, () -> rootCfg.nested().name().update((Object)"test").get(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"nestedDefault", (Object)rootCfg.nested().name().value());
        Assertions.assertEquals((Object)"nestedDefault", (Object)((InjectedNameRootView)rootCfg.value()).nested().name());
        Assertions.assertEquals((Object)"nestedDefault", (Object)((InjectedNameView)rootCfg.nested().value()).name());
        Assertions.assertThrows(ConfigurationReadOnlyException.class, () -> rootCfg.nestedPoly().name().update((Object)"test").get(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)rootCfg.nestedPoly().name().value());
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)((InjectedNameRootView)rootCfg.value()).nestedPoly().name());
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)((PolyInjectedNameView)rootCfg.nestedPoly().value()).name());
        rootCfg.nestedPoly().change(c -> c.convert(PolyInst1InjectedNameChange.class)).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)rootCfg.nestedPoly().name().value());
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)((InjectedNameRootView)rootCfg.value()).nestedPoly().name());
        Assertions.assertEquals((Object)"nestedDefaultPoly", (Object)((PolyInjectedNameView)rootCfg.nestedPoly().value()).name());
    }

    @Test
    void testNestedNamedConfigurationWithInjectedNameField() throws Exception {
        InjectedNameRootConfiguration rootCfg = (InjectedNameRootConfiguration)generator.instantiateCfg(InjectedNameRootConfiguration.KEY, (DynamicConfigurationChanger)this.changer);
        rootCfg.nestedNamed().change(c -> c.create("0", c0 -> Assertions.assertEquals((Object)"0", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamed().change(c -> c.create(1, "1", c0 -> Assertions.assertEquals((Object)"1", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamed().change(c -> c.createOrUpdate("2", c0 -> Assertions.assertEquals((Object)"2", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamed().change(c -> c.createAfter("2", "3", c0 -> Assertions.assertEquals((Object)"3", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamed().change(c -> c.update("3", c0 -> Assertions.assertEquals((Object)"3", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamed().change(c -> Assertions.assertEquals((Object)"4", (Object)((InjectedNameView)c.rename("3", "4").get("4")).name())).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"0", (Object)((InjectedNameView)((InjectedNameRootView)rootCfg.value()).nestedNamed().get("0")).name());
        Assertions.assertEquals((Object)"1", (Object)((InjectedNameView)((NamedListView)rootCfg.nestedNamed().value()).get("1")).name());
        Assertions.assertEquals((Object)"2", (Object)((InjectedNameView)((InjectedNameConfiguration)rootCfg.nestedNamed().get("2")).value()).name());
        Assertions.assertEquals((Object)"4", (Object)((InjectedNameConfiguration)rootCfg.nestedNamed().get("4")).name().value());
        rootCfg.nestedNamedPoly().change(c -> c.create("p0", c0 -> Assertions.assertEquals((Object)"p0", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.create(1, "p1", c0 -> Assertions.assertEquals((Object)"p1", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.createOrUpdate("p2", c0 -> Assertions.assertEquals((Object)"p2", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.createAfter("p2", "p3", c0 -> Assertions.assertEquals((Object)"p3", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.update("p3", c0 -> Assertions.assertEquals((Object)"p3", (Object)c0.name()))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> Assertions.assertEquals((Object)"p4", (Object)((PolyInjectedNameView)c.rename("p3", "p4").get("p4")).name())).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"p0", (Object)((PolyInjectedNameView)((InjectedNameRootView)rootCfg.value()).nestedNamedPoly().get("p0")).name());
        Assertions.assertEquals((Object)"p1", (Object)((PolyInjectedNameView)((NamedListView)rootCfg.nestedNamedPoly().value()).get("p1")).name());
        Assertions.assertEquals((Object)"p2", (Object)((PolyInjectedNameView)((PolyInjectedNameConfiguration)rootCfg.nestedNamedPoly().get("p2")).value()).name());
        Assertions.assertEquals((Object)"p4", (Object)((PolyInjectedNameConfiguration)rootCfg.nestedNamedPoly().get("p4")).name().value());
        rootCfg.nestedNamedPoly().change(c -> c.update("p0", c0 -> c0.convert(PolyInst1InjectedNameChange.class))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.update("p1", c0 -> c0.convert(PolyInst1InjectedNameChange.class))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.update("p2", c0 -> c0.convert(PolyInst1InjectedNameChange.class))).get(1L, TimeUnit.SECONDS);
        rootCfg.nestedNamedPoly().change(c -> c.update("p4", c0 -> c0.convert(PolyInst1InjectedNameChange.class))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"p0", (Object)((PolyInjectedNameView)((InjectedNameRootView)rootCfg.value()).nestedNamedPoly().get("p0")).name());
        Assertions.assertEquals((Object)"p1", (Object)((PolyInjectedNameView)((NamedListView)rootCfg.nestedNamedPoly().value()).get("p1")).name());
        Assertions.assertEquals((Object)"p2", (Object)((PolyInjectedNameView)((PolyInjectedNameConfiguration)rootCfg.nestedNamedPoly().get("p2")).value()).name());
        Assertions.assertEquals((Object)"p4", (Object)((PolyInjectedNameConfiguration)rootCfg.nestedNamedPoly().get("p4")).name().value());
    }

    @PolymorphicConfigInstance(value="second")
    public static class PolyInst1InjectedNameConfigurationSchema
    extends PolyInjectedNameConfigurationSchema {
    }

    @PolymorphicConfigInstance(value="first")
    public static class PolyInst0InjectedNameConfigurationSchema
    extends PolyInjectedNameConfigurationSchema {
    }

    @PolymorphicConfig
    public static class PolyInjectedNameConfigurationSchema {
        public static final String FIRST = "first";
        public static final String SECOND = "second";
        @PolymorphicId(hasDefault=true)
        public String type = "first";
        @InjectedName
        public String name;
    }

    @Config
    public static class InjectedNameConfigurationSchema {
        @InjectedName
        public String name;
    }

    @ConfigurationRoot(rootName="testInjectedName")
    public static class InjectedNameRootConfigurationSchema {
        @Name(value="nestedDefault")
        @ConfigValue
        public InjectedNameConfigurationSchema nested;
        @NamedConfigValue
        public InjectedNameConfigurationSchema nestedNamed;
        @Name(value="nestedDefaultPoly")
        @ConfigValue
        public PolyInjectedNameConfigurationSchema nestedPoly;
        @NamedConfigValue
        public PolyInjectedNameConfigurationSchema nestedNamedPoly;
    }

    @PolymorphicConfigInstance(value="second")
    public static class SecondPolymorphicNamedInstanceTestConfigurationSchema
    extends PolymorphicNamedTestConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
        @Value(hasDefault=true)
        public long longVal = 0L;
    }

    @PolymorphicConfigInstance(value="first")
    public static class FirstPolymorphicNamedInstanceTestConfigurationSchema
    extends PolymorphicNamedTestConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
    }

    @PolymorphicConfig
    public static class PolymorphicNamedTestConfigurationSchema {
        @PolymorphicId(hasDefault=true)
        public String typeId;
        @Value(hasDefault=true)
        public String strVal = "strVal";
    }

    @PolymorphicConfigInstance(value="non_default")
    public static class NonDefaultPolymorphicInstanceTestConfigurationSchema
    extends PolymorphicTestConfigurationSchema {
        @Value
        public String nonDefaultValue;
    }

    @PolymorphicConfigInstance(value="second")
    public static class SecondPolymorphicInstanceTestConfigurationSchema
    extends PolymorphicTestConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
        @Value(hasDefault=true)
        public long longVal = 0L;
    }

    @PolymorphicConfigInstance(value="first")
    public static class FirstPolymorphicInstanceTestConfigurationSchema
    extends PolymorphicTestConfigurationSchema {
        @Value(hasDefault=true)
        public int intVal = 0;
    }

    @PolymorphicConfig
    public static class PolymorphicTestConfigurationSchema {
        static final String FIRST = "first";
        static final String SECOND = "second";
        static final String NON_DEFAULT = "non_default";
        @PolymorphicId(hasDefault=true)
        public String typeId = "first";
        @Value(hasDefault=true)
        public String strVal = "strVal";
    }

    @InternalConfiguration
    public static class ExtendedSecondTestConfigurationSchema
    extends TestConfigurationSchema {
        @Value(hasDefault=true)
        public int i1 = 0;
    }

    @InternalConfiguration
    public static class ExtendedTestConfigurationSchema
    extends TestConfigurationSchema {
        @Value(hasDefault=true)
        public String str3 = "str3";
    }

    @Config
    public static class TestConfigurationSchema {
        @Value(hasDefault=true)
        public int i0 = 0;
        @Value(hasDefault=true)
        public String str2 = "str2";
    }

    @InternalConfiguration
    public static class ExtendedSecondTestRootConfigurationSchema
    extends TestRootConfigurationSchema {
        @Value(hasDefault=true)
        public int i1 = 0;
    }

    @InternalConfiguration
    public static class ExtendedTestRootConfigurationSchema
    extends TestRootConfigurationSchema {
        @Value(hasDefault=true)
        public String str1 = "str1";
    }

    @ConfigurationRoot(rootName="test")
    public static class TestRootConfigurationSchema {
        @Value(hasDefault=true)
        public int i0 = 0;
        @Value(hasDefault=true)
        public String str0 = "str0";
        @ConfigValue
        public TestConfigurationSchema subCfg;
        @NamedConfigValue
        public TestConfigurationSchema namedCfg;
        @ConfigValue
        public PolymorphicTestConfigurationSchema polymorphicSubCfg;
        @NamedConfigValue
        public PolymorphicNamedTestConfigurationSchema polymorphicNamedCfg;
    }
}

