/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

public class TestConfigurationChanger
extends ConfigurationChanger {
    private final ConfigurationAsmGenerator cgen;

    public TestConfigurationChanger(ConfigurationAsmGenerator cgen, Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators, ConfigurationStorage storage, Collection<Class<?>> internalSchemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        super((oldRoot, newRoot, revision, notificationNumber) -> CompletableFuture.completedFuture(null), rootKeys, validators, storage);
        this.cgen = cgen;
        Map internalExtensions = ConfigurationUtil.internalSchemaExtensions(internalSchemaExtensions);
        Map polymorphicExtensions = ConfigurationUtil.polymorphicSchemaExtensions(polymorphicSchemaExtensions);
        rootKeys.forEach(key -> cgen.compileRootSchema(key.schemaClass(), internalExtensions, polymorphicExtensions));
    }

    public InnerNode createRootNode(RootKey<?, ?> rootKey) {
        return this.cgen.instantiateNode(rootKey.schemaClass());
    }
}

